// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.

define(['hpsum/presenter/switch/SwitchPresenter',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpPlot'],
function(presenter, localizer) { "use strict";

    var SwitchUtilizationFlyoutView = (function() {
      
        /**
         * Constructor
         */
        function SwitchUtilizationFlyoutView() {
          
            function deltaTick(tick, axis) {
                if (0 === tick) {
                    return 'now';
                } else {
                    return tick + ' m';
                }
            }
          
            /**
             * @public
             */
            this.stop = function () {
                
            };
            
            this.start = function (anchor, flyout) {
                var deltas = [0, -5, -10, -15, -20, -25];
                var data1 = [[-25, 2], [-20, 1], [-15, 3], [-10, 5], [-5, 4], [0, 6]];
                var data2 = [[-25, 3], [-20, 2], [-15, 1], [-10, 4], [-5, 3], [0, 2]];
                $('#tour-port-name', flyout).text($(anchor).attr('data-port-name'));
                $.hpPlot($("#tour-uplink-plot", flyout), [
                        {label: localizer.getString('hpsum.switchUI.transmitted'), data: data1},
                        {label: localizer.getString('hpsum.switchUI.received'), data: data2}
                    ], {
                        xaxis: {ticks: deltas, tickFormatter: deltaTick},
                        yaxis: {min: 0.0, max: 10.0},
                        legend: { show: true, container: $('#tour-uplink-plot-legend', flyout) }
                    });
                    
                $('#tour-uplink-plot-legend table', flyout).prepend('<thead><tr><th></th><th></th><th class="hp-sidebar">' + localizer.getString('hpsum.switchUI.average') + '</th></tr></thead>');
                $('#tour-uplink-plot-legend table tbody tr', flyout).each(function (index, row) {
                    $(row).append('<td>4.3 Gb/s</td>');
                });
            };
        }

        return new SwitchUtilizationFlyoutView();
    }());
    
    return SwitchUtilizationFlyoutView;
});
