@echo off
setlocal

SET SUM_ROOT=%~dp0
SET SUM_CMD_ARGS=%*
set newcmdcmdline=%cmdcmdline:"=-%
set withincmd=1
echo %newcmdcmdline% | find /i "cmd /c --%~dpf0%-"
if %errorlevel% EQU 0 set withincmd=0
:: if %withincmd% EQU 0 echo This batch-file: %~dpf0 was executed directly (from Windows Explorer, ...).
:: if %withincmd% EQU 1 echo This batch-file: %~dpf0 was executed from within a Command Prompt

:: Select 32-bit or 64-bit
SET HostIs64Bit=%ProgramFiles(x86)%
IF "%HostIs64Bit%"=="" (
    set SUM_ARCH=x86
) ELSE (
    set SUM_ARCH=x64
)

set DEBUGLOGDIR=0
:loop
IF NOT "%~1"=="" (
rem Handle debuglog directory
    IF "%~1"=="/debuglogdir" (
        SET DEBUGLOGDIR=1
		echo %DEBUGLOGDIR%
        SHIFT
    )	
	SHIFT   
	GOTO :loop
)

IF %DEBUGLOGDIR% NEQ 1 (
  SET "SUM_CMD_ARGS=!SUM_CMD_ARGS! /debuglogdir !SUM_ROOT!" 
)
set SUM_MIGRATION="%SUM_ROOT%%SUM_ARCH%\sum_migration_%SUM_ARCH%.exe"

IF NOT EXIST %SUM_MIGRATION% (
    @echo Unable to locate %SUM_MIGRATION%
    if %withincmd% EQU 0 (
        call :delay
    )
    set ERRORCODE=-4
    goto :Exit
)

cls

:run
%SUM_MIGRATION% %*
set ERRORCODE=%ERRORLEVEL%

:: the acutal binary should have displayed an error
:: message.  We still want to delay to allow
:: people who started by clicking on the icon
:: a chance to see the message
IF %ERRORCODE% NEQ 0 (
    if %withincmd% EQU 0 (
        call :delay
    )
    goto :Exit
)    

call :delay
goto :Exit

:delay
where ping > nul 2>&1
IF %ERRORLEVEL% NEQ 0 (
    pause
) else (
    @echo Pausing for 10 seconds ...
    ping -n 11 127.0.0.1 > nul
)
goto :EOF

:Exit
exit /b %ERRORCODE%
