#!/bin/bash
#######################################
# Migration tool script 
# Smart Update Manager
######################################

OS=$(`echo uname` | tr '[a-z]' '[A-Z]')
ARCH=$(`echo uname -m` | tr '[a-z]' '[A-Z]')

HPUX=`uname | grep "HP-UX"`

delay ()
{
   echo "Pausing  for $1 seconds"
   sleep $1
}

export DEBUGLOGDIR=0
function ParseCmdLine()
{
    ARGS=("$@")
    # get total subscripts in an array
    total=${#ARGS[*]}
   for (( i=0; i<=$(( $total -1 )); i++ ))
    do
        if [ "${ARGS[$i]}" == "--debuglogdir" ]; then
		i=`expr $i + 1`
	   debug_dir=${ARGS[$i]}   
	   DEBUGLOGDIR=1   
	   break;
	   fi
	done
}

ParseCmdLine $@ 
if [ ! -z "${HPUX}" ]; then
    echo "Migration tool is not supported on HPUX"
elif [ "$OS" == "LINUX" ]; then
	if [ "$ARCH" == "X86_64" ]; then
            if [ -a ./x64/sum_migration_x64 ]; then
                        if [ $DEBUGLOGDIR -eq 0 ]; then
				./x64/sum_migration_x64
			else
				./x64/sum_migration_x64 "--debuglogdir" $debug_dir
			fi
            else
                echo "Could not find migration tool at : x64/sum_migration_x64"
                delay 10
                exit 1
            fi
    else 
	    if [ -a  ./x86/sum_bin_x86 ]; then
			if [ $DEBUGLOGDIR -eq 0 ]; then
				./x86/sum_migration_x86
			else
				./x86/sum_migration_x86 "--debuglogdir" $debug_dir
			fi
	    else
	        echo "Could not find migration tool at : x86/sum_bin_x86"
	        delay 10
  	        exit 1
	    fi
    fi
else
	echo "SUM migration is not supported on $OS"
fi

delay 10
exit 0
