/*
 * Decompiled with CFR 0.152.
 */
package com.avenda.platform.licensing.validator;

import com.avenda.platform.licensing.validator.LicenseValidator;
import com.avenda.platform.licensing.validator.ShowLicense;
import com.avenda.tips.admin.beans.license.LicenseInfo;
import com.avenda.tips.utils.PrintUtils;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallLicense {
    private static final String USAGE = "InstallLicense <ProductId> <LicenseKey>";
    private static final String LICENSE_UPDATOR_LOG4J_FILE = "/usr/local/avenda/common/etc/licenseUpdatorLog4j2.xml";
    private static final Logger log = LoggerFactory.getLogger(ShowLicense.class);

    public static void main(String[] args) {
        int ret = 1;
        String msg = null;
        if (args.length != 2) {
            System.out.println("ERROR - Invalid usage");
            System.out.println(USAGE);
            System.exit(ret);
        }
        String productIdStr = args[0];
        String licenseKey = args[1];
        Configurator.initialize(null, (String)LICENSE_UPDATOR_LOG4J_FILE);
        try {
            LicenseValidator lvi = new LicenseValidator();
            Integer productId = new Integer(productIdStr);
            log.debug("Installing the license for the product Id=" + productIdStr);
            LicenseInfo licInfo = lvi.addLicense(productId, licenseKey);
            log.debug("Printing the LicenseInfo=" + PrintUtils.printObject((Object)licInfo));
            ret = 0;
        }
        catch (Exception e) {
            System.out.println("ERROR: Failed to install the license " + licenseKey + " for product " + productIdStr + " " + e.getMessage());
            log.error(msg, (Throwable)e);
        }
        System.exit(ret);
    }
}

