/*
 * Decompiled with CFR 0.152.
 */
package com.avenda.platform.licensing.validator;

import com.avenda.platform.licensing.validator.LicenseValidator;
import com.avenda.tips.admin.beans.license.LicenseInfo;
import com.avenda.tips.utils.extexec.ExecInterceptor;
import com.avenda.tips.utils.extexec.ProcessExec;
import java.util.Arrays;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseDecoder {
    private static final String USAGE = "LicenseDecoder <ProductName> <ProductId> <LicenseKey>";
    private static final String LICENSE_HANDLER_SCRIPT = "/usr/local/avenda/tips/bin/licensehandler.py";
    private static final String LICENSE_UPDATOR_LOG4J_FILE = "/usr/local/avenda/common/etc/licenseUpdatorLog4j2.xml";
    private static final Logger log = LoggerFactory.getLogger(LicenseDecoder.class);

    public static void main(String[] args) {
        int ret = 1;
        String msg = null;
        if (args.length != 4) {
            System.out.println("ERROR - Invalid usage");
            System.out.println(USAGE);
            System.exit(ret);
        }
        boolean numLicenses = false;
        Object licenses = null;
        String productName = args[0];
        String productIdStr = args[1];
        String licenseKey = args[2];
        String action = args[3];
        String oldKey = "";
        Configurator.initialize(null, (String)LICENSE_UPDATOR_LOG4J_FILE);
        try {
            LicenseValidator lvi = new LicenseValidator();
            Integer productId = new Integer(productIdStr);
            log.debug("Decoding the license for product = " + productName);
            LicenseInfo li = lvi.decodeLicense(productId, productName, licenseKey);
            if (action.equals("update")) {
                Scanner scan = new Scanner(System.in);
                System.out.println("Enter the old license key to be updated: ");
                oldKey = scan.next();
            }
            Map ld = li.getLicenseDetailsMap();
            ExecInterceptor incpr = new ExecInterceptor(true);
            String[] cmdArray = new String[]{"python2", LICENSE_HANDLER_SCRIPT, productIdStr, productName, li.getLicenseKey(), li.getLicenseType(), li.getDuration().toString(), li.getNumUsers().toString(), li.getCustomerId(), li.getHardwareType(), action, (String)ld.get("LicenseInstallDate"), (String)ld.get("LicenseDurationUnits"), (String)ld.get("LicenseEmbedType"), (String)ld.get("LicenseUserDatatype"), (String)ld.get("LicenseActivationCheckCount"), (String)ld.get("LicenseValidityCheckCount"), oldKey};
            ret = ProcessExec.exec((ExecInterceptor)incpr, (String[])cmdArray);
            StringBuffer errorStreamMessage = new StringBuffer();
            for (String str : incpr.stdOut()) {
                errorStreamMessage.append(str);
                errorStreamMessage.append(System.getProperty("line.separator"));
            }
            System.out.println(errorStreamMessage);
            log.info("Command " + Arrays.asList(cmdArray).toString() + ",status = " + ret);
            log.info("Error/Output of the command execution = " + errorStreamMessage);
            if (ret == 0) {
                msg = "Updated the license successfully";
                log.debug(msg);
                System.out.println("INFO - " + msg);
            } else {
                msg = "Failed to update the license";
                log.error(msg);
                System.out.println("ERROR - " + msg);
            }
        }
        catch (Exception e) {
            msg = "Failed to decode the license. ";
            System.out.println("ERROR - " + msg + e.getMessage());
            log.error(msg, (Throwable)e);
        }
        System.exit(ret);
    }
}

