/*
 * Decompiled with CFR 0.152.
 */
package com.avenda.platform.licensing.validator;

import com.avenda.platform.licensing.validator.LicenseValidator;
import com.avenda.tips.admin.beans.license.LicenseInfo;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseUpdator {
    private static final String USAGE = "LicenseUpdator <ProductName> <ProductId> <LicenseKey>";
    private static final String LICENSE_UPDATOR_LOG4J_FILE = "/usr/local/avenda/common/etc/licenseUpdatorLog4j2.xml";
    private static final Logger log = LoggerFactory.getLogger(LicenseUpdator.class);

    public static void main(String[] args) {
        int ret = 1;
        String msg = null;
        if (args.length != 3) {
            System.out.println("ERROR - Invalid usage");
            System.out.println(USAGE);
            System.exit(ret);
        }
        String productName = args[0];
        String productIdStr = args[1];
        String licenseKey = args[2];
        Configurator.initialize(null, (String)LICENSE_UPDATOR_LOG4J_FILE);
        try {
            LicenseValidator lvi = new LicenseValidator();
            Integer productId = new Integer(productIdStr);
            log.debug("Decoding the license " + licenseKey);
            LicenseInfo li = lvi.decodeLicense(productId, licenseKey);
            lvi.addLicense(productId, li.getLicenseKey());
            msg = "Updated the license successfully";
            log.debug(msg);
            System.out.println("INFO - " + msg);
        }
        catch (Exception e) {
            msg = "Failed to update the license. ";
            System.out.println("ERROR - " + msg + e.getMessage());
            log.error(msg, (Throwable)e);
        }
        System.exit(ret);
    }
}

