/*
 * Decompiled with CFR 0.152.
 */
package com.avenda.platform.licensing.validator;

import com.avenda.platform.activation.ActivationClient;
import com.avenda.platform.licensing.common.AppServerType;
import com.avenda.platform.licensing.common.BaseLicenseDetails;
import com.avenda.platform.licensing.common.InactiveLicenseException;
import com.avenda.platform.licensing.common.InvalidLicenseException;
import com.avenda.platform.licensing.common.LicenseSupportException;
import com.avenda.platform.licensing.common.LicensingException;
import com.avenda.platform.licensing.common.NoLicenseException;
import com.avenda.platform.licensing.decoder.LicenseDecoder;
import com.avenda.platform.licensing.validator.LicenseFeatures;
import com.avenda.platform.licensing.validator.LicenseType;
import com.avenda.platform.licensing.validator.LicenseValidatorIf;
import com.avenda.tips.admin.beans.license.ActivationStatusType;
import com.avenda.tips.admin.beans.license.AppLicenseInfo;
import com.avenda.tips.admin.beans.license.AppRegistration;
import com.avenda.tips.admin.beans.license.LicenseInfo;
import com.avenda.tips.admin.beans.license.LicenseStatusType;
import com.avenda.tips.common.TipsException;
import com.avenda.tips.utils.AppProperties;
import com.avenda.tips.utils.CommonCloudUtil;
import com.avenda.tips.utils.StringUtils;
import com.avenda.tips.utils.extexec.ExecInterceptor;
import com.avenda.tips.utils.extexec.ProcessExec;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseValidator
extends ActivationClient
implements LicenseValidatorIf {
    private static final Logger log = LoggerFactory.getLogger(LicenseValidator.class);
    private static final String COMMON_ROOT = "/usr/local/avenda/common/";
    private static final String PLATFORM_LICENSING = "/usr/local/avenda/common/license/";
    private static final String APP_LICENSE_SUFFIX = "-license-public.sign";
    private static final String APP_LICENSE_SUFFIX_V5 = "-v5-license-public.sign";
    private static final String SYSTEM_EVENT_LOGGER = "/usr/local/avenda/tips/bin/log-local-system-event.sh";
    private static final int PAC_ID = 101;
    private static final int AU_ID = 12;
    private static final int ENTRY_ID = 11;
    private static final int LICENSE_KEY_LENGTH = 684;
    private String appServerType;

    public LicenseValidator() {
        try {
            AppProperties prop = CommonCloudUtil.getHardwareVersionProperties();
            String hwVersion = prop.getProperty("HARDWARE_VERSION").replace("\"", "");
            log.debug("Hardware version=" + hwVersion);
            this.appServerType = hwVersion;
            log.debug("Loaded the appServerType=" + this.appServerType);
        }
        catch (Exception e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public LicenseInfo[] getLicenseInfo(int productId) {
        LicenseInfo[] licenses = null;
        try {
            ArrayList<LicenseInfo> licenseInfoList;
            log.info("Fetching LicenseInformation for productId=" + productId);
            AppRegistration ar = this.getAppRegistrationInfo(productId);
            int numExpiredLicenses = 0;
            boolean licActive = false;
            if (ar != null) {
                AppLicenseInfo[] appLicenses = this.getAppLicenses(productId);
                licenseInfoList = new ArrayList<LicenseInfo>();
                for (AppLicenseInfo ali : appLicenses) {
                    Integer licenseId = ali.getLicenseId();
                    if (licenseId == null) {
                        throw new NoLicenseException("No license configured for product Id " + productId);
                    }
                    log.info("Fetched LicenseId=" + licenseId + " for productId=" + productId);
                    LicenseInfo licenseInfo = LicenseValidator.getLicenseHandler((int)productId).getLicenseDetails(licenseId.intValue(), true);
                    if (licenseInfo != null) {
                        this.decodeLicenseInternal(ar, licenseInfo.getLicenseKey());
                        if (this.isLicenseExpired(licenseInfo, productId, licenseInfo.getDuration(), this.getLicenseInstallDate(licenseInfo))) {
                            String licenseCause = this.getLicenseCause(licenseInfo);
                            if (licenseCause == null) {
                                licenseCause = "License is not active";
                            }
                            log.warn("Found expired license " + licenseInfo.getId() + ". License expiry cause - " + licenseCause);
                            ++numExpiredLicenses;
                            continue;
                        }
                        licActive = true;
                        log.debug("Adding the license details=" + licenseInfo.getId() + " for the product with id=" + productId);
                        licenseInfoList.add(licenseInfo);
                        continue;
                    }
                    throw new LicensingException("Invalid license found with Id " + licenseId);
                }
                if (licActive) {
                    this.setProductLicenseStatus(productId, LicenseStatusType.Active);
                } else if (numExpiredLicenses > 0) {
                    throw new InactiveLicenseException("Inactive License for product Id " + productId);
                }
                if (licenseInfoList.size() == 0) {
                    throw new NoLicenseException("No license configured for product Id " + productId);
                }
            } else {
                throw new LicensingException("Invalid product specified for Id " + productId);
            }
            licenses = licenseInfoList.toArray(new LicenseInfo[0]);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
        return licenses;
    }

    @Override
    public LicenseInfo[] getProfilerLicenseInfo(int productId) {
        LicenseInfo[] licenses = null;
        try {
            ArrayList<LicenseInfo> licenseInfoList;
            log.info("Fetching LicenseInformation for productId=" + productId);
            AppRegistration ar = this.getAppRegistrationInfo(productId);
            if (ar != null) {
                AppLicenseInfo[] appLicenses = this.getAppLicenses(productId);
                licenseInfoList = new ArrayList<LicenseInfo>();
                for (AppLicenseInfo ali : appLicenses) {
                    Integer licenseId = ali.getLicenseId();
                    if (licenseId == null) {
                        throw new NoLicenseException("No license configured for product Id " + productId);
                    }
                    log.info("Fetched LicenseId=" + licenseId + " for productId=" + productId);
                    LicenseInfo licenseInfo = LicenseValidator.getLicenseHandler((int)productId).getLicenseDetails(licenseId.intValue(), true);
                    if (licenseInfo != null) {
                        this.decodeLicenseInternal(ar, licenseInfo.getLicenseKey());
                        if (this.isLicenseExpired(licenseInfo, productId, licenseInfo.getDuration(), this.getLicenseInstallDate(licenseInfo))) {
                            String licenseCause = this.getLicenseCause(licenseInfo);
                            if (licenseCause == null) {
                                licenseCause = "License is not active";
                            }
                            log.warn("Found expired license " + licenseInfo.getId() + ". License expiry cause - " + licenseCause);
                        }
                    } else {
                        throw new LicensingException("Invalid license found with Id " + licenseId);
                    }
                    log.debug("Adding the license details=" + licenseInfo.getId() + " for the product with id=" + productId);
                    licenseInfoList.add(licenseInfo);
                }
                if (licenseInfoList.size() == 0) {
                    throw new NoLicenseException("No license configured for product Id " + productId);
                }
            } else {
                throw new LicensingException("Invalid product specified for Id " + productId);
            }
            licenses = licenseInfoList.toArray(new LicenseInfo[0]);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
        return licenses;
    }

    private AppLicenseInfo[] fetchAppLicenseInfo(int productId, boolean all) {
        AppLicenseInfo[] appLicenses = null;
        try {
            ArrayList<AppLicenseInfo> appLicenseList;
            log.info("Fetching AppLicenseInformation for productId=" + productId);
            AppRegistration ar = this.getAppRegistrationInfo(productId);
            if (ar != null) {
                appLicenseList = new ArrayList<AppLicenseInfo>();
                AppLicenseInfo[] alis = this.getAppLicenses(productId);
                Integer licenseId = null;
                int numExpiredLicenses = 0;
                boolean licActive = false;
                for (AppLicenseInfo ali : alis) {
                    licenseId = ali.getLicenseId();
                    if (licenseId == null) {
                        throw new NoLicenseException("No license configured for product Id " + productId);
                    }
                    log.info("Fetched LicenseId=" + licenseId + " for productId=" + productId);
                    LicenseInfo licenseInfo = LicenseValidator.getLicenseHandler((int)productId).getLicenseDetails(licenseId.intValue(), true);
                    if (licenseInfo != null) {
                        List licenseInfoList = ali.getLicenseInfoList();
                        if (licenseInfoList.size() == 0) {
                            throw new NoLicenseException("No license associated with the product Id " + productId);
                        }
                        this.decodeLicenseInternal(ar, licenseInfo.getLicenseKey());
                        if (!all) {
                            if (this.isLicenseExpired(licenseInfo, productId, licenseInfo.getDuration(), this.getLicenseInstallDate(licenseInfo))) {
                                String licenseCause = this.getLicenseCause(licenseInfo);
                                if (licenseCause == null) {
                                    licenseCause = "License is not active";
                                }
                                log.warn("Found expired license " + licenseInfo.getId() + ". License expiry cause - " + licenseCause);
                                ++numExpiredLicenses;
                                continue;
                            }
                            licActive = true;
                        }
                        appLicenseList.add(ali);
                        continue;
                    }
                    throw new LicensingException("Invalid license found with Id " + licenseId);
                }
                if (numExpiredLicenses > 0 && licActive) {
                    this.setProductLicenseStatus(productId, LicenseStatusType.Active);
                }
            } else {
                throw new LicensingException("Invalid product specified for Id " + productId);
            }
            appLicenses = appLicenseList.toArray(new AppLicenseInfo[0]);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
        return appLicenses;
    }

    public AppLicenseInfo[] getAppLicenseInfo(int productId, boolean all) {
        return this.fetchAppLicenseInfo(productId, all);
    }

    @Override
    public AppLicenseInfo[] getAppLicenseInfo(int productId) {
        return this.fetchAppLicenseInfo(productId, false);
    }

    @Override
    public LicenseInfo decodeLicense(int productId, String licenseKey) {
        try {
            log.info("Decoding the license for productId=" + productId);
            BaseLicenseDetails bld = this.decodeLicenseInternal(productId, licenseKey);
            return this.newLicenseInfo(bld);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public LicenseInfo decodeLicense(int productId, String productName, String licenseKey) {
        try {
            log.info("Decoding the license for productId=" + productId + " productName=" + productName);
            LicenseVersionSuffix lvs = new LicenseVersionSuffix(productId, licenseKey);
            String signPubKeyFile = PLATFORM_LICENSING + productName + lvs.getSuffix();
            int encVersion = lvs.getEncVersion();
            LicenseDecoder decoder = new LicenseDecoder();
            BaseLicenseDetails bld = decoder.decode(licenseKey, signPubKeyFile, encVersion);
            return this.newLicenseInfo(bld);
        }
        catch (Exception e) {
            throw new LicensingException((Throwable)e);
        }
    }

    public boolean checkLicenseKeyInUse(int productId, String licenseKey) {
        String licenseNoSpaces = licenseKey.replaceAll("\\s", "");
        int startIndex = licenseNoSpaces.indexOf("KEY-----") + 8;
        String base64LicenseKey = licenseNoSpaces.substring(startIndex, startIndex + 684);
        log.debug("Checking License key status...");
        AppLicenseInfo[] appLicenses = this.getAppLicenses(productId);
        if (appLicenses != null) {
            for (AppLicenseInfo appLicenseInfo : appLicenses) {
                List licenseInfoList = appLicenseInfo.getLicenseInfoList();
                log.debug("Read " + licenseInfoList.size() + " licenseInfo for productId=" + productId);
                for (LicenseInfo licenseInfo : licenseInfoList) {
                    String licenseNoSpacesCurrent = licenseInfo.getLicenseKey().replaceAll("\\s", "");
                    int index = licenseNoSpacesCurrent.indexOf("KEY-----");
                    if (index == -1) {
                        throw new TipsException("License has expired and it needs to be deleted since it is of invalid format. Contact support for assistance");
                    }
                    int startIndexTemp = index + 8;
                    String base64LicenseKeyCurrent = licenseNoSpacesCurrent.substring(startIndexTemp, startIndexTemp + 684);
                    if (!base64LicenseKey.toLowerCase().equals(base64LicenseKeyCurrent.toLowerCase())) continue;
                    log.debug("This License key is already present in the system");
                    return true;
                }
            }
        }
        return false;
    }

    public int fetchTotalCount(int productId) {
        int totalCount = 0;
        LicenseInfo[] appLicenseInfo = null;
        try {
            appLicenseInfo = this.getLicenseInfo(productId);
        }
        catch (Exception e) {
            log.debug("App license not found for product Id:" + productId);
            throw new NoLicenseException("No license associated with the product Id " + productId);
        }
        try {
            if (appLicenseInfo != null) {
                for (LicenseInfo aLicInfo : appLicenseInfo) {
                    log.debug("Fetched App License type={" + aLicInfo.getLicenseType() + "}");
                    totalCount += aLicInfo.getNumUsers().intValue();
                }
                return totalCount;
            }
            log.debug("App license not found for product Id:" + productId);
            throw new NoLicenseException("No license associated with the product Id " + productId);
        }
        catch (Exception e) {
            throw new LicensingException((Throwable)e);
        }
    }

    public boolean checkAccessUpgradeValidity(int newNumUsers, int oldNumUsers) {
        int entryTotalCount = 0;
        try {
            entryTotalCount = this.fetchTotalCount(11);
            if (entryTotalCount == 0) {
                log.debug("Entry license total count is 0, addition of AU license NOT allowed, return false");
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof NoLicenseException) {
                log.error("Active Entry license not found so add/update of AU license NOT allowed, return false ");
                return false;
            }
            throw new LicensingException((Throwable)e);
        }
        int accessUpgradeTotalCount = 0;
        try {
            accessUpgradeTotalCount = this.fetchTotalCount(12);
            if (accessUpgradeTotalCount + newNumUsers - oldNumUsers > entryTotalCount) {
                log.debug(" AU count will exceed Entry count, operation not allowed");
                return false;
            }
            log.debug("Entry count is :" + entryTotalCount + " AU total count is :" + (accessUpgradeTotalCount + newNumUsers - oldNumUsers));
            return true;
        }
        catch (Exception e) {
            if (e instanceof NoLicenseException && newNumUsers <= entryTotalCount) {
                log.debug("AccessUpgrade license not found but new AU count less than Entry so operation allowed");
                return true;
            }
            return false;
        }
    }

    @Override
    public LicenseInfo updateLicense(int productId, String oldLicenseKey, String newLicenseKey) {
        try {
            LicenseInfo oldLicenseInfo = this.getProductLicenseInfo(productId, oldLicenseKey);
            if (oldLicenseInfo == null) {
                log.error("No matching license found for key " + oldLicenseKey + " for the product with Id " + productId);
                throw new LicensingException("License key not found");
            }
            LicenseInfo newLicenseInfo = this.validateLicense(productId, newLicenseKey);
            if (newLicenseInfo != null && newLicenseKey.length() <= 65) {
                log.debug(" Valid short length License key is disallowed ");
                throw new LicenseSupportException("Contact support to obtain a ClearPass enhanced license key");
            }
            if (productId == 12) {
                boolean validAccessUpgradeCount = false;
                int oldAULicenseCount = 0;
                try {
                    String licStatus = this.getLicenseStatus(oldLicenseInfo);
                    if (licStatus == null || !licStatus.equals(LicenseStatusType.Expired.name())) {
                        oldAULicenseCount = oldLicenseInfo.getNumUsers();
                        log.debug("Replacing an Active license with numUserCount" + oldAULicenseCount);
                    }
                    int newAULicenseCount = newLicenseInfo.getNumUsers();
                    log.debug("New AccessUpgrade license count is :" + newAULicenseCount);
                    if (newAULicenseCount < oldAULicenseCount) {
                        log.debug("Replacing an active AccessUpgrade license with a lower count license is not allowed");
                        throw new LicenseSupportException("Replacing an active AccessUpgrade license with a lower license count not allowed");
                    }
                    validAccessUpgradeCount = this.checkAccessUpgradeValidity(newAULicenseCount, oldAULicenseCount);
                    log.debug("Return value from checkAccessUpgradeValidity :" + validAccessUpgradeCount);
                    if (!validAccessUpgradeCount) {
                        throw new LicenseSupportException("Total count of AccessUpgrade license cannot exceed that of Entry license");
                    }
                }
                catch (Exception e) {
                    throw new LicensingException((Throwable)e);
                }
            }
            log.debug("Deleting existing license key for productId: " + productId);
            LicenseValidator.getLicenseHandler((int)productId).deleteExistingLicense(productId, oldLicenseKey);
            return this.updateLicense(productId, newLicenseInfo);
        }
        catch (TipsException ex) {
            throw new LicensingException((Throwable)ex);
        }
    }

    @Override
    public LicenseInfo addLicense(int productId, String licenseKey) {
        LicenseInfo licenseInfo = this.validateLicense(productId, licenseKey);
        if (licenseInfo != null && licenseKey.length() <= 65) {
            log.debug(" Valid License key of short length is disallowed ");
            throw new LicenseSupportException("Contact support to obtain a ClearPass enhanced license key");
        }
        if (productId == 12) {
            boolean validAccessUpgradeCount = false;
            int oldAULicenseCount = 0;
            int newAULicenseCount = licenseInfo.getNumUsers();
            try {
                validAccessUpgradeCount = this.checkAccessUpgradeValidity(newAULicenseCount, oldAULicenseCount);
                log.debug(" Check allowed AU count returned : " + validAccessUpgradeCount);
                if (!validAccessUpgradeCount) {
                    throw new LicenseSupportException("Total count of AccessUpgrade license cannot exceed that of Entry license");
                }
            }
            catch (Exception e) {
                throw new LicensingException((Throwable)e);
            }
        }
        return this.updateLicense(productId, licenseInfo);
    }

    private LicenseInfo updateLicense(int productId, LicenseInfo licenseInfo) {
        try {
            LicenseValidator.getLicenseHandler((int)productId).addLicenseInfo(productId, licenseInfo);
            log.debug("Printing the License Id=" + licenseInfo.getId().toString());
            try {
                this.resetActivation(productId, false);
            }
            catch (Exception v3) {
                // empty catch block
            }
            return licenseInfo;
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public boolean isLicenseActive(int productId, String licenseKey) {
        try {
            log.info("Checking isLicenseActive for productId=" + productId);
            AppRegistration ar = this.getAppRegistrationInfo(productId);
            if (ar != null) {
                AppLicenseInfo[] appLicenses = this.getAppLicenses(productId);
                LicenseInfo licenseInfo = null;
                AppLicenseInfo ali = null;
                if (appLicenses != null) {
                    block2: for (AppLicenseInfo appLicenseInfo : appLicenses) {
                        List licenseInfoList = appLicenseInfo.getLicenseInfoList();
                        log.debug("Read " + licenseInfoList.size() + " licenseInfo for productId=" + productId);
                        for (LicenseInfo licInfo : licenseInfoList) {
                            if (!licenseKey.toLowerCase().equals(licInfo.getLicenseKey().toLowerCase())) continue;
                            licenseInfo = licInfo;
                            ali = appLicenseInfo;
                            continue block2;
                        }
                    }
                }
                if (licenseInfo == null) {
                    throw new NoLicenseException("No license configured for product Id " + productId);
                }
                Integer licenseId = licenseInfo.getId();
                log.info("Fetched License id=" + licenseId + " for productId=" + productId);
                this.decodeLicenseInternal(ar, licenseInfo.getLicenseKey());
                log.debug("License Type=" + licenseInfo.getLicenseType());
                return !this.isLicenseExpired(licenseInfo, productId, licenseInfo.getDuration(), ali.getActivationDate());
            }
            throw new LicensingException("Invalid product specified for Id " + productId);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public LicenseStatusType isProductActive(int productId) {
        try {
            log.info("Checking isLicenseActive for productId=" + productId);
            AppRegistration ar = this.getAppRegistrationInfo(productId);
            if (ar != null) {
                LicenseStatusType lsType = ar.getLicenseStatus();
                return lsType;
            }
            throw new LicensingException("Invalid product specified for Id " + productId);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    public Integer getLicenseId(int productId) {
        AppRegistration ar = this.getAppRegistrationInfo(productId);
        Integer licenseId = null;
        if (ar != null) {
            AppLicenseInfo ali = this.getAppLicenseInfoInt(productId);
            if (ali != null) {
                licenseId = ali.getLicenseId();
            }
            log.info("Fetched LicenseId=" + licenseId + " for productId=" + productId);
            if (licenseId == null) {
                throw new NoLicenseException("No license configured for product Id " + productId);
            }
        } else {
            throw new LicensingException("Invalid product specified for Id " + productId);
        }
        return licenseId;
    }

    @Override
    public boolean deActivateLicense(int productId, String cause) {
        try {
            log.info("Deactivating the license for productId=" + productId);
            Integer licenseId = this.getLicenseId(productId);
            LicenseInfo licenseInfo = LicenseValidator.getLicenseHandler((int)productId).getLicenseDetails(licenseId.intValue(), true);
            if (licenseInfo != null) {
                this.setProductLicenseStatus(productId, LicenseStatusType.Overrun);
                return true;
            }
            throw new LicensingException("Invalid license found with Id " + licenseId);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public void updateLicenseActivationCheckCount(int productId, String licenseKey, int count) {
    }

    @Override
    public void updateLicenseActivationCheckCount(int productId, int count) {
        try {
            log.info("Updating License activation check count for the productId=" + productId + "|count=" + count);
            Integer licenseId = this.getLicenseId(productId);
            LicenseInfo licenseInfo = LicenseValidator.getLicenseHandler((int)productId).getLicenseDetails(licenseId.intValue(), true);
            if (licenseInfo != null) {
                this.setLicenseActivationCheckCount(productId, count, licenseInfo);
                return;
            }
            throw new LicensingException("Invalid license found with Id " + licenseId);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public void updateLicenseValidityCheckCount(int productId, String licenseKey, int count) {
    }

    @Override
    public void updateLicenseValidityCheckCount(int productId, int count) {
        try {
            log.info("Updating License validity check count for the productId=" + productId + "|count=" + count);
            Integer licenseId = this.getLicenseId(productId);
            LicenseInfo licenseInfo = LicenseValidator.getLicenseHandler((int)productId).getLicenseDetails(licenseId.intValue(), true);
            if (licenseInfo != null) {
                this.setLicenseValidityCheckCount(productId, count, licenseInfo);
                return;
            }
            throw new LicensingException("Invalid license found with Id " + licenseId);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    @Override
    public void setLicenseActivationStatus(int productId, LicenseInfo licInfo, ActivationStatusType status) {
        try {
            licInfo.setActivationStatus(status);
            LicenseValidator.getLicenseHandler((int)productId).updateLicenseInfo(licInfo);
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
    }

    private LicenseInfo validateLicense(int productId, String licenseKey) {
        try {
            licenseKey = licenseKey.trim();
            if (!licenseKey.startsWith("-----BEGIN") || !licenseKey.endsWith("KEY-----") || licenseKey.indexOf("-----BEGIN") != licenseKey.lastIndexOf("-----BEGIN") || licenseKey.indexOf("-----END") != licenseKey.lastIndexOf("-----END")) {
                throw new InvalidLicenseException("Invalid license key " + licenseKey);
            }
            if (this.checkLicenseKeyInUse(productId, licenseKey)) {
                log.error("License key is already in use " + licenseKey + " for the product with Id " + productId);
                throw new LicensingException("License key has already been used in the past");
            }
        }
        catch (TipsException e) {
            throw new LicensingException((Throwable)e);
        }
        return this.decodeLicense(productId, licenseKey);
    }

    private void setLicenseActivationCheckCount(int productId, int count, LicenseInfo licenseInfo) {
        Map<String, String> licenseDetailsMap = licenseInfo.getLicenseDetailsMap();
        if (licenseDetailsMap == null) {
            licenseDetailsMap = Collections.synchronizedMap(new HashMap());
            licenseInfo.setLicenseDetailsMap(licenseDetailsMap);
        }
        log.info("Setting the license activation count for License id=" + licenseInfo.getId() + "|count=" + count);
        licenseDetailsMap.put("LicenseActivationCheckCount", Integer.toString(count));
        LicenseValidator.getLicenseHandler((int)productId).updateLicenseInfo(licenseInfo);
    }

    private void setLicenseValidityCheckCount(int productId, int count, LicenseInfo licenseInfo) {
        Map<String, String> licenseDetailsMap = licenseInfo.getLicenseDetailsMap();
        if (licenseDetailsMap == null) {
            licenseDetailsMap = Collections.synchronizedMap(new HashMap());
            licenseInfo.setLicenseDetailsMap(licenseDetailsMap);
        }
        log.info("Setting the license validity check count for License id=" + licenseInfo.getId() + "|count=" + count);
        licenseDetailsMap.put("LicenseValidityCheckCount", Integer.toString(count));
        LicenseValidator.getLicenseHandler((int)productId).updateLicenseInfo(licenseInfo);
    }

    private void expireLicense(int productId, LicenseInfo licenseInfo, String cause) {
        Map<String, String> licenseDetailsMap = licenseInfo.getLicenseDetailsMap();
        if (licenseDetailsMap == null) {
            licenseDetailsMap = Collections.synchronizedMap(new HashMap());
            licenseInfo.setLicenseDetailsMap(licenseDetailsMap);
        }
        log.info("Marking the license status expired for ProductId=" + productId + "|License id" + licenseInfo.getId() + "|Cause=" + cause);
        licenseDetailsMap.put("LicenseStatus", LicenseStatusType.Expired.name());
        licenseDetailsMap.put("LicenseCause", cause);
        LicenseValidator.getLicenseHandler((int)productId).updateLicenseInfo(licenseInfo);
    }

    private String getLicenseAttribute(LicenseInfo licenseInfo, String attrName) {
        Map licenseDetailsMap = licenseInfo.getLicenseDetailsMap();
        if (licenseDetailsMap != null) {
            return (String)licenseDetailsMap.get(attrName);
        }
        return null;
    }

    private String getLicenseCause(LicenseInfo licenseInfo) {
        return this.getLicenseAttribute(licenseInfo, "LicenseCause");
    }

    private String getLicenseStatus(LicenseInfo licenseInfo) {
        return this.getLicenseAttribute(licenseInfo, "LicenseStatus");
    }

    private Integer getLicenseValidityCheckCount(LicenseInfo licenseInfo) {
        String attrValue = this.getLicenseAttribute(licenseInfo, "LicenseValidityCheckCount");
        log.info("Fetched LicenseValidityCheckCount=" + attrValue);
        if (attrValue != null) {
            try {
                return Integer.parseInt(attrValue);
            }
            catch (Exception v3) {
                // empty catch block
            }
        }
        return 0;
    }

    private boolean isLicenseExpired(LicenseInfo licenseInfo, int productId, int duration, Date activationDate) {
        String licenseStatus = this.getLicenseStatus(licenseInfo);
        log.info("ProductId=" + productId + "|duration=" + duration + "|licenseinfo={" + licenseInfo.getId().toString() + "}");
        if (licenseStatus != null && licenseStatus.equals(LicenseStatusType.Expired.name())) {
            return true;
        }
        if (licenseInfo.getLicenseType().equals(LicenseType.Evaluation.toString())) {
            return this.performLicenseExpiryChecks(licenseInfo, productId, duration, "License evaluation period has ended", activationDate);
        }
        if (duration > 0) {
            return this.performLicenseExpiryChecks(licenseInfo, productId, duration * 365, "License subscription period has ended", activationDate);
        }
        return false;
    }

    private boolean performLicenseExpiryChecks(LicenseInfo licenseInfo, int productId, int duration, String expiryMessage, Date activationDate) {
        boolean licenseExpired = false;
        Integer licValidityCheckCount = this.getLicenseValidityCheckCount(licenseInfo);
        String productName = "Unknown";
        try {
            AppRegistration ar = this.getAppRegistrationInfo(productId);
            if (ar != null) {
                productName = ar.getName();
            }
        }
        catch (TipsException v9) {
            // empty catch block
        }
        String errMsg = "";
        ExecInterceptor incptr = new ExecInterceptor(true);
        if (licValidityCheckCount > duration) {
            errMsg = "Marking the license expired for product=" + productName + "|license Id =" + licenseInfo.getId() + " as it exceeded the license validity";
            log.info("Marking the license expired for productId=" + productId + " LicenseValidityCheckCount=" + licValidityCheckCount + " licenseInfo={" + licenseInfo.getId().toString() + "}");
            try {
                this.expireLicense(productId, licenseInfo, expiryMessage);
                this.setProductLicenseStatus(productId, LicenseStatusType.Expired);
                String[] cmdArray = new String[]{"sudo", SYSTEM_EVENT_LOGGER, "LicenseExpiryTracker", "ERROR", "License", errMsg, "None"};
                ProcessExec.exec((ExecInterceptor)incptr, (String[])cmdArray);
                return true;
            }
            catch (TipsException e) {
                throw new LicensingException((Throwable)e);
            }
            catch (Exception e2) {
                log.error("Failed to log system event", (Throwable)e2);
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(activationDate);
        ((Calendar)calendar).add(5, duration);
        Date now = new Date();
        licenseExpired = now.after(calendar.getTime());
        if (licenseExpired) {
            try {
                errMsg = "Marking the license expired for product=" + productName + "|license id=" + licenseInfo.getId() + "|Current time=" + now + "|License installation time=" + calendar.getTime();
                log.info("Marking the license expired for productId=" + productId + " CurrentTime=" + now + "|LicenseInstallTime=" + calendar.getTime() + " licenseInfo={" + licenseInfo.getId().toString() + "}");
                this.expireLicense(productId, licenseInfo, expiryMessage);
                this.setProductLicenseStatus(productId, LicenseStatusType.Expired);
                String[] cmdArray = new String[]{"sudo", SYSTEM_EVENT_LOGGER, "LicenseExpiryTracker", "ERROR", "License", errMsg, "None"};
                ProcessExec.exec((ExecInterceptor)incptr, (String[])cmdArray);
            }
            catch (TipsException e) {
                throw new LicensingException((Throwable)e);
            }
            catch (Exception e3) {
                log.error("Failed to log system event", (Throwable)e3);
            }
        }
        return licenseExpired;
    }

    private BaseLicenseDetails decodeLicenseInternal(AppLicenseInfo appLicenseInfo, String licenseKey) {
        Integer appId = appLicenseInfo.getAppId();
        if (appId == null) {
            throw new LicensingException("Invalid application for Id " + appId);
        }
        return this.decodeLicenseInternal(appId, licenseKey);
    }

    private BaseLicenseDetails decodeLicenseInternal(int appId, String licenseKey) {
        AppRegistration appRegistration = this.getAppRegistrationInfo(appId);
        if (appRegistration == null) {
            throw new LicensingException("Invalid application for Id " + appId);
        }
        return this.decodeLicenseInternal(appRegistration, licenseKey);
    }

    @Override
    public void updateLicenseCountMultiplier() {
    }

    private BaseLicenseDetails decodeLicenseInternal(AppRegistration appRegistration, String licenseKey) {
        LicenseVersionSuffix lvs = new LicenseVersionSuffix(appRegistration.getId(), licenseKey);
        String signPubKeyFile = PLATFORM_LICENSING + appRegistration.getAlias() + lvs.getSuffix();
        int encVersion = lvs.getEncVersion();
        log.debug("Decoding License....");
        LicenseDecoder licenseDecoder = new LicenseDecoder();
        BaseLicenseDetails bld = licenseDecoder.decode(licenseKey, signPubKeyFile, encVersion);
        if (bld == null) {
            throw new InvalidLicenseException("Invalid license key " + licenseKey);
        }
        return bld;
    }

    private LicenseInfo newLicenseInfo(BaseLicenseDetails bld) {
        LicenseInfo licenseInfo = new LicenseInfo();
        int counter = 0;
        System.out.println(AppServerType.DefaultType);
        licenseInfo.setLicenseKey(bld.getLicenseKey());
        licenseInfo.setHardwareType(bld.getAppServerType());
        licenseInfo.setCustomerId(bld.getEncCustomerId());
        licenseInfo.setNumUsers(Integer.valueOf(25000));
        if (bld.getEval()) {
            licenseInfo.setLicenseType(LicenseType.Permanent.toString());
        } else if (bld.getDuration() != 0) {
            licenseInfo.setLicenseType(LicenseType.Permanent.toString());
        } else {
            licenseInfo.setLicenseType(LicenseType.Permanent.toString());
        }
        licenseInfo.setDuration(Integer.valueOf(0));
        licenseInfo.setActivationStatus(ActivationStatusType.Activated);
        Map<String, String> licenseDetailsMap = licenseInfo.getLicenseDetailsMap();
        if (licenseDetailsMap == null) {
            licenseDetailsMap = Collections.synchronizedMap(new HashMap());
            licenseInfo.setLicenseDetailsMap(licenseDetailsMap);
        }
        int licenseUserDataType = bld.getLicenseUserDataType();
        licenseDetailsMap.put("LicenseUserDatatype", Integer.toString(licenseUserDataType));
        ArrayList<String> featureValList = new ArrayList<String>();
        for (LicenseFeatures lf : LicenseFeatures.values()) {
            if (!lf.isLicensed(licenseUserDataType)) continue;
            featureValList.add(lf.getValue());
        }
        if (featureValList.size() != 0) {
            licenseDetailsMap.put("LicensedFeatures", StringUtils.getCsv(featureValList));
        }
        Date now = new Date();
        String licenseInstallDateStr = dateFormat.format(now);
        if (bld.getDuration() == 1) {
            licenseDetailsMap.put("LicenseDurationUnits", "");
        } else if (bld.getDuration() > 1 && bld.getDuration() <= 5) {
            licenseDetailsMap.put("LicenseDurationUnits", "");
        } else {
            licenseDetailsMap.put("LicenseDurationUnits", "");
        }
        licenseDetailsMap.put("LicenseActivationCheckCount", Integer.toString(counter));
        licenseDetailsMap.put("LicenseValidityCheckCount", Integer.toString(counter));
        licenseDetailsMap.put("LicenseEmbedType", "");
        licenseDetailsMap.put("LicenseSupportExpiry", "2030/12/31");
        licenseDetailsMap.put("LicenseInstallDate", licenseInstallDateStr);
        return licenseInfo;
    }

    public static class LicenseMessage {
        public static final String OLD_LICENSE = "License key has already been used in the past";
        public static final String EVAL_EXPIRY_MESSAGE = "License evaluation period has ended";
        public static final String INACTIVE_LICENSE = "License is not active";
        public static final String NON_EXISTING_LICENSE = "License key not found";
        public static final String SUBSCRIPTION_EXPIRY_MESSAGE = "License subscription period has ended";
        public static final String ACCESS_UPGRADE_LIMIT_MESSAGE = "Total count of AccessUpgrade license cannot exceed that of Entry license";
        public static final String ACCESS_UPGRADE_REPLACE_MESSAGE = "Replacing an active AccessUpgrade license with a lower license count not allowed";
        public static final String CONTACT_SUPPORT_MESSAGE = "Contact support to obtain a ClearPass enhanced license key";
    }

    private class LicenseVersionSuffix {
        private int encVersion;
        private String appLicenseSuffix;

        public LicenseVersionSuffix(int productId, String licenseKey) {
            boolean isVersionV5;
            boolean bl = isVersionV5 = licenseKey.indexOf("-----BEGIN") != -1;
            if (isVersionV5) {
                this.encVersion = 5;
                this.appLicenseSuffix = LicenseValidator.APP_LICENSE_SUFFIX_V5;
            } else {
                this.encVersion = productId == 101 ? 2 : 4;
                this.appLicenseSuffix = LicenseValidator.APP_LICENSE_SUFFIX;
            }
        }

        public int getEncVersion() {
            return this.encVersion;
        }

        public String getSuffix() {
            return this.appLicenseSuffix;
        }
    }
}

