/*
 * Decompiled with CFR 0.152.
 */
package com.avenda.platform.licensing.validator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum LicensedApp {
    PolicyManager(1, "Access"),
    OnGuard(5, "OnGuard"),
    Guest(7, "Guest"),
    Onboard(8, "Onboard"),
    ClearPassEnterprise(9, "ClearPass Enterprise"),
    ClearPassUniversalProfiler(10, "ClearPass Universal Profiler"),
    Entry(11, "Entry"),
    AccessUpgrade(12, "Access Upgrade"),
    ClearPassPlatform(101, "ClearPass Platform");

    public static final Integer PROFILE_ID;
    private static final String PROFILE_NAME = "Profile";
    public static final Integer[] BASE_LICENSE_IDS;
    private int id;
    private String value;

    private LicensedApp(int id, String value) {
        this.id = id;
        this.value = value;
    }

    public int getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public static LicensedApp getLicensedApp(int id) {
        switch (id) {
            case 1: 
            case 3: {
                return PolicyManager;
            }
            case 5: {
                return OnGuard;
            }
            case 7: {
                return Guest;
            }
            case 8: {
                return Onboard;
            }
            case 9: {
                return ClearPassEnterprise;
            }
            case 10: {
                return ClearPassUniversalProfiler;
            }
            case 11: {
                return Entry;
            }
            case 12: {
                return AccessUpgrade;
            }
            case 101: {
                return ClearPassPlatform;
            }
        }
        return null;
    }

    public boolean isLicenseInstalled() {
        return true;
    }

    public static Map<Integer, String> getLicensedApps() {
        LinkedHashMap<Integer, String> lhm = new LinkedHashMap<Integer, String>();
        for (LicensedApp app : LicensedApp.values()) {
            lhm.put(app.id, app.value);
        }
        return lhm;
    }

    public static int getProductIdFromLicenseKey(String licenseKey) {
        Pattern pattern = Pattern.compile("-----BEGIN (.*?) LICENSE KEY-----");
        Matcher matcher = pattern.matcher(licenseKey);
        if (matcher.find()) {
            String licenseType = matcher.group(1);
            if (licenseType.equals(Entry.getValue().toUpperCase())) {
                return Entry.getId();
            }
            if (licenseType.equalsIgnoreCase(AccessUpgrade.getValue().replaceAll(" ", "").toUpperCase())) {
                return AccessUpgrade.getId();
            }
            if (licenseType.equalsIgnoreCase(PolicyManager.getValue().toUpperCase())) {
                return PolicyManager.getId();
            }
            if (licenseType.contains(OnGuard.getValue().toUpperCase())) {
                return OnGuard.getId();
            }
            if (licenseType.contains(Onboard.getValue().toUpperCase())) {
                return Onboard.getId();
            }
            if (licenseType.contains(ClearPassPlatform.getValue().toUpperCase())) {
                return ClearPassPlatform.getId();
            }
            return -1;
        }
        return -1;
    }

    public static Map<Integer, String> getSecondaryApps() {
        LinkedHashMap<Integer, String> lhm = new LinkedHashMap<Integer, String>();
        block3: for (LicensedApp app : LicensedApp.values()) {
            switch (app) {
                case ClearPassPlatform: 
                case ClearPassEnterprise: 
                case ClearPassUniversalProfiler: 
                case Guest: {
                    continue block3;
                }
                default: {
                    lhm.put(app.id, app.value);
                }
            }
        }
        return lhm;
    }

    public static Map<Integer, String> getPrimaryApps() {
        LinkedHashMap<Integer, String> lhm = new LinkedHashMap<Integer, String>();
        lhm.put(ClearPassPlatform.getId(), ClearPassPlatform.getValue());
        return lhm;
    }

    public static String getAppName(Integer id) {
        switch (id) {
            case 1: 
            case 3: {
                return PolicyManager.getValue();
            }
            case 5: {
                return OnGuard.getValue();
            }
            case 6: {
                return PROFILE_NAME;
            }
            case 7: {
                return Guest.getValue();
            }
            case 8: {
                return Onboard.getValue();
            }
            case 9: {
                return ClearPassEnterprise.getValue();
            }
            case 10: {
                return ClearPassUniversalProfiler.getValue();
            }
            case 11: {
                return Entry.getValue();
            }
            case 12: {
                return AccessUpgrade.getValue();
            }
            case 101: {
                return ClearPassPlatform.getValue();
            }
        }
        return null;
    }

    static {
        PROFILE_ID = 6;
        BASE_LICENSE_IDS = new Integer[]{PolicyManager.getId(), AccessUpgrade.getId(), Entry.getId()};
    }
}

