/*
 * Decompiled with CFR 0.152.
 */
package com.avenda.platform.licensing.validator;

import com.avenda.platform.activation.common.PlatformUtils;
import com.avenda.platform.licensing.common.NoLicenseException;
import com.avenda.platform.licensing.validator.LicenseValidator;
import com.avenda.tips.admin.beans.license.AppLicenseInfo;
import com.avenda.tips.admin.beans.license.LicenseInfo;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowLicense {
    private static final String USAGE = "ShowLicense <ProductId>";
    private static final String LICENSE_UPDATOR_LOG4J_FILE = "/usr/local/avenda/common/etc/licenseUpdatorLog4j2.xml";
    private static final String LICENSED_FEATURES_KEY = "LicensedFeatures";
    private static final Logger log = LoggerFactory.getLogger(ShowLicense.class);
    private static final FastDateFormat dateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (Locale)Locale.US);

    public String toString(AppLicenseInfo ali) {
        StringBuilder sb = new StringBuilder();
        List licInfos = ali.getLicenseInfoList();
        LicenseInfo licInfo = null;
        if (licInfos != null && licInfos.size() > 0) {
            licInfo = (LicenseInfo)licInfos.get(0);
            Map licenseDetailsMap = licInfo.getLicenseDetailsMap();
            if (licenseDetailsMap != null) {
                String licensedFeatures = (String)licenseDetailsMap.get(LICENSED_FEATURES_KEY);
                if (licensedFeatures != null) {
                    sb.append("LICENSED_FEATURES=" + licensedFeatures);
                } else {
                    sb.append("LICENSED_FEATURES=<not applicable>");
                }
                sb.append(PlatformUtils.LINE_SEPARATOR);
                String licenseDurationUnits = (String)licenseDetailsMap.get("LicenseDurationUnits");
                if (licenseDurationUnits != null) {
                    sb.append("LICENSE_DURATION_UNITS=" + licenseDurationUnits);
                } else {
                    sb.append("LICENSE_DURATION_UNITS=days");
                }
                sb.append(PlatformUtils.LINE_SEPARATOR);
            }
        } else {
            return null;
        }
        sb.append("LICENSE_KEY=" + licInfo.getLicenseKey());
        sb.append(PlatformUtils.LINE_SEPARATOR);
        sb.append("ACTIVATION_DATE=" + dateFormat.format(ali.getActivationDate()));
        sb.append(PlatformUtils.LINE_SEPARATOR);
        sb.append("LICENSE_VALIDITY=" + licInfo.getLicenseType());
        sb.append(PlatformUtils.LINE_SEPARATOR);
        sb.append("LICENSE_DURATION=" + licInfo.getDuration());
        sb.append(PlatformUtils.LINE_SEPARATOR);
        sb.append("LICENSE_NUM_USERS=" + licInfo.getNumUsers());
        sb.append(PlatformUtils.LINE_SEPARATOR);
        sb.append("CUSTOMER_ID=" + licInfo.getCustomerId());
        sb.append(PlatformUtils.LINE_SEPARATOR);
        return sb.toString();
    }

    public static void main(String[] args) {
        int ret = 1;
        String msg = null;
        if (args.length != 1) {
            System.out.println("ERROR - Invalid usage");
            System.out.println(USAGE);
            System.exit(ret);
        }
        String productIdStr = args[0];
        Configurator.initialize(null, (String)LICENSE_UPDATOR_LOG4J_FILE);
        ShowLicense showLicense = new ShowLicense();
        try {
            LicenseValidator lvi = new LicenseValidator();
            Integer productId = new Integer(productIdStr);
            log.debug("Decoding the license for the product Id=" + productIdStr);
            AppLicenseInfo[] alis = lvi.getAppLicenseInfo(productId);
            AppLicenseInfo ali = null;
            if (alis.length > 0) {
                ali = alis[0];
                String licenseInfoDispStr = showLicense.toString(ali);
                System.out.println(licenseInfoDispStr);
                log.debug(licenseInfoDispStr);
                ret = 0;
            } else {
                ret = 2;
                msg = "No license configured for the product Id=" + productIdStr;
                System.out.println("ERROR - " + msg);
                log.error(msg);
            }
        }
        catch (NoLicenseException e) {
            ret = 2;
            System.out.println("ERROR - " + msg + e.getMessage());
            log.error(msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Failed to retrieve the licensing information. ";
            System.out.println("ERROR - " + msg + e.getMessage());
            log.error(msg, (Throwable)e);
        }
        System.exit(ret);
    }
}

