/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.FeatureConstructor;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFeaturedObject;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.model.RuntimeModelerException;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebServiceFeatureList
implements WSFeatureList {
    private Map<Class<? extends WebServiceFeature>, WebServiceFeature> wsfeatures = new HashMap<Class<? extends WebServiceFeature>, WebServiceFeature>();
    @Nullable
    private WSDLFeaturedObject parent;
    private static final Logger LOGGER = Logger.getLogger(WebServiceFeatureList.class.getName());

    public WebServiceFeatureList() {
    }

    public WebServiceFeatureList(WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray != null) {
            for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
                this.wsfeatures.put(webServiceFeature.getClass(), webServiceFeature);
            }
        }
    }

    public WebServiceFeatureList(@NotNull Class<?> clazz) {
        this.parseAnnotations(clazz);
    }

    public void parseAnnotations(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            WebServiceFeature webServiceFeature;
            Annotation annotation2;
            if (!annotation.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) continue;
            if (annotation instanceof Addressing) {
                annotation2 = (Addressing)annotation;
                webServiceFeature = new AddressingFeature(annotation2.enabled(), annotation2.required());
            } else if (annotation instanceof MTOM) {
                annotation2 = (MTOM)annotation;
                webServiceFeature = new MTOMFeature(annotation2.enabled(), annotation2.threshold());
                BindingID bindingID = BindingID.parse(clazz);
                MTOMFeature mTOMFeature = bindingID.createBuiltinFeatureList().get(MTOMFeature.class);
                if (mTOMFeature != null && mTOMFeature.isEnabled() ^ webServiceFeature.isEnabled()) {
                    throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_MTOM_CONFLICT(bindingID, webServiceFeature.isEnabled()), new Object[0]);
                }
            } else if (annotation instanceof RespectBinding) {
                annotation2 = (RespectBinding)annotation;
                webServiceFeature = new RespectBindingFeature(annotation2.enabled());
            } else {
                webServiceFeature = WebServiceFeatureList.getWebServiceFeatureBean(annotation);
            }
            this.add(webServiceFeature);
        }
    }

    private static WebServiceFeature getWebServiceFeatureBean(Annotation annotation) {
        WebServiceFeature webServiceFeature;
        WebServiceFeatureAnnotation webServiceFeatureAnnotation = annotation.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
        Class<? extends WebServiceFeature> clazz = webServiceFeatureAnnotation.bean();
        Constructor<?> constructor = null;
        String[] stringArray = null;
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            FeatureConstructor featureConstructor = constructor2.getAnnotation(FeatureConstructor.class);
            if (featureConstructor == null) continue;
            if (constructor == null) {
                constructor = constructor2;
                stringArray = featureConstructor.value();
                continue;
            }
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_MORETHANONE_FTRCONSTRUCTOR(annotation, clazz));
        }
        if (constructor == null) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_NO_FTRCONSTRUCTOR(annotation, clazz));
        }
        if (constructor.getParameterTypes().length != stringArray.length) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_ILLEGAL_FTRCONSTRUCTOR(annotation, clazz));
        }
        try {
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Method method = annotation.annotationType().getDeclaredMethod(stringArray[i], new Class[0]);
                objectArray[i] = method.invoke(annotation, new Object[0]);
            }
            webServiceFeature = (WebServiceFeature)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new WebServiceException(exception);
        }
        return webServiceFeature;
    }

    @Override
    public Iterator<WebServiceFeature> iterator() {
        if (this.parent != null) {
            return new MergedFeatures(this.parent.getFeatures());
        }
        return this.wsfeatures.values().iterator();
    }

    @Override
    @NotNull
    public WebServiceFeature[] toArray() {
        if (this.parent != null) {
            return new MergedFeatures(this.parent.getFeatures()).toArray();
        }
        return this.wsfeatures.values().toArray(new WebServiceFeature[0]);
    }

    @Override
    public boolean isEnabled(@NotNull Class<? extends WebServiceFeature> clazz) {
        WebServiceFeature webServiceFeature = this.get(clazz);
        return webServiceFeature != null && webServiceFeature.isEnabled();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F get(@NotNull Class<F> clazz) {
        WebServiceFeature webServiceFeature = (WebServiceFeature)clazz.cast(this.wsfeatures.get(clazz));
        if (webServiceFeature == null && this.parent != null) {
            return this.parent.getFeatures().get(clazz);
        }
        return (F)webServiceFeature;
    }

    public void add(@NotNull WebServiceFeature webServiceFeature) {
        if (!this.wsfeatures.containsKey(webServiceFeature.getClass())) {
            this.wsfeatures.put(webServiceFeature.getClass(), webServiceFeature);
        }
    }

    public void addAll(@NotNull WSFeatureList wSFeatureList) {
        for (WebServiceFeature webServiceFeature : wSFeatureList) {
            this.add(webServiceFeature);
        }
    }

    public void mergeFeatures(@NotNull WSDLPort wSDLPort, boolean bl, boolean bl2) {
        if (bl && !this.isEnabled(RespectBindingFeature.class)) {
            return;
        }
        if (!bl) {
            this.addAll(wSDLPort.getFeatures());
            return;
        }
        for (WebServiceFeature webServiceFeature : wSDLPort.getFeatures()) {
            if (this.get(webServiceFeature.getClass()) == null) {
                try {
                    Method method = webServiceFeature.getClass().getMethod("isRequired", new Class[0]);
                    try {
                        boolean bl3 = (Boolean)method.invoke(webServiceFeature, new Object[0]);
                        if (!bl3) continue;
                        this.add(webServiceFeature);
                        continue;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new WebServiceException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new WebServiceException(invocationTargetException);
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.add(webServiceFeature);
                    continue;
                }
            }
            if (!bl2 || this.isEnabled(webServiceFeature.getClass()) == webServiceFeature.isEnabled()) continue;
            LOGGER.warning(ModelerMessages.RUNTIME_MODELER_FEATURE_CONFLICT(this.get(webServiceFeature.getClass()), webServiceFeature));
        }
    }

    public void setParentFeaturedObject(@NotNull WSDLFeaturedObject wSDLFeaturedObject) {
        this.parent = wSDLFeaturedObject;
    }

    @Nullable
    public static <F extends WebServiceFeature> F getFeature(@NotNull WebServiceFeature[] webServiceFeatureArray, @NotNull Class<F> clazz) {
        for (WebServiceFeature webServiceFeature : webServiceFeatureArray) {
            if (webServiceFeature.getClass() != clazz) continue;
            return (F)webServiceFeature;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MergedFeatures
    implements Iterator<WebServiceFeature> {
        private final Stack<WebServiceFeature> features = new Stack();

        public MergedFeatures(WSFeatureList wSFeatureList) {
            for (WebServiceFeature webServiceFeature : WebServiceFeatureList.this.wsfeatures.values()) {
                this.features.push(webServiceFeature);
            }
            for (WebServiceFeature webServiceFeature : wSFeatureList) {
                if (WebServiceFeatureList.this.wsfeatures.containsKey(webServiceFeature.getClass())) continue;
                this.features.push(webServiceFeature);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.features.empty();
        }

        @Override
        public WebServiceFeature next() {
            if (!this.features.empty()) {
                return this.features.pop();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.features.empty()) {
                this.features.pop();
            }
        }

        public WebServiceFeature[] toArray() {
            return this.features.toArray(new WebServiceFeature[0]);
        }
    }
}

