/*
 * Decompiled with CFR 0.152.
 */
package com.hp.oars.util;

import com.hp.oars.pm.PMNode;
import com.hp.oars.util.ZipFileNameFilter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtil {
    static String dirName = System.getProperty("base.dir") + "/data";

    public static byte[] readDoc(String docId) throws IOException {
        String[] sa = docId.split("/");
        if (sa == null || sa.length < 2) {
            throw new FileNotFoundException("Invalid filename: " + docId);
        }
        File file = new File(dirName, sa[0] + ".zip");
        ZipFile zipFile = new ZipFile(file);
        ZipEntry e = zipFile.getEntry(docId);
        BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(e));
        int size = (int)e.getSize();
        byte[] data = new byte[size];
        in.read(data);
        in.close();
        return data;
    }

    public static byte[] readDoc(String zipName, String docId) throws IOException {
        File file = new File(dirName, zipName + ".zip");
        ZipFile zipFile = new ZipFile(file);
        ZipEntry e = zipFile.getEntry(docId);
        BufferedInputStream in = new BufferedInputStream(zipFile.getInputStream(e));
        int size = (int)e.getSize();
        byte[] data = new byte[size];
        in.read(data);
        in.close();
        return data;
    }

    public static List<String> listAvailableZips() {
        File dataDir = new File(dirName);
        File[] zipFiles = dataDir.listFiles((FilenameFilter)new ZipFileNameFilter());
        ArrayList<String> zips = new ArrayList<String>();
        for (int i = 0; zipFiles != null && i < zipFiles.length; ++i) {
            int pos = zipFiles[i].getName().indexOf(".zip");
            zips.add(zipFiles[i].getName().substring(0, pos));
        }
        return zips;
    }

    public static Map<Integer, PMNode> readPM(String zipName) throws JDOMException, IOException {
        HashMap<Integer, PMNode> nodes = new HashMap<Integer, PMNode>();
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)new ByteArrayInputStream(ZipUtil.readDoc((String)zipName, (String)"pm.xml")));
        Element pme = doc.getRootElement();
        List l = pme.getChildren("n");
        for (Element e : l) {
            PMNode node = ZipUtil.parseNode((Element)e);
            nodes.put(node.getOid(), node);
        }
        return nodes;
    }

    private static PMNode parseNode(Element e) {
        Integer oid = new Integer(e.getAttributeValue("oid"));
        Integer level = new Integer(e.getAttributeValue("lvl"));
        String displayName = e.getAttributeValue("nm");
        PMNode node = new PMNode(oid, level, displayName);
        node.addChildren(ZipUtil.toList((String)e.getAttributeValue("c")));
        node.addParents(ZipUtil.toList((String)e.getAttributeValue("p")));
        node.setPhpId(e.getAttributeValue("php"));
        return node;
    }

    private static List<Integer> toList(String s) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                l.add(new Integer(st.nextToken().trim()));
            }
        }
        return l;
    }

    public static Map<Integer, PMNode> readPMAll() throws JDOMException, IOException {
        HashMap<Integer, PMNode> nodes = new HashMap<Integer, PMNode>();
        List l = ZipUtil.listAvailableZips();
        for (String zip : l) {
            Map zn = ZipUtil.readPM((String)zip);
            for (Integer oid : zn.keySet()) {
                PMNode node = (PMNode)nodes.get(oid);
                PMNode znode = (PMNode)zn.get(oid);
                if (node == null) {
                    nodes.put(oid, znode);
                    continue;
                }
                node.addChildren(znode.getChildren());
                node.addParents(znode.getParents());
            }
        }
        return nodes;
    }
}

