/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.util.DeployLock;
import com.sun.deploy.util.Trace;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.OCSP;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sessionStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static List jurisdictionList = null;
    private static final List preTrustList = Collections.singletonList("OU=Java Signed Extensions,OU=Corporate Object Signing,O=Sun Microsystems Inc");
    private static boolean isBrowserRootStoreLoaded = false;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;
    private static boolean ocspEECheck = true;
    private static HashSet deniedURL = null;
    private static DeployLock deployLock = null;
    public static final long PERMISSION_GRANTED_FOR_SESSION = 1L;
    public static final long PERMISSION_DENIED = 0L;

    public static void resetDenyStore() {
        Trace.msgSecurityPrintln("trustdecider.check.reset.denystore");
        boolean bl = false;
        try {
            bl = deployLock.lock();
            deniedStore = new DeniedCertStore();
            deniedURL.clear();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
    }

    public static HashSet getDeniedURL() {
        boolean bl = false;
        try {
            bl = deployLock.lock();
            HashSet hashSet = deniedURL;
            return hashSet;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
    }

    public static void reset() {
        boolean bl = false;
        try {
            bl = deployLock.lock();
            rootStore = RootCertStore.getCertStore();
            permanentStore = DeploySigningCertStore.getCertStore();
            sessionStore = new SessionCertStore();
            deniedStore = new DeniedCertStore();
            deniedURL = new HashSet();
            jurisdictionList = null;
            if (Config.getBooleanProperty("deployment.security.pretrust.list")) {
                jurisdictionList = preTrustList;
            }
            if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                Service service = ServiceManager.getService();
                browserRootStore = service.getBrowserSigningRootCertStore();
                browserTrustedStore = service.getBrowserTrustedCertStore();
                isBrowserRootStoreLoaded = false;
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        String string;
                        crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
                        if (crlCheck && (string = Config.getProperty("deployment.security.validation.crl.url")) != null && string.length() > 0) {
                            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                            URL uRL = new URL(string);
                            URLConnection uRLConnection = uRL.openConnection();
                            uRLConnection.setDoInput(true);
                            uRLConnection.setUseCaches(false);
                            DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
                            crl509 = (X509CRL)certificateFactory.generateCRL(dataInputStream);
                            dataInputStream.close();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp");
                        if (ocspCheck) {
                            ocspSigner = Config.getProperty("deployment.security.validation.ocsp.signer");
                            ocspURL = Config.getProperty("deployment.security.validation.ocsp.url");
                            if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                                ocspValidConfig = true;
                            }
                        }
                        ocspEECheck = Config.getBooleanProperty("deployment.security.validation.ocsp.ee");
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                privilegedActionException.printStackTrace();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            if (bl) {
                deployLock.unlock();
            }
        }
    }

    public static long isAllPermissionGranted(CodeSource codeSource) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, new AppInfo());
    }

    public static long isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        return TrustDecider.isAllPermissionGranted(codeSource, appInfo, false);
    }

    public static long isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo, boolean bl) throws CertificateEncodingException, CertificateExpiredException, CertificateNotYetValidException, CertificateParsingException, CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        block100: {
            boolean bl2 = false;
            try {
                int n;
                bl2 = deployLock.lock();
                Certificate[] certificateArray = codeSource.getCertificates();
                URL uRL = codeSource.getLocation();
                if (certificateArray == null) {
                    long l = 0L;
                    return l;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                String string = null;
                rootStore.load();
                permanentStore.load();
                sessionStore.load();
                deniedStore.load();
                if (browserRootStore != null && !isBrowserRootStoreLoaded) {
                    browserRootStore.load();
                    isBrowserRootStoreLoaded = true;
                }
                if (browserTrustedStore != null) {
                    browserTrustedStore.load();
                }
                ArrayList arrayList = new ArrayList();
                while (n3 < certificateArray.length) {
                    ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
                    int n5 = n2;
                    while (n5 + 1 < certificateArray.length && certificateArray[n5] instanceof X509Certificate && certificateArray[n5 + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n5], (X509Certificate)certificateArray[n5 + 1])) {
                        ++n5;
                    }
                    n3 = n5 + 1;
                    for (n = n2; n < n3; ++n) {
                        arrayList2.add(certificateArray[n]);
                    }
                    arrayList.add(arrayList2);
                    n2 = n3;
                    ++n4;
                }
                boolean bl3 = true;
                try {
                    Class<?> clazz = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
                    if (clazz == null) {
                        bl3 = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
                    bl3 = false;
                }
                if (Config.isJavaVersionAtLeast16() && bl3) {
                    Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
                    boolean bl4 = false;
                    n = 0;
                    long l = 0L;
                    long l2 = 0L;
                    int n6 = 0;
                    LinkedHashSet<X509Certificate> linkedHashSet = new LinkedHashSet<X509Certificate>();
                    linkedHashSet.addAll(rootStore.getCertificates());
                    if (browserRootStore != null) {
                        linkedHashSet.addAll(browserRootStore.getCertificates());
                    }
                    Iterator iterator = arrayList.iterator();
                    n4 = 0;
                    while (iterator.hasNext()) {
                        Object object;
                        Object object2;
                        boolean bl5;
                        Object object3;
                        Cloneable cloneable;
                        Date date;
                        X509Certificate x509Certificate;
                        int n7;
                        Certificate[] certificateArray2;
                        block99: {
                            X500Principal x500Principal;
                            List list = (List)iterator.next();
                            certificateArray2 = list.toArray(new X509Certificate[0]);
                            CertificateExpiredException certificateExpiredException = null;
                            CertificateNotYetValidException certificateNotYetValidException = null;
                            l2 = Long.MAX_VALUE;
                            for (n7 = 0; n7 < certificateArray2.length; ++n7) {
                                long l3 = certificateArray2[n7].getNotAfter().getTime();
                                if (l3 < l2) {
                                    l2 = l3;
                                }
                                try {
                                    certificateArray2[n7].checkValidity();
                                    continue;
                                }
                                catch (CertificateExpiredException certificateExpiredException2) {
                                    if (certificateExpiredException != null) continue;
                                    certificateExpiredException = certificateExpiredException2;
                                    n6 = -1;
                                    n = 1;
                                    continue;
                                }
                                catch (CertificateNotYetValidException certificateNotYetValidException2) {
                                    if (certificateNotYetValidException != null) continue;
                                    certificateNotYetValidException = certificateNotYetValidException2;
                                    n6 = 1;
                                    n = 1;
                                }
                            }
                            n7 = certificateArray2.length;
                            x509Certificate = certificateArray2[n7 - 1];
                            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
                            if (((Object)x500Principal2).equals(x500Principal = x509Certificate.getSubjectX500Principal()) && !linkedHashSet.contains(x509Certificate)) {
                                if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                                    string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                                    throw new CertificateException(string);
                                }
                                bl4 = true;
                                linkedHashSet.add(x509Certificate);
                            }
                            date = null;
                            try {
                                CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
                                Timestamp timestamp = codeSignerArray[n4].getTimestamp();
                                if (timestamp != null) {
                                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                                    date = timestamp.getTimestamp();
                                    CertPath certPath = timestamp.getSignerCertPath();
                                    if (n != 0) {
                                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
                                        cloneable = certificateArray2[n7 - 1].getNotAfter();
                                        object3 = certificateArray2[n7 - 1].getNotBefore();
                                        if (date.before((Date)cloneable) && date.after((Date)object3)) {
                                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                                            boolean bl6 = TrustDecider.checkTSAPath(certPath, linkedHashSet);
                                            if (bl6) {
                                                n = 0;
                                                n6 = 0;
                                            } else {
                                                date = null;
                                            }
                                        } else {
                                            Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                                        }
                                    } else {
                                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.noneed");
                                    }
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
                                }
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
                            }
                            if (!(bl4 || n6 != 0 || appInfo.getType() != 3 || bl || permanentStore.contains(certificateArray2[0]))) {
                                crlCheck = true;
                                ocspCheck = true;
                                Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "true");
                                Trace.msgSecurityPrintln("trustdecider.check.extensioninstall.on");
                            }
                            bl5 = false;
                            if (jurisdictionList != null) {
                                Trace.msgSecurityPrintln("trustdecider.check.jurisdiction.found");
                                if (!bl4 && n6 == 0) {
                                    Trace.msgSecurityPrintln("trustdecider.check.trustextension.on");
                                    bl5 = TrustDecider.checkTrustedExtension(certificateArray2[0]);
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.trustextension.off");
                                }
                                if (!(crlCheck && ocspCheck || !bl5 || permanentStore.contains(certificateArray2[0]))) {
                                    crlCheck = true;
                                    ocspCheck = true;
                                    Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "true");
                                }
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.check.jurisdiction.notfound");
                            }
                            boolean bl7 = false;
                            boolean bl8 = false;
                            cloneable = null;
                            try {
                                int n8;
                                object3 = Validator.getInstance("PKIX", "plugin code signing", linkedHashSet);
                                object2 = (PKIXValidator)object3;
                                cloneable = ((PKIXValidator)object2).getParameters();
                                ((PKIXParameters)cloneable).addCertPathChecker(new DeployCertPathChecker((PKIXValidator)object2));
                                if (crlCheck) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
                                    if (crl509 != null) {
                                        bl7 = true;
                                    } else {
                                        for (n8 = 0; n8 < certificateArray2.length; ++n8) {
                                            if (!CertUtils.getCertCRLExtension(certificateArray2[n8])) continue;
                                            bl7 = true;
                                        }
                                    }
                                    cloneable = TrustDecider.doCRLValidation((PKIXParameters)cloneable, bl7);
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
                                }
                                if (ocspCheck) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
                                    if (ocspValidConfig) {
                                        bl8 = true;
                                    } else {
                                        for (n8 = 0; n8 < certificateArray2.length; ++n8) {
                                            if (!CertUtils.getCertAIAExtension(certificateArray2[n8])) continue;
                                            bl8 = true;
                                        }
                                    }
                                    TrustDecider.doOCSPValidation((PKIXParameters)cloneable, linkedHashSet, (X509Certificate[])certificateArray2, bl8);
                                } else {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
                                }
                                object = new X509Certificate[n7];
                                for (int i = 0; i < n7; ++i) {
                                    object[i] = new X509CertificateWrapper(certificateArray2[i]);
                                }
                                ((Validator)object3).validate((X509Certificate[])object);
                                if (crlCheck && bl7) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.crl.succeed");
                                }
                                if (ocspCheck && bl8) {
                                    Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.succeed");
                                }
                            }
                            catch (CertificateException certificateException) {
                                if (!Config.getBooleanProperty("deployment.security.askgrantdialog.notinca")) {
                                    string = ResourceManager.getMessage("trustdecider.user.cannot.grant.notinca");
                                    throw new CertificateException(string);
                                }
                                if (certificateException instanceof ValidatorException) {
                                    object2 = (ValidatorException)certificateException;
                                    if (ValidatorException.T_NO_TRUST_ANCHOR.equals(((ValidatorException)object2).getErrorType())) {
                                        bl4 = true;
                                        break block99;
                                    }
                                    object = "Certificate has been revoked";
                                    if (crlCheck && bl7 || ocspCheck && bl8) {
                                        String string2 = ((Throwable)object2).getMessage();
                                        if (string2.contains((CharSequence)object)) {
                                            Trace.msgSecurityPrintln("trustdecider.check.validation.revoked");
                                        } else {
                                            Trace.msgSecurityPrintln(string2);
                                        }
                                        throw object2;
                                    }
                                    throw object2;
                                }
                                throw certificateException;
                            }
                            catch (IOException iOException) {
                                Trace.msgSecurityPrintln(iOException.getMessage());
                                throw iOException;
                            }
                            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                                Trace.msgSecurityPrintln(invalidAlgorithmParameterException.getMessage());
                                throw invalidAlgorithmParameterException;
                            }
                            catch (CRLException cRLException) {
                                Trace.msgSecurityPrintln(cRLException.getMessage());
                                throw cRLException;
                            }
                            finally {
                                Security.setProperty("com.sun.security.onlyCheckRevocationOfEECert", "false");
                            }
                        }
                        if (n7 > 1 && !ocspCheck && ocspEECheck && !bl5 && !bl4 && n == 0) {
                            if (!permanentStore.contains(certificateArray2[0])) {
                                try {
                                    object3 = TrustDecider.doOCSPEEValidation(certificateArray2[0], certificateArray2[1], linkedHashSet, ((PKIXParameters)cloneable).getDate());
                                    if (object3 != OCSP.RevocationStatus.CertStatus.GOOD) {
                                        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.bad");
                                        string = ResourceManager.getMessage("trustdecider.check.ocsp.ee.revoked");
                                        throw new CertificateException(string);
                                    }
                                    Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.good");
                                }
                                catch (IOException iOException) {
                                    Trace.msgSecurityPrintln(iOException.getMessage());
                                }
                                catch (CertPathValidatorException certPathValidatorException) {
                                    Trace.msgSecurityPrintln(certPathValidatorException.getMessage());
                                    throw new CertificateException(certPathValidatorException);
                                }
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.off");
                        }
                        if (bl4) {
                            linkedHashSet.remove(x509Certificate);
                        }
                        int n9 = 0;
                        if (deniedStore.contains(certificateArray2[0])) {
                            deniedURL.add(uRL);
                            n9 = deniedStore.contains(certificateArray2[0], true) ? 1 : n;
                        }
                        if (n9 == 0) {
                            if (permanentStore.contains(certificateArray2[0]) && (n == 0 || !permanentStore.contains(certificateArray2[0], true))) {
                                long l4 = l2;
                                return l4;
                            }
                            if (bl5 && !permanentStore.contains(certificateArray2[0], true)) {
                                object2 = DeploySigningCertStore.getUserCertStore();
                                object2.load(true);
                                if (object2.add(certificateArray2[0], true)) {
                                    object2.save();
                                }
                                Trace.msgSecurityPrintln("trustdecider.check.trustextension.add");
                                long l5 = l2;
                                return l5;
                            }
                            if (sessionStore.contains(certificateArray2[0]) && (n == 0 || !sessionStore.contains(certificateArray2[0], true))) {
                                long l6 = 1L;
                                return l6;
                            }
                            if (browserTrustedStore != null && browserTrustedStore.contains(certificateArray2[0])) {
                                long l7 = 1L;
                                return l7;
                            }
                            if (!Config.getBooleanProperty("deployment.security.askgrantdialog.show")) {
                                string = ResourceManager.getMessage("trustdecider.user.cannot.grant.any");
                                throw new CertificateException(string);
                            }
                            if (bl2) {
                                deployLock.unlock();
                                bl2 = false;
                            }
                            int n10 = X509Util.showSecurityDialog(certificateArray2, codeSource.getLocation(), 0, n7, bl4, n6, date, appInfo, bl);
                            bl2 = deployLock.lock();
                            if (n10 == 0) {
                                Trace.msgSecurityPrintln("trustdecider.user.grant.session");
                                sessionStore.add(certificateArray2[0], n == 0);
                                sessionStore.save();
                                l = 1L;
                            } else if (n10 == 2) {
                                Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
                                object = DeploySigningCertStore.getUserCertStore();
                                object.load(true);
                                if (object.add(certificateArray2[0], n == 0)) {
                                    object.save();
                                }
                                l = l2;
                            } else {
                                Trace.msgSecurityPrintln("trustdecider.user.deny");
                                deniedStore.add(certificateArray2[0], n == 0);
                                deniedStore.save();
                                deniedURL.add(uRL);
                            }
                            if (l != 0L) {
                                long l8 = l;
                                return l8;
                            }
                        }
                        ++n4;
                    }
                    break block100;
                }
                Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                if (CertValidator.validate(codeSource, appInfo, certificateArray, n4, rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore)) {
                    long l = 1L;
                    return l;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            finally {
                if (bl2) {
                    deployLock.unlock();
                }
            }
        }
        return 0L;
    }

    private static boolean checkTSAPath(CertPath certPath, LinkedHashSet linkedHashSet) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        Validator validator = Validator.getInstance("PKIX", "tsa server", linkedHashSet);
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[0]);
        try {
            x509CertificateArray = validator.validate(x509CertificateArray);
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln(certificateException.getMessage());
            return false;
        }
        return true;
    }

    private static PKIXParameters doCRLValidation(PKIXParameters pKIXParameters, boolean bl) throws IOException, InvalidAlgorithmParameterException, CRLException, NoSuchAlgorithmException {
        if (crl509 != null) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.on");
            System.clearProperty("com.sun.security.enableCRLDP");
            pKIXParameters.setRevocationEnabled(true);
            pKIXParameters.addCertStore(java.security.cert.CertStore.getInstance("Collection", new CollectionCertStoreParameters(Collections.singletonList(crl509))));
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.system.off");
            pKIXParameters.setRevocationEnabled(bl);
            System.setProperty("com.sun.security.enableCRLDP", Boolean.toString(bl));
        }
        return pKIXParameters;
    }

    private static void doOCSPValidation(PKIXParameters pKIXParameters, LinkedHashSet linkedHashSet, X509Certificate[] x509CertificateArray, boolean bl) throws IOException {
        X509Certificate x509Certificate = null;
        boolean bl2 = false;
        Security.setProperty("ocsp.enable", Boolean.toString(bl));
        if (ocspValidConfig) {
            Security.setProperty("ocsp.responderURL", ocspURL);
        }
        pKIXParameters.setRevocationEnabled(bl);
        if (ocspValidConfig) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.on");
            String string = null;
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                x509Certificate = (X509Certificate)iterator.next();
                string = CertUtils.extractSubjectAliasName(x509Certificate);
                if (!ocspSigner.equals(string)) continue;
                bl2 = true;
                break;
            }
            if (bl2 && x509Certificate != null) {
                Security.setProperty("ocsp.responderCertSubjectName", x509Certificate.getSubjectX500Principal().getName());
            }
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.system.off");
        }
        if (!crlCheck && bl) {
            System.setProperty("com.sun.security.enableCRLDP", "true");
        }
    }

    private static OCSP.RevocationStatus.CertStatus doOCSPEEValidation(X509Certificate x509Certificate, X509Certificate x509Certificate2, LinkedHashSet linkedHashSet, Date date) throws IOException, CertPathValidatorException {
        Object object;
        Object object2;
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.start");
        URI uRI = null;
        X509Certificate x509Certificate3 = x509Certificate2;
        if (ocspValidConfig) {
            try {
                uRI = new URI(ocspURL);
            }
            catch (URISyntaxException uRISyntaxException) {
                Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.no");
                return OCSP.RevocationStatus.CertStatus.GOOD;
            }
            object2 = linkedHashSet.iterator();
            while (object2.hasNext()) {
                object = (X509Certificate)object2.next();
                String string = CertUtils.extractSubjectAliasName((X509Certificate)object);
                if (!ocspSigner.equals(string)) continue;
                x509Certificate3 = object;
                break;
            }
        } else {
            uRI = OCSP.getResponderURI(x509Certificate);
        }
        if (uRI == null) {
            Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.no");
            return OCSP.RevocationStatus.CertStatus.GOOD;
        }
        object2 = uRI.toString();
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.responderURI.value", new Object[]{object2});
        object2 = OCSP.check((X509Certificate)x509Certificate, (X509Certificate)x509Certificate2, (URI)uRI, (X509Certificate)x509Certificate3, (Date)date).getCertStatus();
        object = ((Enum)object2).name();
        Trace.msgSecurityPrintln("trustdecider.check.ocsp.ee.return.status", new Object[]{object});
        return object2;
    }

    private static boolean checkTrustedExtension(X509Certificate x509Certificate) {
        Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction");
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string = x500Principal.getName();
        Iterator iterator = jurisdictionList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.endsWith(string2)) continue;
            Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction.found");
            return true;
        }
        return false;
    }

    static {
        deployLock = new DeployLock();
        TrustDecider.reset();
    }
}

