/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.util.Debug;

public class LoginConfigImpl
extends Configuration {
    Configuration config;
    private final int caller;
    private final String mechName;
    private static final Debug debug = Debug.getInstance("gssloginconfig", "\t[GSS LoginConfigImpl]");

    public LoginConfigImpl(int n, Oid oid) {
        this.caller = n;
        if (!oid.equals(GSSUtil.GSS_KRB5_MECH_OID)) {
            throw new IllegalArgumentException(oid.toString() + " not supported");
        }
        this.mechName = "krb5";
        this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return Configuration.getConfiguration();
            }
        });
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        String[] stringArray;
        AppConfigurationEntry[] appConfigurationEntryArray;
        block12: {
            block11: {
                appConfigurationEntryArray = null;
                if ("OTHER".equalsIgnoreCase(string)) {
                    return null;
                }
                stringArray = null;
                if (!"krb5".equals(this.mechName)) break block11;
                switch (this.caller) {
                    case 1: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"};
                        break block12;
                    }
                    case 2: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.security.jgss.accept"};
                        break block12;
                    }
                    case 3: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.net.ssl.client"};
                        break block12;
                    }
                    case 4: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.net.ssl.server"};
                        break block12;
                    }
                    case 5: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.initiate"};
                        break block12;
                    }
                    case -1: {
                        throw new AssertionError((Object)"caller cannot be unknown");
                    }
                    default: {
                        throw new AssertionError((Object)"caller not defined");
                    }
                }
            }
            throw new IllegalArgumentException(this.mechName + " not supported");
        }
        for (String string2 : stringArray) {
            if (debug != null) {
                debug.println("Trying " + string2);
            }
            if ((appConfigurationEntryArray = this.config.getAppConfigurationEntry(string2)) != null) break;
        }
        return appConfigurationEntryArray;
    }
}

