/*
 * Decompiled with CFR 0.152.
 */
package com.hp.oars;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class OARS {
    static Log log = LogFactory.getLog(OARS.class);
    private TrayIcon trayIcon;
    private int port = 8081;

    public static void main(String[] args) {
        try {
            new OARS().go(args);
        }
        catch (Exception e) {
            log.error(e.toString(), e);
            System.exit(-1);
        }
        System.exit(0);
    }

    private void go(String[] args) throws Exception {
        log.info("OARS - Starting");
        this.checkRun();
        this.setupPaths();
        this.trayicon();
        Server server = new Server();
        Connector[] cons = new Connector[]{new SelectChannelConnector()};
        if (System.getProperty("oars.bind.all") != null) {
            cons[0].setHost("127.0.0.1");
        }
        cons[0].setPort(this.port);
        server.setConnectors(cons);
        WebAppContext wac = new WebAppContext();
        wac.setWar(System.getProperty("base.dir") + "/oars.war");
        wac.setContextPath("/");
        server.setHandler(wac);
        server.setStopAtShutdown(true);
        server.start();
        server.join();
    }

    private void checkRun() {
        try {
            URL oars = new URL("http://localhost:" + this.port);
            URLConnection oc = oars.openConnection();
            oc.connect();
            log.info("OARS client is already running - exitting.");
            System.exit(0);
        }
        catch (ConnectException e) {
            if (!"Connection refused: connect".equals(e.getMessage())) {
                log.info(e, e);
                System.exit(-1);
            }
        }
        catch (IOException e) {
            log.error(e, e);
            System.exit(-1);
        }
    }

    private void setupPaths() {
        if (System.getProperty("base.dir") == null) {
            URL url = this.getClass().getResource("/test.properties");
            log.debug("Properties URL: " + url);
            String s = url.getFile();
            int pos = s.indexOf("/oars.jar!");
            if (pos >= 0) {
                System.setProperty("base.dir", s.substring(6, pos));
            } else {
                log.error("Failed to find client WebApp realivet to path: " + s);
                System.exit(-1);
            }
        }
        log.info("base.dir = " + System.getProperty("base.dir"));
    }

    private void trayicon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            URL imgURL = this.getClass().getResource("/tray.gif");
            Image image = Toolkit.getDefaultToolkit().getImage(imgURL);
            MouseListener mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            };
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    log.info("Exiting...");
                    System.exit(0);
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Exit OARS");
            defaultItem.addActionListener(exitListener);
            popup.add(defaultItem);
            this.trayIcon = new TrayIcon(image, "OARS", popup);
            this.trayIcon.setImageAutoSize(true);
            this.trayIcon.addMouseListener(mouseListener);
            try {
                tray.add(this.trayIcon);
            }
            catch (AWTException e) {
                log.error("TrayIcon could not be added.");
            }
        }
    }
}

