/*
 * Decompiled with CFR 0.152.
 */
package com.hp.oars.action;

import com.hp.oars.pm.PMNode;
import com.hp.oars.util.PathContainerComparator;
import com.hp.oars.util.PathContainter;
import com.hp.oars.util.ZipUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.jdom.JDOMException;

public abstract class OarsAction
extends Action {
    private static final String TITLE = "title";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionErrors errors = new ActionErrors();
        try {
            this.version(request);
        }
        catch (Exception e) {
            errors.add("error.init", new ActionError("error.props", (Object)e.getLocalizedMessage()));
            this.saveErrors(request, errors);
            e.printStackTrace();
        }
        try {
            if (request.getSession().getAttribute("pm") == null) {
                Map nodes = ZipUtil.readPMAll();
                request.getSession().setAttribute("pm", (Object)nodes);
            }
        }
        catch (Exception e) {
            errors.add("error.init", new ActionError("error.pm", (Object)e.getLocalizedMessage()));
            this.saveErrors(request, errors);
        }
        List zips = ZipUtil.listAvailableZips();
        ByteArrayInputStream in = new ByteArrayInputStream(ZipUtil.readDoc((String)((String)zips.get(0)), (String)"oars.properties"));
        Properties props = new Properties();
        props.load(in);
        request.getSession().setAttribute("edition", (Object)props.getProperty("edition"));
        if (zips.size() > 1) {
            request.getSession().setAttribute("image.title", (Object)"Multiple Disks");
        } else {
            String currentImage = props.getProperty("image");
            String title = props.getProperty(currentImage + ".title");
            String id = props.getProperty(currentImage + ".id");
            request.getSession().setAttribute("image.title", (Object)(id + " &mdash; " + title));
        }
        return this.oarsExecute(mapping, form, request, response);
    }

    private void version(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session.getAttribute("oars.version") == null) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("version.properties");
            Properties props = new Properties();
            try {
                props.load(in);
                session.setAttribute("oars.version", (Object)props.getProperty("version", "unspecified"));
            }
            catch (Exception e) {
                session.setAttribute("oars.version", (Object)"unspecified");
            }
        }
    }

    public abstract ActionForward oarsExecute(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException, ServletException;

    protected void setTitle(HttpServletRequest request, String title) {
        request.setAttribute(TITLE, (Object)title);
    }

    protected void setTitleKey(HttpServletRequest request, String key) {
        MessageResources mr = this.getResources(request);
        String title = mr.getMessage(request.getLocale(), key);
        request.setAttribute(TITLE, (Object)title);
    }

    protected void setTitleKey(HttpServletRequest request, String key, Object arg0) {
        MessageResources mr = this.getResources(request);
        String title = mr.getMessage(request.getLocale(), key, arg0);
        request.setAttribute(TITLE, (Object)title);
    }

    protected void createPath(HttpServletRequest request, Integer oid, String pathStr) throws JDOMException, IOException {
        Map nodes = (Map)request.getSession().getAttribute("pm");
        if (nodes == null) {
            nodes = ZipUtil.readPMAll();
            request.getSession().setAttribute("pm", (Object)nodes);
        }
        ArrayList<PathContainter> path = new ArrayList<PathContainter>();
        StringBuilder nPath = new StringBuilder();
        if (pathStr != null && pathStr.length() > 0) {
            StringTokenizer pst = new StringTokenizer(pathStr, "|");
            while (pst.hasMoreTokens()) {
                Integer poid = new Integer(pst.nextToken().trim());
                PMNode node = (PMNode)nodes.get(poid);
                HashMap<String, String> pmap = new HashMap<String, String>();
                pmap.put("path", nPath.toString());
                PathContainter pathCont = new PathContainter(poid, node.getDisplayName(), pmap);
                pathCont.setPhpId(node.getPhpId());
                path.add(pathCont);
                if (nPath.length() > 0) {
                    nPath.append("|");
                }
                nPath.append(poid);
                ArrayList<PathContainter> cPath = new ArrayList<PathContainter>();
                for (Integer coid : node.getChildren()) {
                    node = (PMNode)nodes.get(coid);
                    pmap = new HashMap();
                    pmap.put("path", nPath.toString());
                    cPath.add(new PathContainter(coid, node.getDisplayName(), pmap));
                }
                if (cPath.isEmpty()) continue;
                Collections.sort(cPath, new PathContainerComparator());
                pathCont.setChildren(cPath);
            }
        }
        if (oid == null) {
            oid = new Integer(0);
        }
        PMNode node = (PMNode)nodes.get(oid);
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("path", nPath.toString());
        PathContainter pathCont = new PathContainter(oid, node.getDisplayName(), pmap, Boolean.valueOf(true));
        pathCont.setPhpId(node.getPhpId());
        path.add(pathCont);
        if (nPath.length() > 0) {
            nPath.append("|");
        }
        nPath.append(oid);
        ArrayList<PathContainter> cPath = new ArrayList<PathContainter>();
        for (Integer coid : node.getChildren()) {
            node = (PMNode)nodes.get(coid);
            pmap = new HashMap();
            pmap.put("path", nPath.toString());
            cPath.add(new PathContainter(coid, node.getDisplayName(), pmap));
        }
        if (!cPath.isEmpty()) {
            Collections.sort(cPath, new PathContainerComparator());
            pathCont.setChildren(cPath);
        }
        request.setAttribute("pmPath", path);
    }

    protected String stackTrace(Throwable th) throws IOException {
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        th.printStackTrace(w);
        return out.toString();
    }
}

