/*
 * Decompiled with CFR 0.152.
 */
package com.hp.oars.action;

import com.hp.oars.action.OarsAction;
import com.hp.oars.form.SearchForm;
import com.hp.oars.util.PageContainer;
import com.hp.oars.util.ResultCollector;
import com.hp.oars.util.SearchResultList;
import com.hp.oars.util.SearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SearchAction
extends OarsAction {
    private int pageSize = 10;

    public ActionForward oarsExecute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionErrors errors = new ActionErrors();
        SearchForm sForm = (SearchForm)form;
        int start = sForm.getStart() == null ? 0 : sForm.getStart();
        Integer oid = sForm.getOid();
        String pathSearch = sForm.getPathSearch();
        try {
            this.createPath(request, sForm.getOid(), sForm.getPath());
            SearchResultList srl = this.search(sForm.getQuery(), start, oid, !pathSearch.equals("a"));
            if (srl.size() > 0) {
                request.setAttribute("seeker.resultPage", (Object)srl);
            } else {
                request.setAttribute("seeker.noResults", (Object)"");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("query", sForm.getQuery());
            map.put("oid", oid);
            map.put("path", sForm.getPath());
            map.put("pathSearch", pathSearch);
            request.setAttribute("seeker.start", (Object)new Integer(start + 1));
            request.setAttribute("seeker.end", (Object)new Integer(start + srl.size()));
            this.setupPaging(request, map, srl, start);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.startsWith("Cannot parse")) {
                msg = "Invalid Query string. Please check the help page for help on the syntax.";
            }
            errors.add("error.search", new ActionError("error.search", (Object)msg));
            this.saveErrors(request, errors);
        }
        return mapping.findForward("search");
    }

    private SearchResultList search(String q, int start, Integer oid, boolean path) throws IOException, ParseException {
        StandardAnalyzer analyzer = new StandardAnalyzer();
        QueryParser qp = new QueryParser("data", (Analyzer)analyzer);
        Query query = null;
        query = path && oid != null && oid != 0 ? qp.parse("(" + q + ") AND oid:" + oid) : qp.parse(q);
        Map idxMap = SearchUtil.getIndexMap();
        Searcher ms = SearchUtil.getSearcher(idxMap.keySet());
        QueryScorer qs = new QueryScorer(query);
        ResultCollector rc = new ResultCollector(ms, qs, (Analyzer)analyzer, start, this.pageSize);
        long t1 = System.currentTimeMillis();
        ms.search(query, (HitCollector)rc);
        long t2 = System.currentTimeMillis();
        SearchResultList srl = rc.getResultList();
        long t = t2 - t1;
        if (t < 10L) {
            t = 10L;
        }
        srl.setTime(t);
        srl.setQuery(q);
        return srl;
    }

    protected void setupPaging(HttpServletRequest request, Map<String, Object> map, SearchResultList srp, int start) {
        if (srp.isEmpty()) {
            return;
        }
        HashMap<String, Object> m = null;
        int page = 1;
        if (start > 0) {
            ArrayList<PageContainer> al = new ArrayList<PageContainer>();
            while ((page - 1) * this.pageSize < start) {
                m = new HashMap<String, Object>(map);
                m.put("start", new Integer((page - 1) * this.pageSize));
                al.add(new PageContainer(page, m));
                ++page;
            }
            if (al.size() > 10) {
                int s = al.size();
                request.setAttribute("seeker.before", al.subList(s - 10, s));
            } else {
                request.setAttribute("seeker.before", al);
            }
        }
        if (start > 1) {
            m = new HashMap<String, Object>(map);
            m.put("start", new Integer((page - 2) * this.pageSize));
            request.setAttribute("seeker.prev", m);
        }
        request.setAttribute("seeker.current", (Object)new Integer(page++));
        if (start + this.pageSize < srp.getDocsQualified()) {
            m = new HashMap<String, Object>(map);
            m.put("start", new Integer((page - 1) * this.pageSize));
            request.setAttribute("seeker.next", m);
        }
        int ac = 0;
        if (start + this.pageSize < srp.getDocsQualified()) {
            ArrayList<PageContainer> al = new ArrayList<PageContainer>();
            while ((page - 1) * this.pageSize < srp.getDocsQualified() && ++ac < 10) {
                m = new HashMap<String, Object>(map);
                m.put("start", new Integer((page - 1) * this.pageSize));
                al.add(new PageContainer(page, m));
                ++page;
            }
            request.setAttribute("seeker.after", al);
        }
    }
}

