/*
 * Decompiled with CFR 0.152.
 */
package com.hp.oars.util;

import com.hp.oars.util.SearchResult;
import com.hp.oars.util.SearchResultList;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;

public class ResultCollector
extends HitCollector {
    static Log log = LogFactory.getLog(ResultCollector.class);
    private Searcher searcher;
    private Analyzer analyzer;
    private int start;
    private int num;
    private int c = 0;
    private float maxRank = 0.0f;
    private Highlighter hl;
    private SearchResultList srl;
    private int[] hits = new int[1000];
    private float[] ranks = new float[1000];

    public ResultCollector(Searcher searcher, QueryScorer qs, Analyzer analyzer, int start, int num) {
        this.searcher = searcher;
        this.analyzer = analyzer;
        this.start = start;
        this.num = num;
        this.hl = new Highlighter((Formatter)new SimpleHTMLFormatter("<b>", "</b>"), (Scorer)qs);
        this.srl = new SearchResultList();
    }

    public void collect(int n, float rank) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("doc: " + n + ", rank: " + rank));
        }
        this.hits[this.c] = n;
        this.ranks[this.c++] = rank;
        if (rank > this.maxRank) {
            this.maxRank = rank;
        }
        if (this.c >= this.hits.length) {
            int[] nhits = Arrays.copyOf(this.hits, this.hits.length + 1000);
            this.hits = nhits;
            float[] nranks = Arrays.copyOf(this.ranks, this.ranks.length + 1000);
            this.ranks = nranks;
        }
    }

    private String removeNewLines(String s) {
        s = s.replaceAll("\r", "");
        return s.replaceAll("\n", " ");
    }

    public SearchResultList getResultList() throws IOException {
        this.srl.setDocsQualified(this.c);
        this.srl.setDocsSearched(this.searcher.maxDoc());
        this.sortHits();
        for (int i = this.start; i < this.start + this.num && this.c > 0 && i < this.c; ++i) {
            SearchResult sr = new SearchResult();
            try {
                Document doc = this.searcher.doc(this.hits[i]);
                sr.setDocId(doc.get("docId"));
                sr.setRank(Double.valueOf(this.ranks[i] / this.maxRank * 100.0f));
                sr.setTitle(doc.get("title"));
                String[] fragments = this.hl.getBestFragments(this.analyzer, "data", doc.get("data"), 5);
                if (fragments != null && fragments.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    for (int j = 0; j < fragments.length; ++j) {
                        if (i > 0) {
                            sb.append(" ... ");
                        }
                        sb.append(this.removeNewLines(fragments[j]));
                    }
                    sr.setSynopsis(sb.toString());
                }
                this.srl.add((Object)sr);
                continue;
            }
            catch (IOException e) {
                log.error((Object)"Can't read index.", (Throwable)e);
            }
        }
        return this.srl;
    }

    private void sortHits() {
        for (int i = 0; i < this.hits.length - 1; ++i) {
            for (int j = i + 1; j < this.hits.length; ++j) {
                if (!(this.ranks[j] > this.ranks[i])) continue;
                float rank = this.ranks[j];
                this.ranks[j] = this.ranks[i];
                this.ranks[i] = rank;
                int hit = this.hits[j];
                this.hits[j] = this.hits[i];
                this.hits[i] = hit;
            }
        }
    }
}

