<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:html="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.0" >

<!-- 
This stypesheet transforms ODS xhtml content to display it in the Seeker sample application.
It only lets the body content through and transforms the XLinks.

Author: Kelly
 -->

	<xsl:output method="xml" encoding="UTF-8"/>
	
	<xsl:param name="imageId" />
	
	<xsl:template match="html:html">
		<xsl:comment>begin payload</xsl:comment>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="html:head">
	</xsl:template>
	
	<xsl:template match="html:body">
		<a name="top" />
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="html:odsLink">
		<a>
		<xsl:attribute name="href">doc.do?docId=<xsl:value-of select="$imageId"/>/<xsl:value-of select="@xlink:href"/>.xhtml</xsl:attribute>
		<xsl:apply-templates/>
		</a>
	</xsl:template>
	
	<xsl:template match="html:odsIntLink">
		<a>
		<xsl:attribute name="href"><xsl:value-of select="@xlink:href" /></xsl:attribute>
		<xsl:if test="@xlink:href = '#top'"/>
		<xsl:apply-templates/>
		</a>
	</xsl:template>
	
	<xsl:template match="html:odsComponent">
		<img>
		<!-- TODO cut off the part before the / from href -->
		  <xsl:attribute name="src">doc.do?docId=<xsl:value-of select="$imageId"/>/comp/<xsl:value-of select="substring-after(@xlink:href, '/')"/></xsl:attribute>
		  <xsl:attribute name="alt"><xsl:value-of select="@xlink:title"/></xsl:attribute>
		  <xsl:attribute name="title"><xsl:value-of select="@xlink:title"/></xsl:attribute>
		</img>
	</xsl:template>
	
	<xsl:template match="html:odsExtLink">
		<a>
		<xsl:attribute name="href"><xsl:value-of select="@xlink:href"/></xsl:attribute>
		<xsl:attribute name="class">externalLink</xsl:attribute>
		<xsl:apply-templates/>
		</a>
	</xsl:template>
	
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
</xsl:stylesheet>
