rem @echo off 
cls
echo [ SCRIPT FOR REMOTE INSTALL OF W2K3 ON dl380 ]

echo Retrieving State Information...
.\System\statemgr /r phase

if errorlevel 3 goto State3
if errorlevel 2 goto State2
if errorlevel 1 goto State1
if errorlevel 0 goto State0

:State0

REM *** Configure the target server hardware by reading the configuration
REM *** information in the script file

echo Running Configuration Replication Utility...
.\tools\conrep -l -f%GlobalData%\HardwareSettings\hwconfig.xml -x.\tools\conrep.xml

echo Setting State Information...
.\tools\statemgr -w Phase 1

:State1

REM *** Configure the array controllers by reading the configuration information
REM *** in the script file and stamping it onto the array
REM *** controllers of the target server

echo Configuring the Array Controllers...
.\tools\ifhw .\hwdisc.xml .\tools\allboards.xml PCI:"Smart Array 5i Controller"
if errorlevel 1 GOTO NEXT1
.\tools\ssascripting.exe -i %GlobalData%\ArraySettings\array.ini

:NEXT1
.\tools\ifhw .\hwdisc.xml .\tools\allboards.xml PCI:"Smart Array 6i Controller"
if errorlevel 1 GOTO NEXT2
.\tools\ssascripting.exe -i %GlobalData%\ArraySettings\array.ini

:NEXT2
.\tools\ifhw .\hwdisc.xml .\tools\allboards.xml PCI:"Smart Array 5312"
if errorlevel 1 GOTO NEXT3
.\tools\ssascripting.exe -i s:\tkdemoarea\HP\Data\Global\ArraySettings\array.ini


:NEXT3

REM *** Configure the iLO if iLo Present
rem echo configuring iLO is present
rem ..\tools\ifhw .\hwdisc.xml .\tools\allboards.xml PCI:"Integrated Lights-Out Controller"
rem if errorlevel 1 GOTO State2
rem .\tools\hponcfg -f %GlobalData%\iLosettings\ilocfg.xml
rem pause
rem echo Setting State Information... Due to Problems with diskpart not picking up new logical volumes
.\tools\statemgr -w Phase 2

REM *** REBOOT  if necessary
.\tools\reboot 

:State2

REM *** Create partition by reading content of the script file and
REM *** stamping the configuration onto the hard drive in the target server
echo Creating Disk Partition...
%MsTools%\DiskPart /s %GlobalData%\diskPart0.txt
echo Formatting Disk Partition...
%MsTools%\format c: /FS:FAT32 /Q
.\tools\statemgr -w Phase 3

echo Creating Driver Directory and Copying Drivers...
xcopy %HPQFlatFiles%\cpqw2k3\$oem$ c:\$oem$ /s /e 

REM *** Copy the customized UNATTEND.TXT file from the system
REM *** configuration area to the root directory of the target server's
REM *** hard drive

copy %GlobalData%\unattend.txt c:\

REM *** Start installation of the operating system from the hard drive of the
REM *** target system, reading unattended installation instructions from the
REM *** C:\UNATTEND.TXT file

winnt32 /s:%MSDistributions%\W2k3\i386 /u:c:\unattend.txt

:State3
echo Nothing to see here... Move along

