 rem @echo off 
cls
echo [ SCRIPT FOR REMOTE INSTALL OF W2K3 ON typical server ]

pause

echo Retrieving State Information...
%Tools%\System\statemgr -r phase

if errorlevel 3 goto State3
if errorlevel 2 goto State2
if errorlevel 1 goto State1
if errorlevel 0 goto State0

:State0

REM=================================================================================
REM *** Configure the target server hardware by reading the configuration
REM *** information in the script file

echo Running Configuration Replication Utility...
%Tools%\conrep -l -f%GlobalData%\HardwareSettings\hwconfig.xml -x%Tools%\conrep.xml

echo Setting State Information...
%Tools%\statemgr -w Phase 1

:State1
REM=================================================================================
REM *** Configure the array controllers by reading the configuration information
REM *** in the script file and stamping it onto the array
REM *** controllers of the target server
REM=================================================================================

echo Configuring the Array Controllers...
%Tools%\ifhw .\hwdisc.xml %Tools%\allboards.xml PCI:"Smart Array 5i Controller"
if errorlevel 1 GOTO NEXT1
%Tools%\ssascripting.exe -i %GlobalData%\ArraySettings\pl-r0.ini
GOTO NEXT6

:NEXT1
%Tools%\ifhw .\hwdisc.xml %Tools%\allboards.xml PCI:"Smart Array 6i Controller"
if errorlevel 1 GOTO NEXT2
%Tools%\ssascripting.exe -i %GlobalData%\ArraySettings\pl-r1.ini
GOTO NEXT6

:NEXT2
%Tools%\ifhw .\hwdisc.xml %Tools%\allboards.xml PCI:"Smart Array 5312"
if errorlevel 1 GOTO NEXT3
%Tools%\ssascripting.exe -i %GlobalData%\ArraySettings\pl-r1.ini
GOTO NEXT6

:NEXT3
%Tools%\ifhw .\hwdisc.xml %Tools%\allboards.xml PCI:"Smart Array 640X Controller"
if errorlevel 1 GOTO NEXT4
%Tools%\ssascripting.exe -i %GlobalData%\ArraySettings\pl-r5.ini
GOTO NEXT6

:NEXT4
%Tools%\ifhw .\hwdisc.xml %Tools%\allboards.xml PCI:"Smart Array P600 Controller"
if errorlevel 1 GOTO NEXT5
%Tools%\ssascripting.exe -i %GlobalData%\ArraySettings\pl-r5.ini

  
:NEXT6
pause

REM=================================================================================
REM *** Configure the iLO if iLo Present
REM *** echo configuring iLO is present
REM=================================================================================

rem %Tools%\ifhw .\hwdisc.xml %Tools%\allboards.xml PCI:"Integrated Lights-Out Controller"
rem if errorlevel 1 GOTO State2
rem %Tools%\hponcfg -f %GlobalData%\iLoSettings\iloconfig.xml

REM=================================================================================
echo Setting State Information... Due to Problems with diskpart not picking up new logical volumes
REM=================================================================================
%Tools%\statemgr -w Phase 2
REM *** REBOOT  if necessary
%Tools%\reboot PXE

:State2

REM=================================================================================
REM *** Create partition by reading content of the script file and
REM *** stamping the configuration onto the hard drive in the target server
REM=================================================================================

echo Creating Disk Partition...
%MsTools%\DiskPart /s %GlobalData%\diskPart0.txt
echo Formatting Disk Partition...
%MsTools%\format c: /FS:NTFS /Q /y
pause
%Tools%\statemgr -w Phase 3

echo Creating Driver Directory and Copying Drivers...
mkdir c:\ntcsp
rem xcopy %HPQFlatFiles%\$oem$ c:\$oem$ /s /e 
xcopy %HPQComponents% c:\ntcsp /s /e
pause

REM *** Copy the customized UNATTEND.TXT file from the system
REM *** configuration area to the root directory of the target server's
REM *** hard drive
:State3
copy %GlobalData%\unattend.txt c:\

REM=================================================================================
REM *** Start installation of the operating system from the hard drive of the
REM *** target system, reading unattended installation instructions from the
REM *** C:\UNATTEND.TXT file
REM=================================================================================

%MSDistribution%\i386\winnt32 /s:%MSDistribution%\i386 /unattend:c:\unattend.txt /syspart:c
%Tools%\reboot c:
:State4
echo Nothing to see here... Move along

