#!/bin/sh
ipmi_status=0

if [ -f /etc/debian_version ]; then
	ipmiservice="openipmi"
elif [ -f /etc/redhat-release ]; then
	ipmiservice="ipmi"
else
	ipmiservice="ipmi"
fi

service $ipmiservice status > /dev/null 2>&1
if [ $? -eq 0 ];then
	IsServicePresent=1
else
	IsServicePresent=0
fi

if [ $IsServicePresent -eq 1 ];then
	res=`service $ipmiservice status`
	if [ $? -eq 0 ];then
		echo $res | grep 'not' >> /dev/null;
		ipmi_status=$?  # start:1 ; stop:0
	fi
fi

if [ $ipmi_status -eq 1 ]; then
	echo "############################## caution ##############################"
	echo "# To avoid KCS communication fail, this shell script will stop IPMI #"
	echo "# service automatically before update BMC firmware.                 #"
	echo "#####################################################################"
	res=`service $ipmiservice stop`
fi

cd linuxflash
./linuxflash.sh
cd ..

if [ $ipmi_status -eq 1 ]; then
	echo "Waiting for BMC ready, and then start IPMI service..."
	sleep 90
	res=`service $ipmiservice start`
	echo "IPMI service start now !!!"
fi
