#!/bin/sh
filename=`cat rom_enc.txt`
echo ""
echo BMC firmware image: $filename

ip=$1
passwd=$2
errorcode=0
cd linuxflash

#set the image selector to use latest image
ipmitool -H $ip -U admin -P $passwd raw 0x32 0x8f 0x01 0x04

#check architecture
CMD=`uname -m | cut -c 1-6`
if [ "$CMD" = "x86_64" ]; then
   cd Linux_x86_64
   echo ""
   echo Linux x86_64 Environment
   chmod 777 Yafuflash
   ./Yafuflash -vyes -nw -ip $ip -u admin -p $passwd -mse 0 -fb -ignore-existing-overrides ../../$filename
   errorcode=$?
   if [ "$errorcode" != "0" ]
   then
   echo -e " Yafuflash error code : $errorcode , stop update"
   exit 0 
   fi
else
   cd Linux_x86_32
   echo ""
   echo Linux x86 Environment
   chmod 777 Yafuflash
   ./Yafuflash -vyes -nw -ip $ip -u admin -p $passwd -mse 0 -fb -ignore-existing-overrides ../../$filename
   errorcode=$?
   if [ "$errorcode" != "0" ]
   then
   echo -e " Yafuflash error code : $errorcode , stop update"
   exit 0 
   fi
fi
 
cd ../.. 
