#!/bin/sh

show(){
echo "Update BIOS firmware:"
echo "./ubios_preserve_nvram.sh <BMC Username> <BMC Password> <BMC IP> <BIOS Image> "
}

Username=$1
Password=$2
ip=$3
image=$4

if [ "$#" -lt "4" ];
then
	show
	exit 0
fi

cd linuxflash

#check architecture
CMD=`uname -m | cut -c 1-6`
if [ "$CMD" = "x86_64" ]; then
   cd Linux_x86_64
   echo ""
   echo Linux x86_64 Environment
   chmod 777 Yafuflash
   ipmitool -H $ip -U $Username -P $Password -I lanplus raw 0x30 0xC4 0x02 0x01
   ./Yafuflash -d 2 -nw -preserve-config -ip $ip -u $Username -p $Password ../../$image -vyes
else
   cd Linux_x86_32
   echo ""
   echo Linux x86 Environment
   chmod 777 Yafuflash
   ipmitool -H $ip -U $Username -P $Password -I lanplus raw 0x30 0xC4 0x02 0x01
   ./Yafuflash -d 2 -nw -preserve-config -ip $ip -u $Username -p $Password ../../$image -vyes
fi

cd ../.. 
