#!/bin/sh

if [ $# -ne 3 ]; then
    echo "[ERROR] : Insufficient Parameter!"
    echo "linux_oob.sh <BMC_IP> <Username> <Password>"
    exit 0
fi

filename=`cat rom_enc.txt`
echo ""
echo BMC firmware image: $filename

ip=$1
username=$2
password=$3

cd linuxflash

#check architecture
CMD=`uname -m | cut -c 1-6`
if [ "$CMD" = "x86_64" ]; then
   cd Linux_x86_64
   echo ""
   echo Linux x86_64 Environment
   chmod 777 Yafuflash2
   ./Yafuflash2 -vyes -nw -ip $ip -u $username -p $password -fb ../../$filename
else
   cd Linux_x86_32
   echo ""
   echo Linux x86 Environment
   chmod 777 Yafuflash2
   ./Yafuflash2 -vyes -nw -ip $ip -u $username -p $password -fb ../../$filename
fi
 
cd ../.. 
