#!/bin/sh

if [ $# -ne 2 ]; then
    echo "[ERROR] : Insufficient Parameter!"
    echo "linux_oob-pc.sh <BMC_IP> <Password>"
    exit 0
fi

filename=`cat rom_enc.txt`
echo ""
echo BMC firmware image: $filename

ip=$1
pwd=$2

cd linuxflash

#check architecture
CMD=`uname -m | cut -c 1-6`
if [ "$CMD" = "x86_64" ]; then
   cd Linux_x86_64
   echo ""
   echo Linux x86_64 Environment
   chmod 777 Yafuflash2
   ./Yafuflash2 -vyes -nw -ip $ip -u admin -p $pwd -fb -pc ../../$filename
else
   cd Linux_x86_32
   echo ""
   echo Linux x86 Environment
   chmod 777 Yafuflash2
   ./Yafuflash2 -vyes -nw -ip $ip -u admin -p $pwd -fb -pc ../../$filename
fi
 
cd ../.. 
