/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import sanproject.sn2msg.SN2MsgAppException;
import sanproject.sn2msg.SN2MsgAppMacro;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.SN2MsgCtrlMacro;
import sanproject.sn2msg.controller.SN2MsgCtrlMain;
import sanproject.sn2msg.model.SN2MsgMdlException;
import sanproject.sn2msg.model.SN2MsgMdlMain;

public class SN2MsgApp
implements SN2MsgAppMacro,
SN2MsgCtrlMacro {
    /*
     * Loose catch block
     */
    public static void main(String[] args) {
        block14: {
            SN2MsgApp msgApp = null;
            try {
                try {
                    File fl = new File("log");
                    fl.mkdir();
                    System.setProperty("derby.stream.error.file", "log/derby.log");
                    SN2MsgLogger.getLogger().info(SN2MsgApp.getVersionString());
                    Properties prop = System.getProperties();
                    SN2MsgLogger.getLogger().info("Java VM:" + prop.getProperty("java.version"));
                    StringBuffer strBuf = new StringBuffer();
                    int iCmd = 0;
                    while (iCmd < args.length) {
                        strBuf.append(String.valueOf(args[iCmd]) + " ");
                        ++iCmd;
                    }
                    SN2MsgLogger.getLogger().info("Command:" + strBuf.toString());
                    System.out.println("Command:" + strBuf.toString());
                    msgApp = new SN2MsgApp(args);
                    msgApp.commandHandler(args);
                }
                catch (SN2MsgAppException appExp) {
                    appExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.SEVERE, "Parameter Error. args length:" + args.length, appExp);
                    if (msgApp != null) {
                        msgApp.destroyObject();
                    }
                    System.out.println("Command has terminated.");
                    SN2MsgLogger.getLogger().info("Command has terminated.");
                }
                catch (SN2MsgMdlException mdlExp) {
                    mdlExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.SEVERE, "DB cannot open.", mdlExp);
                    if (msgApp != null) {
                        msgApp.destroyObject();
                    }
                    System.out.println("Command has terminated.");
                    SN2MsgLogger.getLogger().info("Command has terminated.");
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.SEVERE, "Command failed:" + jvExp.toString(), jvExp);
                    if (msgApp != null) {
                        msgApp.destroyObject();
                    }
                    System.out.println("Command has terminated.");
                    SN2MsgLogger.getLogger().info("Command has terminated.");
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                if (msgApp != null) {
                    msgApp.destroyObject();
                }
                System.out.println("Command has terminated.");
                SN2MsgLogger.getLogger().info("Command has terminated.");
            }
        }
    }

    public SN2MsgApp(String[] strArg) throws SN2MsgMdlException, SN2MsgAppException {
        String strDbName = "MSG_R801";
        if (2 > strArg.length) {
            SN2MsgAppException appExp = new SN2MsgAppException();
            throw appExp;
        }
        strDbName = strArg[1];
        SN2MsgCtrlMain ctrlMain = SN2MsgCtrlMain.getInstance();
        SN2MsgMdlMain mdlMain = SN2MsgMdlMain.getInstance();
        mdlMain.openDB(strDbName);
    }

    static String getVersionString() {
        return "Tool version:20130529_0";
    }

    public void destroyObject() {
        SN2MsgCtrlMain ctrlMain = SN2MsgCtrlMain.getInstance();
        SN2MsgCtrlMain.endInstance();
        SN2MsgMdlMain mdlMain = SN2MsgMdlMain.getInstance();
        SN2MsgMdlMain.endInstance();
    }

    public void commandHandler(String[] strCmd) {
        if (strCmd != null) {
            if (strCmd.length != 0) {
                if (strCmd[0].equals("initDB")) {
                    this.cmdInitDB(strCmd);
                } else if (strCmd[0].equals("makeXML")) {
                    this.cmdMakeXML(strCmd);
                } else if (strCmd[0].equals("makeCSV")) {
                    this.cmdMakeCSV(strCmd);
                } else if (strCmd[0].equals("deleteMessage")) {
                    this.cmdDeleteMsg(strCmd);
                } else if (strCmd[0].equals("executeAll")) {
                    this.cmdExecuteAll(strCmd);
                } else {
                    SN2MsgLogger.getLogger().severe("Invalid command:" + strCmd[0]);
                }
            } else {
                SN2MsgLogger.getLogger().severe("Invalid command(No data).");
            }
        } else {
            SN2MsgLogger.getLogger().severe("Invalid command(null).");
        }
    }

    public boolean cmdInitDB(String[] strParam) {
        boolean bRet = true;
        if (3 == strParam.length) {
            SN2MsgCtrlMain ctrlMain = SN2MsgCtrlMain.getInstance();
            try {
                System.out.println("initDB() start");
                ctrlMain.initDB(strParam[2], strParam[1]);
                SN2MsgLogger.getLogger().info(String.valueOf(strParam[0]) + " command has succeeded.");
            }
            catch (SN2MsgCtrlException ctrlExp) {
                bRet = false;
                ctrlExp.printStackTrace();
                System.out.println(String.valueOf(strParam[0]) + " command has failed:" + strParam[1] + " " + strParam[2]);
                SN2MsgLogger.getLogger().log(Level.SEVERE, String.valueOf(strParam[0]) + " command has failed:" + strParam[1] + " " + strParam[2], ctrlExp);
            }
        } else {
            bRet = false;
            System.out.println("Invalid parameter. length:" + strParam.length);
            SN2MsgLogger.getLogger().severe("Invalid parameter. length:" + strParam.length);
        }
        return bRet;
    }

    public boolean cmdMakeXML(String[] strParam) {
        boolean bRet = true;
        try {
            if (4 == strParam.length) {
                System.out.println("makeXML() start");
                SN2MsgCtrlMain ctrlMain = SN2MsgCtrlMain.getInstance();
                ctrlMain.makeXML(strParam[2], strParam[1], strParam[3]);
                SN2MsgLogger.getLogger().info(String.valueOf(strParam[0]) + " command has succeeded.");
            } else {
                bRet = false;
                SN2MsgLogger.getLogger().severe("Invalid parameter. length:" + strParam.length);
                System.out.println("Invalid parameter. length:" + strParam.length);
            }
        }
        catch (SN2MsgCtrlException ctrlExp) {
            bRet = false;
            ctrlExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.SEVERE, "Command has failed:" + ctrlExp.getIErrorCode(), ctrlExp);
            System.out.println("Command has failed:" + ctrlExp.getIErrorCode());
        }
        return bRet;
    }

    boolean getReserve(String strRsv) {
        boolean bRet = false;
        if ("1".equals(strRsv)) {
            bRet = true;
        }
        return bRet;
    }

    public boolean cmdMakeCSV(String[] strParam) {
        boolean bRet = true;
        try {
            if (4 <= strParam.length) {
                System.out.println("makeCSV() start");
                String strRsv = "0";
                if (5 == strParam.length) {
                    strRsv = strParam[4];
                }
                SN2MsgCtrlMain ctrlMain = SN2MsgCtrlMain.getInstance();
                ctrlMain.makeCSV(strParam[2], strParam[1], strParam[3], this.getReserve(strRsv));
                SN2MsgLogger.getLogger().info(String.valueOf(strParam[0]) + " command has succeeded.");
            } else {
                bRet = false;
                SN2MsgLogger.getLogger().severe("Invalid parameter. length:" + strParam.length);
                System.out.println("Invalid parameter. length:" + strParam.length);
            }
        }
        catch (SN2MsgCtrlException ctrlExp) {
            bRet = false;
            ctrlExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.SEVERE, "Command has failed:" + ctrlExp.getIErrorCode(), ctrlExp);
            System.out.println("Command has failed:" + ctrlExp.getIErrorCode());
        }
        return bRet;
    }

    public boolean cmdDeleteMsg(String[] strParam) {
        boolean bRet = true;
        try {
            if (3 == strParam.length) {
                SN2MsgCtrlMain ctrlMain = SN2MsgCtrlMain.getInstance();
                ctrlMain.deleteMessage(strParam[1], strParam[2]);
                SN2MsgLogger.getLogger().info(String.valueOf(strParam[0]) + " command has succeeded.");
            } else {
                bRet = false;
                SN2MsgLogger.getLogger().severe("Invalid parameter. length:" + strParam.length);
            }
        }
        catch (SN2MsgCtrlException ctrlExp) {
            bRet = false;
            ctrlExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.SEVERE, "Command has failed:" + ctrlExp.getIErrorCode(), ctrlExp);
        }
        return bRet;
    }

    public boolean cmdExecuteAll(String[] strParam) {
        boolean bRet = true;
        if (this.checkExecuteAllPrm(strParam)) {
            String[] strInitDb = new String[]{"initDB", strParam[1], strParam[2]};
            bRet = this.cmdInitDB(strInitDb);
            if (bRet) {
                String[] strMakeCsv = new String[]{"makeCSV", strParam[1], strParam[3], "0", "0"};
                bRet = this.cmdMakeCSV(strMakeCsv);
                if (bRet) {
                    String[] strMakeXml = new String[]{"makeCSV", strParam[1], strParam[4], "0"};
                    bRet = this.cmdMakeXML(strMakeXml);
                    if (bRet) {
                        SN2MsgLogger.getLogger().info(String.valueOf(strParam[0]) + " command has succeeded.");
                    } else {
                        SN2MsgLogger.getLogger().severe(String.valueOf(strMakeXml[0]) + " command has failed.");
                    }
                } else {
                    SN2MsgLogger.getLogger().severe(String.valueOf(strMakeCsv[0]) + " command has failed.");
                }
            } else {
                SN2MsgLogger.getLogger().severe(String.valueOf(strInitDb[0]) + " command has failed.");
            }
        } else {
            bRet = false;
            SN2MsgLogger.getLogger().severe("Invalid parameter.");
        }
        return bRet;
    }

    boolean checkExecuteAllPrm(String[] strParam) {
        boolean bRet = true;
        if (5 != strParam.length) {
            bRet = false;
            System.out.println("Invalid parameter. length:" + strParam.length);
            SN2MsgLogger.getLogger().severe("Invalid parameter. length:" + strParam.length);
        } else if (!SN2MsgApp.isValidPath(strParam[2])) {
            bRet = false;
            System.out.println("Invalid parameter. Input path:" + strParam[2]);
            SN2MsgLogger.getLogger().severe("Invalid parameter. Input path:" + strParam[2]);
        } else if (!SN2MsgApp.isValidPath(strParam[3])) {
            bRet = false;
            System.out.println("Invalid parameter. CSV path:" + strParam[3]);
            SN2MsgLogger.getLogger().severe("Invalid parameter. CSV path:" + strParam[3]);
        } else if (!SN2MsgApp.isValidPath(strParam[4])) {
            bRet = false;
            System.out.println("Invalid parameter. XML path:" + strParam[4]);
            SN2MsgLogger.getLogger().severe("Invalid parameter. XML path:" + strParam[4]);
        }
        return bRet;
    }

    static boolean isValidPath(String strPath) {
        boolean bRet = true;
        try {
            if (strPath != null) {
                File tmpFile = new File(strPath);
                bRet = tmpFile.exists();
                if (!bRet) {
                    SN2MsgLogger.getLogger().warning("Invalid file path:" + strPath);
                }
            } else {
                SN2MsgLogger.getLogger().warning("Invalid file path(null).");
                bRet = false;
            }
        }
        catch (Exception jvExp) {
            jvExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.WARNING, "Invalid Path", jvExp);
            bRet = false;
        }
        return bRet;
    }
}

