/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class SN2MsgLogFormatter
extends Formatter {
    private final SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.sdFormat.format(new Date(record.getMillis())));
        sb.append(" ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record.getSourceMethodName());
        }
        sb.append(this.lineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

