/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller;

import java.util.ArrayList;
import java.util.logging.Level;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.SN2MsgCtrlMacro;
import sanproject.sn2msg.controller.initdb.SN2MsgCtrlInitdbMain;
import sanproject.sn2msg.controller.makecsv.SN2MsgCtrlMakecsvMain;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlMain;
import sanproject.sn2msg.model.SN2MsgMdlException;
import sanproject.sn2msg.model.SN2MsgMdlMain;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgCtrlMain
implements SN2MsgCtrlMacro {
    static SN2MsgCtrlMain m_Ctrl = null;

    public static SN2MsgCtrlMain getInstance() {
        if (m_Ctrl == null) {
            m_Ctrl = new SN2MsgCtrlMain();
            SN2MsgLogger.getLogger().info("getInstance() instance created.");
        }
        return m_Ctrl;
    }

    public static void endInstance() {
        m_Ctrl = null;
        SN2MsgLogger.getLogger().info("endInstance() finished.");
    }

    public void initDB(String strCsvPath, String strDbName) throws SN2MsgCtrlException {
        SN2MsgCtrlInitdbMain initDbMain = new SN2MsgCtrlInitdbMain(strCsvPath, strDbName);
        initDbMain.initDB();
    }

    public void makeXML(String strOutPath, String strDbName, String strRev) throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp = null;
        SN2MsgMdlMain model = SN2MsgMdlMain.getInstance();
        try {
            ArrayList<SN2MsgMdlAllData> alAllMsg = model.getAllMessage(strDbName, false, strRev);
            SN2MsgCtrlMakexmlMain makeXmlMain = new SN2MsgCtrlMakexmlMain(strOutPath, alAllMsg);
            makeXmlMain.makeXML();
        }
        catch (SN2MsgMdlException mdlExp) {
            mdlExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.WARNING, "Model error has occured:", mdlExp);
            ctrlExp = new SN2MsgCtrlException();
            ctrlExp.setIErrorCode(6);
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
    }

    public void makeCSV(String strOutPath, String strDbName, String strRev, boolean bRsv) throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp = null;
        SN2MsgMdlMain model = SN2MsgMdlMain.getInstance();
        try {
            ArrayList<SN2MsgMdlAllData> alAllMsg = model.getAllMessage(strDbName, false, strRev);
            SN2MsgCtrlMakecsvMain makeCsvMain = new SN2MsgCtrlMakecsvMain(strOutPath, alAllMsg, bRsv);
            makeCsvMain.makeCSV();
        }
        catch (SN2MsgMdlException mdlExp) {
            mdlExp.printStackTrace();
            SN2MsgLogger.getLogger().log(Level.WARNING, "Model error has occured:", mdlExp);
            ctrlExp = new SN2MsgCtrlException();
            ctrlExp.setIErrorCode(6);
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
    }

    boolean isValidDeleteID(String strId) {
        boolean bRet = true;
        String[] strIdTmp = strId.split("/");
        if (2 > strIdTmp.length) {
            SN2MsgLogger.getLogger().warning("Invalid ID:" + strId);
            bRet = false;
        } else {
            try {
                int iFuncId = Integer.parseInt(strIdTmp[0]);
                int iModId = Integer.parseInt(strIdTmp[1]);
                if (iModId == 0) {
                    SN2MsgLogger.getLogger().warning("Invalid ID:" + strId);
                    bRet = false;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(jvExp.toString());
                SN2MsgLogger.getLogger().warning("Invalid ID:" + strId);
                bRet = false;
            }
        }
        return bRet;
    }

    public void deleteMessage(String strDbName, String strId) throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp = null;
        SN2MsgMdlMain model = SN2MsgMdlMain.getInstance();
        if (this.isValidDeleteID(strId)) {
            try {
                String strKey = strId.concat("%");
                ArrayList<SN2MsgMdlMsgIdxData> alMsgList = model.getSpecifiedMessageIndex(strDbName, strKey);
                SN2MsgLogger.getLogger().info("Number of messages to be deleted:" + alMsgList.size());
                int iMsg = 0;
                while (iMsg < alMsgList.size()) {
                    SN2MsgMdlMsgIdxData tmpMsg = alMsgList.get(iMsg);
                    if (model.deleteRecordFromAllTables(strDbName, tmpMsg.getStrMsgId())) {
                        SN2MsgLogger.getLogger().info("Delete record has succeeded:" + tmpMsg.getStrMsgId());
                    }
                    ++iMsg;
                }
            }
            catch (SN2MsgMdlException mdlExp) {
                mdlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning("Model error has occured:" + mdlExp.getErrCode());
                ctrlExp = new SN2MsgCtrlException();
                ctrlExp.setIErrorCode(6);
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid ID:" + strId);
            ctrlExp = new SN2MsgCtrlException();
            ctrlExp.setIErrorCode(7);
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
    }
}

