/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller.makexml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlMacro;
import sanproject.sn2msg.controller.makexml.data.SN2MsgCtrlMakexmlFuncIdData;
import sanproject.sn2msg.controller.makexml.data.SN2MsgCtrlMakexmlGrpData;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgCtrlMakexmlOutput_HIE
implements SN2MsgCtrlMakexmlMacro {
    String m_StrPath = null;
    ArrayList<SN2MsgCtrlMakexmlGrpData> m_AlGrp = null;
    int m_OutputMsgCnt = 0;
    String[] m_UserGuideName = new String[0];
    public static final String STR_TAG_CHAPTER = "<chapter id=\"chap%03d\">";
    public static final String STR_TAG_CHAPTER_END = "</chapter>";
    public static final String STR_TAG_ROW = "<row>";
    public static final String STR_TAG_ROW_END = "</row>";
    public static final String STR_TAG_TABLE = "<table pgwide=\"1\">";
    public static final String STR_TAG_TABLE_END = "</table>";
    public static final String STR_TAG_TGRP = "<tgroup cols=\"5\">";
    public static final String STR_TAG_TGRP_END = "</tgroup>";
    public static final String STR_TAG_COLSPEC = "<colspec colname=\"%d\" colwidth=\"%s\"/>";
    public static final String STR_TAG_THEAD = "<thead>";
    public static final String STR_TAG_THEAD_END = "</thead>";
    public static final String STR_TAG_ENTRY = "<entry>";
    public static final String STR_TAG_ENTRY_END = "</entry>";
    public static final String STR_TAG_TBODY = "<tbody>";
    public static final String STR_TAG_TBODY_END = "</tbody>";
    public static final String STR_GRPTITLE = "Message (part code group %snnn)";
    public static final String STR_ABS = "This chapter includes the error messages with the part code %s to %s.";
    public static final String STR_ABS_ONEPART = "This chapter includes the error messages with the part code %s.";
    public static final String STR_SCT_TITLE = "Part code %s";
    public static final String STR_TBL_TITLE = "Error codes (part code %s)";
    public static final String STR_COL_PART = "Part Code";
    public static final String STR_COL_CODE = "Error Number";
    public static final String STR_COL_MSG = "Error Message";
    public static final String STR_COL_MSR = "Recommended Action";
    public static final String STR_COL_ICN = "Severity Level";
    public static final String[] STR_COL_WIDTH = new String[]{"8*", "10*", "32*", "39*", "11*"};
    public static final String[] STR_COLS = new String[]{"Part Code", "Error Number", "Error Message", "Recommended Action", "Severity Level"};
    public static final String STR_NA = "-";

    public SN2MsgCtrlMakexmlOutput_HIE(String strPath, ArrayList<SN2MsgCtrlMakexmlGrpData> alGrp, ArrayList<String[]> alUgNameRow) {
        this.m_StrPath = strPath;
        this.m_AlGrp = alGrp;
        this.makeUserGuideName(alUgNameRow);
    }

    int getUgNameColumn() {
        return 0;
    }

    void makeUserGuideName(ArrayList<String[]> alUgNameRow) {
        ArrayList<String> alTmp = new ArrayList<String>();
        int iRow = 0;
        while (iRow < alUgNameRow.size()) {
            String[] strRow = alUgNameRow.get(iRow);
            if (!strRow[this.getUgNameColumn()].isEmpty()) {
                alTmp.add(strRow[this.getUgNameColumn()]);
            }
            ++iRow;
        }
        this.m_UserGuideName = alTmp.toArray(this.m_UserGuideName);
    }

    String getFileName() {
        return "pdf-hds.xml";
    }

    String getMessageString(SN2MsgMdlAllData mdlData) {
        return mdlData.getMessage().getStrHie_en();
    }

    String getMeasureString(SN2MsgMdlAllData mdlData) {
        return mdlData.getMeasure().getStrHie_en();
    }

    String makeMeasureString(SN2MsgMdlAllData mdlData) {
        String strRet = this.getMeasureString(mdlData);
        if (strRet.length() == 0) {
            strRet = STR_NA;
        }
        return strRet;
    }

    String getIconString(SN2MsgMdlAllData mdlData) {
        return mdlData.getIcon().getStrHie_en();
    }

    int getOemChkPos() {
        return 0;
    }

    boolean isDisregardOem(SN2MsgMdlMsgIdxData msgIdx) {
        boolean bRet = msgIdx.getBitDisregardOem().get(this.getOemChkPos());
        return bRet;
    }

    String getLanguage() {
        return "en";
    }

    void makeXMLHeader(BufferedWriter bufWr) throws Exception {
        bufWr.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        bufWr.write("\n");
        bufWr.write("<!DOCTYPE book PUBLIC \"-//Hitachi Data Systems//DTD DocBook XML V4.2-Based Subset HiCommand Manual V1.0//EN\" \"hdsman.dtd\">");
        bufWr.write("\n");
        bufWr.write(String.format("<book lang=\"%s\">", this.getLanguage()));
        bufWr.write("\n");
    }

    void makeFooter(BufferedWriter bufWr) throws Exception {
        bufWr.write("</book>");
        bufWr.write("\n");
    }

    String getGrpTitle(String strStartFuncCode) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<title>");
        strBuf.append(String.format(STR_GRPTITLE, strStartFuncCode.substring(0, 2)));
        strBuf.append("</title>");
        return strBuf.toString();
    }

    String getAbstract(String strSt, String strEnd) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<abstract>");
        strBuf.append("<para>");
        if (strSt.equals(strEnd)) {
            strBuf.append(String.format(STR_ABS_ONEPART, strSt));
        } else {
            strBuf.append(String.format(STR_ABS, strSt, strEnd));
        }
        strBuf.append("</para>");
        strBuf.append("</abstract>");
        return strBuf.toString();
    }

    void makeTableHeader(BufferedWriter bufWr) throws Exception {
        int iCol = 0;
        while (iCol < STR_COL_WIDTH.length) {
            bufWr.write(String.format(STR_TAG_COLSPEC, iCol + 1, STR_COL_WIDTH[iCol]));
            bufWr.write("\n");
            ++iCol;
        }
        bufWr.write(STR_TAG_THEAD);
        bufWr.write("\n");
        bufWr.write(STR_TAG_ROW);
        bufWr.write("\n");
        int iCols = 0;
        while (iCols < STR_COLS.length) {
            bufWr.write(STR_TAG_ENTRY);
            bufWr.write("<para>");
            bufWr.write(STR_COLS[iCols]);
            bufWr.write("</para>");
            bufWr.write(STR_TAG_ENTRY_END);
            bufWr.write("\n");
            ++iCols;
        }
        bufWr.write(STR_TAG_ROW_END);
        bufWr.write("\n");
        bufWr.write(STR_TAG_THEAD_END);
        bufWr.write("\n");
    }

    String trimIconString(String strIcon) {
        String strRet = STR_NA;
        if (strIcon.length() != 0) {
            strRet = strIcon.substring(0, 1);
            if (strIcon.equals("INFORMATION")) {
                strRet = strRet.toLowerCase();
            }
        }
        return strRet;
    }

    static String convertUserGuideName(String strMsg, String[] strUgName) {
        String strRet = strMsg.toString();
        int iUg = 0;
        while (iUg < strUgName.length) {
            if (-1 != strRet.indexOf(strUgName[iUg])) {
                StringBuffer strUg = new StringBuffer();
                strUg.append("<citetitle>");
                strUg.append(strUgName[iUg]);
                strUg.append("</citetitle>");
                try {
                    strRet = strRet.replaceAll(strUgName[iUg], strUg.toString());
                }
                catch (Exception jvExp) {
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    SN2MsgLogger.getLogger().warning("Invalid UG name:" + strUgName[iUg]);
                }
            }
            ++iUg;
        }
        return strRet;
    }

    static String convertXmlString(String strMsg) {
        String strRet = strMsg.replaceAll("&", "&amp;");
        strRet = strRet.replaceAll("<", "&lt;");
        strRet = strRet.replaceAll(">", "&gt;");
        return strRet;
    }

    boolean isItemizedMsg(String strRow) {
        boolean bRet = true;
        if (strRow.startsWith(STR_NA)) {
            if (strRow.startsWith("---")) {
                bRet = false;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    static String convertVariableString(String strMsg, String strAfter) {
        String strRet = strMsg.replaceAll("%d", strAfter);
        strRet = strRet.replaceAll("%s", strAfter);
        strRet = strRet.replaceAll("\\{\\d{1,3}\\}", strAfter);
        return strRet;
    }

    public String convertString(String strMsg) {
        String strRet = SN2MsgCtrlMakexmlOutput_HIE.convertXmlString(strMsg);
        strRet = SN2MsgCtrlMakexmlOutput_HIE.convertUserGuideName(strRet, this.m_UserGuideName);
        strRet = SN2MsgCtrlMakexmlOutput_HIE.convertVariableString(strRet, "<replaceable>xxx</replaceable>");
        return strRet;
    }

    String makeString(String strMsg) throws Exception {
        StringBuffer strRet = new StringBuffer();
        String strTmp = this.convertString(strMsg);
        String[] strElm = strTmp.split("\\\\\\\\n");
        boolean bItemizedList = false;
        int iElm = 0;
        while (iElm < strElm.length) {
            String strElmTmp = strElm[iElm].trim();
            if (strElmTmp.length() != 0) {
                if (this.isItemizedMsg(strElmTmp) && 1 != strElmTmp.length()) {
                    if (!bItemizedList) {
                        strRet.append("<itemizedlist>");
                        bItemizedList = true;
                    }
                    strRet.append("<listitem>");
                    strElmTmp = strElmTmp.replaceFirst(STR_NA, "");
                }
                strRet.append("<para>");
                strRet.append(strElmTmp.trim());
                strRet.append("</para>");
                if (bItemizedList && this.isItemizedMsg(strElm[iElm].trim())) {
                    strRet.append("</listitem>");
                    if (strElm.length == iElm + 1) {
                        strRet.append("</itemizedlist>");
                        bItemizedList = false;
                    } else {
                        String strNext = strElm[iElm + 1].trim();
                        if (!this.isItemizedMsg(strNext)) {
                            strRet.append("</itemizedlist>");
                            bItemizedList = false;
                        }
                    }
                }
                strRet.append("\n");
            }
            ++iElm;
        }
        return strRet.toString();
    }

    void makeMessageColumn(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(STR_TAG_ENTRY);
        strBuf.append(this.makeString(this.getMessageString(mdlData)));
        strBuf.insert(strBuf.length() - 1, STR_TAG_ENTRY_END);
        bufWr.write(strBuf.toString());
    }

    void makeMeasureColumn(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(STR_TAG_ENTRY);
        strBuf.append(this.makeString(this.makeMeasureString(mdlData)));
        strBuf.insert(strBuf.length() - 1, STR_TAG_ENTRY_END);
        bufWr.write(strBuf.toString());
    }

    void makeIconColumn(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        bufWr.write(STR_TAG_ENTRY);
        bufWr.write("<para>");
        bufWr.write(this.trimIconString(this.getIconString(mdlData)));
        bufWr.write("</para>");
        bufWr.write(STR_TAG_ENTRY_END);
        bufWr.write("\n");
    }

    void makeMessageRow(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        SN2MsgMdlMsgIdxData msgIdx = mdlData.getMsgIdx();
        String[] strCode = msgIdx.getStrMsgId().split("/");
        if (strCode.length == 3) {
            bufWr.write(STR_TAG_ROW);
            bufWr.write("\n");
            bufWr.write(STR_TAG_ENTRY);
            bufWr.write("<para>");
            bufWr.write(strCode[0]);
            bufWr.write(strCode[1]);
            bufWr.write("</para>");
            bufWr.write(STR_TAG_ENTRY_END);
            bufWr.write("\n");
            bufWr.write(STR_TAG_ENTRY);
            bufWr.write("<para>");
            bufWr.write(strCode[2]);
            bufWr.write("</para>");
            bufWr.write(STR_TAG_ENTRY_END);
            bufWr.write("\n");
            this.makeMessageColumn(bufWr, mdlData);
            this.makeMeasureColumn(bufWr, mdlData);
            this.makeIconColumn(bufWr, mdlData);
            bufWr.write(STR_TAG_ROW_END);
            bufWr.write("\n");
            ++this.m_OutputMsgCnt;
        } else {
            SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException("Invalid parameter:" + mdlData.toString());
            ctrlExp.setIErrorCode(-1);
            throw ctrlExp;
        }
    }

    void makeFuncIdMessage(BufferedWriter bufWr, SN2MsgCtrlMakexmlFuncIdData funcIdData) throws Exception {
        bufWr.write("<section>");
        bufWr.write("<title>");
        bufWr.write(String.format(STR_SCT_TITLE, funcIdData.getStrFuncId()));
        bufWr.write("</title>");
        bufWr.write("\n");
        bufWr.write(STR_TAG_TABLE);
        bufWr.write("<title>");
        bufWr.write(String.format(STR_TBL_TITLE, funcIdData.getStrFuncId()));
        bufWr.write("</title>");
        bufWr.write(STR_TAG_TGRP);
        bufWr.write("\n");
        this.makeTableHeader(bufWr);
        bufWr.write(STR_TAG_TBODY);
        bufWr.write("\n");
        int iFuncMsg = 0;
        while (iFuncMsg < funcIdData.getAlMsgList().size()) {
            SN2MsgMdlAllData mdlData = funcIdData.getAlMsgList().get(iFuncMsg);
            try {
                if (!this.isDisregardOem(mdlData.getMsgIdx()) && !mdlData.getMsgIdx().getBRsv()) {
                    this.makeMessageRow(bufWr, mdlData);
                } else {
                    SN2MsgLogger.getLogger().info("Message skipped\uff1a" + mdlData.toString());
                }
            }
            catch (Exception jvExp) {
                SN2MsgLogger.getLogger().warning("XML output failed:" + mdlData.toString());
                SN2MsgLogger.getLogger().warning(jvExp.toString());
                SN2MsgLogger.getLogger().warning(jvExp.getMessage());
            }
            ++iFuncMsg;
        }
        bufWr.write(STR_TAG_TBODY_END);
        bufWr.write("\n");
        bufWr.write(STR_TAG_TGRP_END);
        bufWr.write(STR_TAG_TABLE_END);
        bufWr.write("</section>");
        bufWr.write("\n");
    }

    void makeGrpMessage(BufferedWriter bufWr, SN2MsgCtrlMakexmlGrpData grpData, int iCnt) throws Exception {
        bufWr.write(String.format(STR_TAG_CHAPTER, iCnt + 1));
        bufWr.write("\n");
        bufWr.write(this.getGrpTitle(grpData.getStrStartFuncId()));
        bufWr.write("\n");
        bufWr.write(this.getAbstract(grpData.getStrStartFuncId(), grpData.getEndFuncId()));
        bufWr.write("\n");
        int iFunc = 0;
        while (iFunc < grpData.getAlFuncIdList().size()) {
            SN2MsgCtrlMakexmlFuncIdData funcIdData = grpData.getAlFuncIdList().get(iFunc);
            this.makeFuncIdMessage(bufWr, funcIdData);
            ++iFunc;
        }
        bufWr.write(STR_TAG_CHAPTER_END);
        bufWr.write("\n");
    }

    public void outputXML() throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp;
        block25: {
            FileOutputStream flOut = null;
            OutputStreamWriter streamWr = null;
            BufferedWriter bufWr = null;
            String strPath = String.valueOf(this.m_StrPath) + File.separator + this.getFileName();
            ctrlExp = null;
            try {
                try {
                    flOut = new FileOutputStream(strPath);
                    streamWr = new OutputStreamWriter((OutputStream)flOut, Charset.forName("UTF-8"));
                    bufWr = new BufferedWriter(streamWr);
                    this.makeXMLHeader(bufWr);
                    bufWr.flush();
                    int iMsg = 0;
                    while (iMsg < this.m_AlGrp.size()) {
                        this.makeGrpMessage(bufWr, this.m_AlGrp.get(iMsg), iMsg);
                        bufWr.flush();
                        ++iMsg;
                    }
                    this.makeFooter(bufWr);
                    bufWr.flush();
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.WARNING, "File write error", jvExp);
                    ctrlExp = new SN2MsgCtrlException("File write error:" + jvExp.toString());
                    ctrlExp.setIErrorCode(-1);
                    try {
                        if (bufWr != null) {
                            bufWr.flush();
                            bufWr.close();
                        }
                    }
                    catch (Exception flExp) {
                        flExp.printStackTrace();
                        SN2MsgLogger.getLogger().log(Level.WARNING, "Buffer close failed.", flExp);
                    }
                    try {
                        if (flOut != null) {
                            flOut.close();
                        }
                    }
                    catch (Exception flExp) {
                        flExp.printStackTrace();
                        SN2MsgLogger.getLogger().log(Level.WARNING, "File close failed.", flExp);
                    }
                    SN2MsgLogger.getLogger().info("Output number of messages:" + this.m_OutputMsgCnt);
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufWr != null) {
                        bufWr.flush();
                        bufWr.close();
                    }
                }
                catch (Exception flExp) {
                    flExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.WARNING, "Buffer close failed.", flExp);
                }
                try {
                    if (flOut != null) {
                        flOut.close();
                    }
                }
                catch (Exception flExp) {
                    flExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.WARNING, "File close failed.", flExp);
                }
                SN2MsgLogger.getLogger().info("Output number of messages:" + this.m_OutputMsgCnt);
                throw throwable;
            }
            try {
                if (bufWr != null) {
                    bufWr.flush();
                    bufWr.close();
                }
            }
            catch (Exception flExp) {
                flExp.printStackTrace();
                SN2MsgLogger.getLogger().log(Level.WARNING, "Buffer close failed.", flExp);
            }
            try {
                if (flOut != null) {
                    flOut.close();
                }
            }
            catch (Exception flExp) {
                flExp.printStackTrace();
                SN2MsgLogger.getLogger().log(Level.WARNING, "File close failed.", flExp);
            }
            SN2MsgLogger.getLogger().info("Output number of messages:" + this.m_OutputMsgCnt);
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
    }
}

