/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller.makexml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlMacro;
import sanproject.sn2msg.controller.makexml.SN2MsgCtrlMakexmlOutput_HIE;
import sanproject.sn2msg.controller.makexml.data.SN2MsgCtrlMakexmlFuncIdData;
import sanproject.sn2msg.controller.makexml.data.SN2MsgCtrlMakexmlGrpData;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgCtrlMakexmlOutput_HIJ
implements SN2MsgCtrlMakexmlMacro {
    String m_StrPath = null;
    ArrayList<SN2MsgCtrlMakexmlGrpData> m_AlGrp = null;
    int m_OutputMsgCnt = 0;
    String[] m_UserGuideName = new String[0];
    public static final String STR_TAG_CHAPTER_JA = "<chapter>";
    public static final String STR_TAG_CHAPTER_END = "</chapter>";
    public static final String STR_TAG_VARIABLELIST = "<variablelist>";
    public static final String STR_TAG_VARIABLELIST_END = "</variablelist>";
    public static final String STR_TAG_VARLISTENTRY = "<varlistentry>";
    public static final String STR_TAG_VARLISTENTRY_END = "</varlistentry>";
    public static final String STR_TAG_TERM = "<term>";
    public static final String STR_TAG_TERM_END = "</term>";
    public static final String STR_TAG_NOTE = "<note>";
    public static final String STR_TAG_NOTE_END = "</note>";
    public static final String STR_GRPTITLE_JA = "\u30e1\u30c3\u30bb\u30fc\u30b8(\u90e8\u4f4d\u30b3\u30fc\u30c9\u30b0\u30eb\u30fc\u30d7%snnn)";
    public static final String STR_ABS_JA = "\u3053\u3053\u3067\u306f\u3001\u90e8\u4f4d\u30b3\u30fc\u30c9%s\u304b\u3089%s\u307e\u3067\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002";
    public static final String STR_ABS_ONEPART_JA = "\u3053\u3053\u3067\u306f\u3001\u90e8\u4f4d\u30b3\u30fc\u30c9%s\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u793a\u3057\u3066\u3044\u307e\u3059\u3002";
    public static final String STR_SCT_TITLE_JA = "\u90e8\u4f4d\u30b3\u30fc\u30c9%s";
    public static final String STR_ICN_FORMAT = "\uff08%s\uff09";
    public static final String STR_SPACE = " ";
    public static final String STR_NA = "";
    public static final String STR_ANNOTATION = "\u30e1\u30e2\uff1a\u65e5\u672c\u8a9e\u8868\u8a18\u306f\u53c2\u8003\u3067\u3059\u3002\u5b9f\u969b\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u306f\u82f1\u8a9e\u3067\u8868\u793a\u3055\u308c\u307e\u3059\u3002";
    public static final String STR_MEASURE_EXP = "\u5bfe\u51e6\u65b9\u6cd5\uff1a";

    public SN2MsgCtrlMakexmlOutput_HIJ(String strPath, ArrayList<SN2MsgCtrlMakexmlGrpData> alGrp, ArrayList<String[]> alUgNameRow) {
        this.m_StrPath = strPath;
        this.m_AlGrp = alGrp;
        this.makeUserGuideName(alUgNameRow);
    }

    int getUgNameColumn_EN() {
        return 2;
    }

    int getUgNameColumn_JA() {
        return 4;
    }

    void makeUserGuideName(ArrayList<String[]> alUgNameRow) {
        ArrayList<String> alTmp = new ArrayList<String>();
        int iRow = 0;
        while (iRow < alUgNameRow.size()) {
            String[] strRow = alUgNameRow.get(iRow);
            if (!strRow[this.getUgNameColumn_EN()].isEmpty()) {
                alTmp.add(strRow[this.getUgNameColumn_EN()]);
            }
            if (!strRow[this.getUgNameColumn_JA()].isEmpty()) {
                alTmp.add(strRow[this.getUgNameColumn_JA()]);
            }
            ++iRow;
        }
        this.m_UserGuideName = alTmp.toArray(this.m_UserGuideName);
    }

    String getFileName() {
        return "pdf-hitachi.xml";
    }

    String getMessageString_EN(SN2MsgMdlAllData mdlData) {
        return mdlData.getMessage().getStrHij_en();
    }

    String getMeasureString_EN(SN2MsgMdlAllData mdlData) {
        return mdlData.getMeasure().getStrHij_en();
    }

    String getMessageString_JA(SN2MsgMdlAllData mdlData) {
        return mdlData.getMessage().getStrHij_ja();
    }

    String getMeasureString_JA(SN2MsgMdlAllData mdlData) {
        return mdlData.getMeasure().getStrHij_ja();
    }

    String getIconString(SN2MsgMdlAllData mdlData) {
        return mdlData.getIcon().getStrHij_en();
    }

    int getOemChkPos() {
        return 1;
    }

    boolean isDisregardOem(SN2MsgMdlMsgIdxData msgIdx) {
        boolean bRet = msgIdx.getBitDisregardOem().get(this.getOemChkPos());
        return bRet;
    }

    String getLanguage() {
        return "ja";
    }

    void makeXMLHeader(BufferedWriter bufWr) throws Exception {
        bufWr.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        bufWr.write("\n");
        bufWr.write("<!DOCTYPE book PUBLIC \"-//Hitachi Data Systems//DTD DocBook XML V4.2-Based Subset HiCommand Manual V1.0//EN\" \"hdsman.dtd\">");
        bufWr.write("\n");
        bufWr.write(String.format("<book lang=\"%s\">", this.getLanguage()));
        bufWr.write("\n");
    }

    void makeFooter(BufferedWriter bufWr) throws Exception {
        bufWr.write("</book>");
        bufWr.write("\n");
    }

    String getGrpTitle(String strStartFuncCode) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<title>");
        strBuf.append(String.format(STR_GRPTITLE_JA, strStartFuncCode.substring(0, 2)));
        strBuf.append("</title>");
        return strBuf.toString();
    }

    String getAbstract(String strSt, String strEnd) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<abstract>");
        strBuf.append("<para>");
        if (strSt.equals(strEnd)) {
            strBuf.append(String.format(STR_ABS_ONEPART_JA, strSt));
        } else {
            strBuf.append(String.format(STR_ABS_JA, strSt, strEnd));
        }
        strBuf.append("</para>");
        strBuf.append("</abstract>");
        return strBuf.toString();
    }

    String trimIconString(String strIcon) {
        String strRet = STR_NA;
        if (strIcon.length() != 0) {
            strRet = strIcon.substring(0, 1);
            if (strIcon.equals("INFORMATION")) {
                strRet = strRet.toLowerCase();
            }
            strRet = String.format(STR_ICN_FORMAT, strRet);
        }
        return strRet;
    }

    boolean isItemizedMsg(String strRow) {
        boolean bRet = true;
        if (strRow.startsWith("-")) {
            if (strRow.startsWith("---")) {
                bRet = false;
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    public String convertString(String strMsg) {
        String strVarXml = "<replaceable>xxx</replaceable>";
        try {
            String strAscii = new String(strMsg.getBytes(), "US-ASCII");
            if (!strMsg.equals(strAscii)) {
                strVarXml = "<replaceable>\uff1cxxx\uff1e</replaceable>";
            }
        }
        catch (Exception jvExp) {
            jvExp.printStackTrace();
        }
        String strRet = SN2MsgCtrlMakexmlOutput_HIE.convertXmlString(strMsg);
        strRet = SN2MsgCtrlMakexmlOutput_HIE.convertUserGuideName(strRet, this.m_UserGuideName);
        strRet = SN2MsgCtrlMakexmlOutput_HIE.convertVariableString(strRet, strVarXml);
        return strRet;
    }

    String makeString(String strMsg, String strMeasureTitle) throws Exception {
        StringBuffer strRet = new StringBuffer();
        String strTmp = this.convertString(strMsg);
        String[] strElm = strTmp.split("\\\\\\\\n");
        boolean bItemizedList = false;
        int iElm = 0;
        while (iElm < strElm.length) {
            String strElmTmp = strElm[iElm].trim();
            if (strElmTmp.length() != 0) {
                if (this.isItemizedMsg(strElmTmp) && 1 != strElmTmp.length()) {
                    if (!bItemizedList) {
                        if (iElm == 0 && strMeasureTitle.length() != 0) {
                            strRet.append("<para>");
                            strRet.append(strMeasureTitle);
                            strRet.append("</para>");
                            strRet.append("\n");
                        }
                        strRet.append("<itemizedlist>");
                        bItemizedList = true;
                    }
                    strRet.append("<listitem>");
                    strElmTmp = strElmTmp.replaceFirst("-", STR_NA);
                }
                if (iElm == 0) {
                    if (bItemizedList) {
                        strRet.append("<para>");
                        strRet.append(strElmTmp.trim());
                        strRet.append("</para>");
                    } else {
                        strRet.append("<para>");
                        strRet.append(strMeasureTitle);
                        strRet.append(strElmTmp.trim());
                        strRet.append("</para>");
                    }
                } else {
                    strRet.append("<para>");
                    strRet.append(strElmTmp.trim());
                    strRet.append("</para>");
                }
                if (bItemizedList && this.isItemizedMsg(strElm[iElm].trim())) {
                    strRet.append("</listitem>");
                    if (strElm.length == iElm + 1) {
                        strRet.append("</itemizedlist>");
                        bItemizedList = false;
                    } else {
                        String strNext = strElm[iElm + 1].trim();
                        if (!this.isItemizedMsg(strNext)) {
                            strRet.append("</itemizedlist>");
                            bItemizedList = false;
                        }
                    }
                }
                strRet.append("\n");
            }
            ++iElm;
        }
        return strRet.toString();
    }

    void makeCodeRow(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        SN2MsgMdlMsgIdxData msgIdx = mdlData.getMsgIdx();
        String[] strCode = msgIdx.getStrMsgId().split("/");
        if (strCode.length != 3) {
            SN2MsgCtrlException ctrlExp = new SN2MsgCtrlException("Invalid parameter:" + mdlData.toString());
            ctrlExp.setIErrorCode(-1);
            throw ctrlExp;
        }
        bufWr.write(STR_TAG_TERM);
        bufWr.write(strCode[0]);
        bufWr.write(strCode[1]);
        bufWr.write(STR_SPACE);
        bufWr.write(strCode[2]);
        bufWr.write(this.trimIconString(this.getIconString(mdlData)));
        bufWr.write(STR_TAG_TERM_END);
        bufWr.write("\n");
    }

    void makeMessageRow(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        if (mdlData.getMsgIdx().isAnnotationMsg()) {
            bufWr.append("<para>");
            bufWr.append(STR_ANNOTATION);
            bufWr.append("</para>");
            bufWr.append("\n");
        }
        bufWr.write(this.makeString(this.getMessageString_JA(mdlData), STR_NA));
        bufWr.write(this.makeString(this.getMessageString_EN(mdlData), STR_NA));
    }

    void makeMeasureRow(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        String strJa = this.getMeasureString_JA(mdlData);
        String strEn = this.getMeasureString_EN(mdlData);
        if (strJa.length() != 0) {
            bufWr.write(this.makeString(strJa, STR_MEASURE_EXP));
            if (strEn.length() != 0) {
                String strEnMsr = this.makeString(strEn, STR_NA);
                bufWr.write(strEnMsr.trim());
            }
        }
    }

    void makeMessageRows(BufferedWriter bufWr, SN2MsgMdlAllData mdlData) throws Exception {
        bufWr.write(STR_TAG_VARIABLELIST);
        bufWr.write(STR_TAG_VARLISTENTRY);
        this.makeCodeRow(bufWr, mdlData);
        bufWr.write("<listitem>");
        this.makeMessageRow(bufWr, mdlData);
        this.makeMeasureRow(bufWr, mdlData);
        bufWr.write("</listitem>");
        bufWr.write(STR_TAG_VARLISTENTRY_END);
        bufWr.write(STR_TAG_VARIABLELIST_END);
        bufWr.write("\n");
    }

    void makeFuncIdMessage(BufferedWriter bufWr, SN2MsgCtrlMakexmlFuncIdData funcIdData) throws Exception {
        bufWr.write("<section>");
        bufWr.write("<title>");
        bufWr.write(String.format(STR_SCT_TITLE_JA, funcIdData.getStrFuncId()));
        bufWr.write("</title>");
        bufWr.write("\n");
        int iFuncMsg = 0;
        while (iFuncMsg < funcIdData.getAlMsgList().size()) {
            SN2MsgMdlAllData mdlData = funcIdData.getAlMsgList().get(iFuncMsg);
            try {
                if (!this.isDisregardOem(mdlData.getMsgIdx()) && !mdlData.getMsgIdx().getBRsv()) {
                    this.makeMessageRows(bufWr, mdlData);
                    ++this.m_OutputMsgCnt;
                }
            }
            catch (Exception jvExp) {
                SN2MsgLogger.getLogger().warning("XML output failed:" + mdlData.toString());
                SN2MsgLogger.getLogger().warning(jvExp.toString());
                SN2MsgLogger.getLogger().warning(jvExp.getMessage());
            }
            ++iFuncMsg;
        }
        bufWr.write("</section>");
        bufWr.write("\n");
    }

    void makeGrpMessage(BufferedWriter bufWr, SN2MsgCtrlMakexmlGrpData grpData, int iCnt) throws Exception {
        bufWr.write(STR_TAG_CHAPTER_JA);
        bufWr.write("\n");
        bufWr.write(this.getGrpTitle(grpData.getStrStartFuncId()));
        bufWr.write("\n");
        bufWr.write(this.getAbstract(grpData.getStrStartFuncId(), grpData.getEndFuncId()));
        bufWr.write("\n");
        int iFunc = 0;
        while (iFunc < grpData.getAlFuncIdList().size()) {
            SN2MsgCtrlMakexmlFuncIdData funcIdData = grpData.getAlFuncIdList().get(iFunc);
            this.makeFuncIdMessage(bufWr, funcIdData);
            ++iFunc;
        }
        bufWr.write(STR_TAG_CHAPTER_END);
        bufWr.write("\n");
    }

    public void outputXML() throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp;
        block25: {
            FileOutputStream flOut = null;
            OutputStreamWriter streamWr = null;
            BufferedWriter bufWr = null;
            String strPath = String.valueOf(this.m_StrPath) + File.separator + this.getFileName();
            ctrlExp = null;
            try {
                try {
                    flOut = new FileOutputStream(strPath);
                    Charset charSet = Charset.forName("UTF-8");
                    streamWr = new OutputStreamWriter((OutputStream)flOut, charSet);
                    bufWr = new BufferedWriter(streamWr);
                    this.makeXMLHeader(bufWr);
                    bufWr.flush();
                    int iMsg = 0;
                    while (iMsg < this.m_AlGrp.size()) {
                        this.makeGrpMessage(bufWr, this.m_AlGrp.get(iMsg), iMsg);
                        bufWr.flush();
                        ++iMsg;
                    }
                    this.makeFooter(bufWr);
                    bufWr.flush();
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.WARNING, "File write error", jvExp);
                    ctrlExp = new SN2MsgCtrlException("File write error:" + jvExp.toString());
                    ctrlExp.setIErrorCode(-1);
                    try {
                        if (bufWr != null) {
                            bufWr.flush();
                            bufWr.close();
                        }
                    }
                    catch (Exception flExp) {
                        flExp.printStackTrace();
                        SN2MsgLogger.getLogger().log(Level.WARNING, "Buffer close failed.", flExp);
                    }
                    try {
                        if (flOut != null) {
                            flOut.close();
                        }
                    }
                    catch (Exception flExp) {
                        flExp.printStackTrace();
                        SN2MsgLogger.getLogger().log(Level.WARNING, "File close failed.", flExp);
                    }
                    SN2MsgLogger.getLogger().info("Output number of messages:" + this.m_OutputMsgCnt);
                    break block25;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufWr != null) {
                        bufWr.flush();
                        bufWr.close();
                    }
                }
                catch (Exception flExp) {
                    flExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.WARNING, "Buffer close failed.", flExp);
                }
                try {
                    if (flOut != null) {
                        flOut.close();
                    }
                }
                catch (Exception flExp) {
                    flExp.printStackTrace();
                    SN2MsgLogger.getLogger().log(Level.WARNING, "File close failed.", flExp);
                }
                SN2MsgLogger.getLogger().info("Output number of messages:" + this.m_OutputMsgCnt);
                throw throwable;
            }
            try {
                if (bufWr != null) {
                    bufWr.flush();
                    bufWr.close();
                }
            }
            catch (Exception flExp) {
                flExp.printStackTrace();
                SN2MsgLogger.getLogger().log(Level.WARNING, "Buffer close failed.", flExp);
            }
            try {
                if (flOut != null) {
                    flOut.close();
                }
            }
            catch (Exception flExp) {
                flExp.printStackTrace();
                SN2MsgLogger.getLogger().log(Level.WARNING, "File close failed.", flExp);
            }
            SN2MsgLogger.getLogger().info("Output number of messages:" + this.m_OutputMsgCnt);
        }
        if (ctrlExp != null) {
            throw ctrlExp;
        }
    }
}

