/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.model;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.model.SN2MsgMdlCommand;
import sanproject.sn2msg.model.SN2MsgMdlException;
import sanproject.sn2msg.model.SN2MsgMdlMacro;
import sanproject.sn2msg.model.ctrl.SN2MsgMdlCtrlBehaviorTbl;
import sanproject.sn2msg.model.ctrl.SN2MsgMdlCtrlIconTbl;
import sanproject.sn2msg.model.ctrl.SN2MsgMdlCtrlMeasureTbl;
import sanproject.sn2msg.model.ctrl.SN2MsgMdlCtrlMessageTbl;
import sanproject.sn2msg.model.ctrl.SN2MsgMdlCtrlMsgIdxTbl;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgData;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgIdxData;

public class SN2MsgMdlMain
implements SN2MsgMdlMacro {
    static SN2MsgMdlMain m_MdlMain = null;
    HashMap<String, SN2MsgMdlCommand> m_HashCmd = new HashMap();

    public static SN2MsgMdlMain getInstance() {
        if (m_MdlMain == null) {
            m_MdlMain = new SN2MsgMdlMain();
            SN2MsgLogger.getLogger().info("getInstance() instance created.");
        }
        return m_MdlMain;
    }

    public static void endInstance() {
        block7: {
            try {
                try {
                    if (m_MdlMain == null) break block7;
                    Collection<SN2MsgMdlCommand> cllct = SN2MsgMdlMain.m_MdlMain.m_HashCmd.values();
                    for (SN2MsgMdlCommand tmpCmd : cllct) {
                        if (tmpCmd != null) {
                            m_MdlMain.closeDB(tmpCmd.getStrDbName());
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    m_MdlMain = null;
                    SN2MsgLogger.getLogger().info("endInstance() finished.");
                }
            }
            finally {
                m_MdlMain = null;
                SN2MsgLogger.getLogger().info("endInstance() finished.");
            }
        }
    }

    public void openDB(String strDbName) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp = null;
        if (strDbName != null && strDbName.length() != 0) {
            String strDbUrl = String.format("jdbc:derby:%s", strDbName);
            strDbUrl = strDbUrl.concat(";create=true");
            try {
                SN2MsgMdlCommand mdlCmd = new SN2MsgMdlCommand();
                Connection Conn = DriverManager.getConnection(strDbUrl);
                mdlCmd.setConnection(Conn);
                mdlCmd.setStrDbName(strDbName);
                mdlCmd.setCtrlMessage(new SN2MsgMdlCtrlMessageTbl(Conn));
                mdlCmd.setCtrlMeasure(new SN2MsgMdlCtrlMeasureTbl(Conn));
                mdlCmd.setCtrlIcon(new SN2MsgMdlCtrlIconTbl(Conn));
                mdlCmd.setCtrlBehavior(new SN2MsgMdlCtrlBehaviorTbl(Conn));
                mdlCmd.setCtrlMsgIdx(new SN2MsgMdlCtrlMsgIdxTbl(Conn));
                this.m_HashCmd.put(strDbName, mdlCmd);
                SN2MsgLogger.getLogger().info("DB started:" + strDbUrl);
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().severe(sqlExp.getMessage());
                SN2MsgLogger.getLogger().severe(sqlExp.getSQLState());
                mdlExp = new SN2MsgMdlException(sqlExp.getCause());
                mdlExp.setErrCode(1);
            }
            catch (Exception exp) {
                exp.printStackTrace();
                SN2MsgLogger.getLogger().severe(exp.toString());
                SN2MsgLogger.getLogger().severe(exp.getMessage());
                mdlExp = new SN2MsgMdlException(exp.getCause());
                mdlExp.setErrCode(-1);
            }
        } else {
            SN2MsgLogger.getLogger().severe("Invalid parameter:" + strDbName);
            mdlExp = new SN2MsgMdlException("Invalid parameter:" + strDbName);
            mdlExp.setErrCode(5);
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
    }

    void closeDB(String strDbName) {
        block15: {
            try {
                try {
                    if (strDbName != null && strDbName.length() != 0) {
                        SN2MsgLogger.getLogger().info("Close:" + strDbName);
                        SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
                        if (mdlCmd != null) {
                            String strDbUrl = String.format("jdbc:derby:%s", strDbName);
                            strDbUrl.concat(";shutdown=true");
                            if (mdlCmd.getConnection() != null) {
                                DriverManager.getConnection(strDbUrl);
                                mdlCmd.getConnection().close();
                                SN2MsgLogger.getLogger().info("DB closed:" + strDbName);
                            } else {
                                SN2MsgLogger.getLogger().warning("Connection class failed:" + strDbName);
                            }
                        } else {
                            SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                        }
                    } else {
                        SN2MsgLogger.getLogger().warning("Invalid parameter:" + strDbName);
                    }
                }
                catch (SQLException sqlExp) {
                    SN2MsgLogger.getLogger().warning("SQL end state:" + sqlExp.getSQLState());
                    SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                    if (strDbName != null) {
                        this.m_HashCmd.remove(strDbName);
                    }
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    if (strDbName == null) break block15;
                    this.m_HashCmd.remove(strDbName);
                }
            }
            finally {
                if (strDbName != null) {
                    this.m_HashCmd.remove(strDbName);
                }
            }
        }
    }

    public boolean initAllTables(String strDbName) {
        boolean bRet = true;
        SN2MsgLogger.getLogger().info("Table initialize operation start:" + strDbName);
        SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
        if (mdlCmd != null) {
            if (!mdlCmd.getCtrlMsgIdx().initMsgIdxTbl()) {
                bRet = false;
            }
            if (!mdlCmd.getCtrlMessage().initTable()) {
                bRet = false;
            }
            if (!mdlCmd.getCtrlMeasure().initTable()) {
                bRet = false;
            }
            if (!mdlCmd.getCtrlIcon().initTable()) {
                bRet = false;
            }
            if (!mdlCmd.getCtrlBehavior().initTable()) {
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
            bRet = false;
        }
        return bRet;
    }

    public boolean deleteRecordFromAllTables(String strDbName, String strKey) {
        boolean bRet = true;
        if (strDbName != null && strKey != null) {
            SN2MsgLogger.getLogger().warning("Delete record:" + strKey);
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                if (!mdlCmd.getCtrlMsgIdx().deleteRecord(strKey)) {
                    SN2MsgLogger.getLogger().warning("Delete from MSG_IDX failed:" + strKey);
                    bRet = false;
                }
                if (!mdlCmd.getCtrlMessage().deleteRecord(strKey)) {
                    SN2MsgLogger.getLogger().warning("Delete from MESSAGE failed:" + strKey);
                    bRet = false;
                }
                if (!mdlCmd.getCtrlMeasure().deleteRecord(strKey)) {
                    SN2MsgLogger.getLogger().warning("Delete from MEASURE failed:" + strKey);
                    bRet = false;
                }
                if (!mdlCmd.getCtrlIcon().deleteRecord(strKey)) {
                    SN2MsgLogger.getLogger().warning("Delete from ICON failed:" + strKey);
                    bRet = false;
                }
                if (!mdlCmd.getCtrlBehavior().deleteRecord(strKey)) {
                    SN2MsgLogger.getLogger().warning("Delete from BEHAVIOR failed:" + strKey);
                    bRet = false;
                }
            } else {
                SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter");
            bRet = false;
        }
        return bRet;
    }

    boolean isValidErrorCode(String strCode) {
        boolean bRet = true;
        if (strCode != null) {
            String[] tmpCode = strCode.split("/");
            if (3 != tmpCode.length) {
                bRet = false;
            } else {
                try {
                    int iFuncId = Integer.parseInt(tmpCode[0]);
                    int iModId = Integer.parseInt(tmpCode[1]);
                    int iErrCode = Integer.parseInt(tmpCode[2]);
                }
                catch (Exception jvExp) {
                    bRet = false;
                }
            }
        } else {
            bRet = false;
        }
        return bRet;
    }

    public boolean makeMsgIdxRecord(String strDbName, SN2MsgMdlMsgIdxData msgData) {
        boolean bRet = true;
        if (strDbName != null && msgData != null) {
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                if (this.isValidErrorCode(msgData.getStrMsgId())) {
                    bRet = mdlCmd.getCtrlMsgIdx().makeRecord(msgData);
                    if (!bRet) {
                        SN2MsgLogger.getLogger().warning("Registration failed:" + msgData.getStrMsgId());
                    }
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid message ID:" + msgData.getStrMsgId());
                    bRet = false;
                }
            } else {
                SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter.");
            bRet = false;
        }
        return bRet;
    }

    public boolean makeMessageRecord(String strDbName, SN2MsgMdlMsgData msgData) {
        boolean bRet = true;
        if (strDbName != null && msgData != null) {
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                if (this.isValidErrorCode(msgData.getStrMsgId())) {
                    bRet = mdlCmd.getCtrlMessage().makeRecord(msgData);
                    if (!bRet) {
                        SN2MsgLogger.getLogger().warning("Registration failed:" + msgData.getStrMsgId());
                    }
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid message ID:" + msgData.getStrMsgId());
                    bRet = false;
                }
            } else {
                SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter.");
            bRet = false;
        }
        return bRet;
    }

    public boolean makeMeasureRecord(String strDbName, SN2MsgMdlMsgData msgData) {
        boolean bRet = true;
        if (strDbName != null && msgData != null) {
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                if (this.isValidErrorCode(msgData.getStrMsgId())) {
                    bRet = mdlCmd.getCtrlMeasure().makeRecord(msgData);
                    if (!bRet) {
                        SN2MsgLogger.getLogger().warning("Registration failed:" + msgData.getStrMsgId());
                    }
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid message ID:" + msgData.getStrMsgId());
                    bRet = false;
                }
            } else {
                SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter.");
            bRet = false;
        }
        return bRet;
    }

    public boolean makeIconRecord(String strDbName, SN2MsgMdlMsgData msgData) {
        boolean bRet = true;
        if (strDbName != null && msgData != null) {
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                if (this.isValidErrorCode(msgData.getStrMsgId())) {
                    bRet = mdlCmd.getCtrlIcon().makeRecord(msgData);
                    if (!bRet) {
                        SN2MsgLogger.getLogger().warning("Registration failed:" + msgData.getStrMsgId());
                    }
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid message ID:" + msgData.getStrMsgId());
                    bRet = false;
                }
            } else {
                SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter.");
            bRet = false;
        }
        return bRet;
    }

    public boolean makeBehaviorRecord(String strDbName, SN2MsgMdlMsgData msgData) {
        boolean bRet = true;
        if (strDbName != null && msgData != null) {
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                if (this.isValidErrorCode(msgData.getStrMsgId())) {
                    bRet = mdlCmd.getCtrlBehavior().makeRecord(msgData);
                    if (!bRet) {
                        SN2MsgLogger.getLogger().warning("Registration failed:" + msgData.getStrMsgId());
                    }
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid message ID:" + msgData.getStrMsgId());
                    bRet = false;
                }
            } else {
                SN2MsgLogger.getLogger().warning("Controll class failed:" + strDbName);
                bRet = false;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter.");
            bRet = false;
        }
        return bRet;
    }

    public boolean makeRecord(String strDbName, SN2MsgMdlAllData oneMsg) {
        boolean bRet = true;
        if (strDbName != null && oneMsg != null) {
            if (!this.makeMsgIdxRecord(strDbName, oneMsg.getMsgIdx())) {
                bRet = false;
            } else if (!this.makeMessageRecord(strDbName, oneMsg.getMessage())) {
                bRet = false;
            } else if (!this.makeMeasureRecord(strDbName, oneMsg.getMeasure())) {
                bRet = false;
            } else if (!this.makeIconRecord(strDbName, oneMsg.getIcon())) {
                bRet = false;
            } else if (!this.makeBehaviorRecord(strDbName, oneMsg.getBehavior())) {
                bRet = false;
            }
            if (!bRet) {
                this.deleteRecordFromAllTables(strDbName, oneMsg.getMessage().getStrMsgId());
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid parameter.");
            bRet = false;
        }
        return bRet;
    }

    /*
     * Unable to fully structure code
     */
    public void makeRecords(String strDbName, ArrayList<SN2MsgMdlAllData> addMsg) throws SN2MsgMdlException {
        alMsgIdx = new ArrayList<SN2MsgMdlMsgIdxData>();
        alMsg = new ArrayList<SN2MsgMdlMsgData>();
        alMsr = new ArrayList<SN2MsgMdlMsgData>();
        alIcn = new ArrayList<SN2MsgMdlMsgData>();
        alBhv = new ArrayList<SN2MsgMdlMsgData>();
        if (strDbName == null || addMsg == null || addMsg.size() == 0) ** GOTO lbl42
        mdlCmd = this.m_HashCmd.get(strDbName);
        if (mdlCmd != null) {
            iMsg = 0;
            while (iMsg < addMsg.size()) {
                oneMsg = addMsg.get(iMsg);
                if (this.isValidErrorCode(oneMsg.getMsgIdx().getStrMsgId())) {
                    alMsgIdx.add(oneMsg.getMsgIdx());
                    alMsg.add(oneMsg.getMessage());
                    alMsr.add(oneMsg.getMeasure());
                    alIcn.add(oneMsg.getIcon());
                    alBhv.add(oneMsg.getBehavior());
                } else {
                    SN2MsgLogger.getLogger().warning("Invalid message ID:" + oneMsg.getMsgIdx().getStrMsgId());
                }
                ++iMsg;
            }
            try {
                mdlCmd.getCtrlMsgIdx().makeRecords(alMsgIdx);
                mdlCmd.getCtrlMessage().makeRecords(alMsg);
                mdlCmd.getCtrlMeasure().makeRecords(alMsr);
                mdlCmd.getCtrlIcon().makeRecords(alIcn);
                mdlCmd.getCtrlBehavior().makeRecords(alBhv);
            }
            catch (SN2MsgMdlException mdlCtrlExp) {
                this.initAllTables(strDbName);
                SN2MsgLogger.getLogger().warning("Model Exception occurred.");
                throw mdlCtrlExp;
            }
        } else {
            msgExp = new SN2MsgMdlException("Invalid DB name:" + strDbName);
            SN2MsgLogger.getLogger().warning("Invalid DB name:" + strDbName);
            throw msgExp;
lbl42:
            // 1 sources

            msgExp = new SN2MsgMdlException("Invalid parameter:" + strDbName);
            SN2MsgLogger.getLogger().warning("Invalid parameter:" + strDbName);
            throw msgExp;
        }
    }

    /*
     * Unable to fully structure code
     */
    public ArrayList<SN2MsgMdlAllData> getAllMessage(String strDbName, boolean bRsv, String strRev) throws SN2MsgMdlException {
        alRet = new ArrayList<SN2MsgMdlAllData>();
        if (strDbName == null || strRev == null) ** GOTO lbl38
        mdlCmd = this.m_HashCmd.get(strDbName);
        if (mdlCmd != null) {
            alIdxList = mdlCmd.getCtrlMsgIdx().getMessageIdList(bRsv, strRev);
            SN2MsgLogger.getLogger().info("******Start read the DB:" + alIdxList.size());
            mapIdx = new HashMap<String, String>();
            iIdx = 0;
            while (iIdx < alIdxList.size()) {
                idxData = alIdxList.get(iIdx);
                mapIdx.put(idxData.getStrMsgId(), "");
                ++iIdx;
            }
            mapMsg = mdlCmd.getCtrlMessage().getRecords(mapIdx);
            mapMsr = mdlCmd.getCtrlMeasure().getRecords(mapIdx);
            mapIcn = mdlCmd.getCtrlIcon().getRecords(mapIdx);
            mapBhv = mdlCmd.getCtrlBehavior().getRecords(mapIdx);
            iRet = 0;
            while (iRet < alIdxList.size()) {
                retTmp = new SN2MsgMdlAllData();
                idxData = alIdxList.get(iRet);
                strId = idxData.getStrMsgId();
                retTmp.setMsgIdx(idxData);
                retTmp.setMessage(mapMsg.get(strId));
                retTmp.setMeasure(mapMsr.get(strId));
                retTmp.setIcon(mapIcn.get(strId));
                retTmp.setBehavior(mapBhv.get(strId));
                alRet.add(retTmp);
                ++iRet;
            }
        } else {
            SN2MsgLogger.getLogger().warning("Invalid DB name:" + strDbName);
            mdlExp = new SN2MsgMdlException("Invalid DB name:" + strDbName);
            mdlExp.setErrCode(-1);
            throw mdlExp;
lbl38:
            // 1 sources

            SN2MsgLogger.getLogger().warning("Invalid parameter:" + strDbName + " " + strRev);
            mdlExp = new SN2MsgMdlException("Invalid parameter:" + strDbName + " " + strRev);
            mdlExp.setErrCode(-1);
            throw mdlExp;
        }
        SN2MsgLogger.getLogger().info("******End read the DB:" + mapMsg.size());
        mapIdx.clear();
        mapMsg.clear();
        mapMsr.clear();
        mapIcn.clear();
        mapBhv.clear();
        return alRet;
    }

    public ArrayList<SN2MsgMdlMsgIdxData> getSpecifiedMessageIndex(String strDbName, String strId) throws SN2MsgMdlException {
        ArrayList<SN2MsgMdlMsgIdxData> alIdxList = null;
        if (strDbName != null && strId != null) {
            SN2MsgMdlCommand mdlCmd = this.m_HashCmd.get(strDbName);
            if (mdlCmd != null) {
                alIdxList = mdlCmd.getCtrlMsgIdx().getSpecifiedIdList(strId);
            } else {
                SN2MsgLogger.getLogger().warning("Invalid DB name:" + strDbName);
                SN2MsgMdlException mdlExp = new SN2MsgMdlException("Invalid DB name:" + strDbName);
                mdlExp.setErrCode(-1);
                throw mdlExp;
            }
        }
        return alIdxList;
    }
}

