/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.model.ctrl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.model.SN2MsgMdlException;
import sanproject.sn2msg.model.SN2MsgMdlMacro;
import sanproject.sn2msg.model.data.SN2MsgMdlMsgData;

public class SN2MsgMdlCtrlMessageTbl
implements SN2MsgMdlMacro {
    private Connection m_Conn = null;

    public SN2MsgMdlCtrlMessageTbl(Connection con) {
        this.m_Conn = con;
    }

    public String getTableName() {
        return "MESSAGE";
    }

    public boolean initTable() {
        boolean bRet;
        block13: {
            bRet = true;
            Statement stmt = null;
            try {
                try {
                    stmt = this.m_Conn.createStatement();
                    if (this.isTableExist()) {
                        stmt.execute("drop table " + this.getTableName());
                        SN2MsgLogger.getLogger().info(String.valueOf(this.getTableName()) + " was initialized.");
                    }
                    stmt.execute("create table " + this.getTableName() + " (" + " " + "MSG_ID" + " " + "VARCHAR(16)" + " , " + "HIE_EN" + " " + "LONG VARCHAR" + " , " + "HIE_JA" + " " + "LONG VARCHAR" + " , " + "HIJ_EN" + " " + "LONG VARCHAR" + " , " + "HIJ_JA" + " " + "LONG VARCHAR" + " , " + "HPE_EN" + " " + "LONG VARCHAR" + " , " + "HPE_JA" + " " + "LONG VARCHAR" + " , " + "HPJ_EN" + " " + "LONG VARCHAR" + " , " + "HPJ_JA" + " " + "LONG VARCHAR" + " , " + "PRIMARY KEY (" + "MSG_ID" + ")" + " )");
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().severe(jvExp.getMessage());
                    bRet = false;
                    if (stmt == null) break block13;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                    }
                }
            }
        }
        return bRet;
    }

    public boolean makeRecord(SN2MsgMdlMsgData msgData) {
        boolean bRet;
        block13: {
            bRet = true;
            Statement stmt = null;
            try {
                try {
                    if (msgData != null && !msgData.getStrMsgId().equals("")) {
                        stmt = this.m_Conn.createStatement();
                        stmt.execute("insert into " + this.getTableName() + " (" + " " + "MSG_ID" + " , " + "HIE_EN" + " , " + "HIE_JA" + " , " + "HIJ_EN" + " , " + "HIJ_JA" + " , " + "HPE_EN" + " , " + "HPE_JA" + " , " + "HPJ_EN" + " , " + "HPJ_JA" + " )" + " values (" + " '" + msgData.getStrMsgId() + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHie_en()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHie_ja()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHij_en()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHij_ja()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHpe_en()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHpe_ja()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHpj_en()) + "'" + " ," + " '" + this.addEscapeCode(msgData.getStrHpj_ja()) + "'" + ")");
                        break block13;
                    }
                    SN2MsgLogger.getLogger().warning("Invalid parameter.");
                    bRet = false;
                }
                catch (SQLException sqlExp) {
                    sqlExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                    SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                    bRet = false;
                    if (stmt == null) break block13;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp2) {
                        sqlExp2.printStackTrace();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                    }
                }
            }
        }
        return bRet;
    }

    public boolean isTableExist() {
        boolean bRet;
        block12: {
            bRet = true;
            Statement stmt = null;
            try {
                try {
                    stmt = this.m_Conn.createStatement();
                    ResultSet results = stmt.executeQuery("select * from " + this.getTableName());
                    results.close();
                }
                catch (SQLException sqlExp) {
                    bRet = false;
                    if (stmt == null) break block12;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp2) {
                        sqlExp2.printStackTrace();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                    }
                }
            }
        }
        return bRet;
    }

    public boolean deleteRecord(String strKey) {
        boolean bRet;
        block12: {
            bRet = true;
            Statement stmt = null;
            try {
                try {
                    SN2MsgLogger.getLogger().info("Delete record:" + strKey);
                    stmt = this.m_Conn.createStatement();
                    stmt.execute("delete from " + this.getTableName() + " where " + "MSG_ID" + " ='" + strKey + "'");
                }
                catch (SQLException sqlExp) {
                    sqlExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                    SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                    bRet = false;
                    if (stmt == null) break block12;
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp2) {
                        sqlExp2.printStackTrace();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                    }
                }
            }
        }
        return bRet;
    }

    public SN2MsgMdlMsgData getRecord(String strKey) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        SN2MsgMdlMsgData retData;
        block20: {
            retData = new SN2MsgMdlMsgData();
            Statement stmt = null;
            mdlExp = null;
            boolean iReqRev = false;
            try {
                stmt = this.m_Conn.createStatement();
                ResultSet results = stmt.executeQuery("select * from " + this.getTableName() + " where" + " " + "MSG_ID" + "='" + strKey + "'");
                while (results.next()) {
                    retData.setStrMsgId(results.getString("MSG_ID"));
                    retData.setStrHie_en(results.getString("HIE_EN"));
                    retData.setStrHie_ja(results.getString("HIE_JA"));
                    retData.setStrHij_en(results.getString("HIJ_EN"));
                    retData.setStrHij_ja(results.getString("HIJ_JA"));
                    retData.setStrHpe_en(results.getString("HPE_EN"));
                    retData.setStrHpe_ja(results.getString("HPE_JA"));
                    retData.setStrHpj_en(results.getString("HPJ_EN"));
                    retData.setStrHpj_ja(results.getString("HPJ_JA"));
                }
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                mdlExp = new SN2MsgMdlException();
                mdlExp.setErrCode(1);
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    break block20;
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                }
                break block20;
            }
            catch (Exception jvExp) {
                try {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    mdlExp = new SN2MsgMdlException();
                    mdlExp.setErrCode(2);
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception jvExp2) {
                        jvExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning(jvExp2.toString());
                    }
                }
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(jvExp.toString());
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
        return retData;
    }

    public HashMap<String, SN2MsgMdlMsgData> getRecords(HashMap<String, String> mapId) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        HashMap<String, SN2MsgMdlMsgData> mapRet;
        block20: {
            mapRet = new HashMap<String, SN2MsgMdlMsgData>();
            Statement stmt = null;
            mdlExp = null;
            boolean iReqRev = false;
            try {
                stmt = this.m_Conn.createStatement();
                ResultSet results = stmt.executeQuery("select * from " + this.getTableName() + " order by" + " " + "MSG_ID" + " asc");
                while (results.next()) {
                    String strGetKey = results.getString("MSG_ID");
                    if (mapId.get(strGetKey) == null) continue;
                    SN2MsgMdlMsgData retData = new SN2MsgMdlMsgData();
                    retData.setStrMsgId(strGetKey);
                    retData.setStrHie_en(results.getString("HIE_EN"));
                    retData.setStrHie_ja(results.getString("HIE_JA"));
                    retData.setStrHij_en(results.getString("HIJ_EN"));
                    retData.setStrHij_ja(results.getString("HIJ_JA"));
                    retData.setStrHpe_en(results.getString("HPE_EN"));
                    retData.setStrHpe_ja(results.getString("HPE_JA"));
                    retData.setStrHpj_en(results.getString("HPJ_EN"));
                    retData.setStrHpj_ja(results.getString("HPJ_JA"));
                    mapRet.put(strGetKey, retData);
                }
            }
            catch (SQLException sqlExp) {
                sqlExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                SN2MsgLogger.getLogger().warning(sqlExp.toString());
                mdlExp = new SN2MsgMdlException();
                mdlExp.setErrCode(1);
                try {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    break block20;
                }
                catch (Exception jvExp) {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                }
                break block20;
            }
            catch (Exception jvExp) {
                try {
                    jvExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(jvExp.toString());
                    mdlExp = new SN2MsgMdlException();
                    mdlExp.setErrCode(2);
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                            stmt = null;
                        }
                    }
                    catch (Exception jvExp2) {
                        jvExp2.printStackTrace();
                        SN2MsgLogger.getLogger().warning(jvExp2.toString());
                    }
                }
            }
            try {
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                SN2MsgLogger.getLogger().warning(jvExp.toString());
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
        return mapRet;
    }

    String getValueList(ArrayList<SN2MsgMdlMsgData> msgList) {
        StringBuffer strValue = new StringBuffer();
        int iList = 0;
        while (iList < msgList.size()) {
            SN2MsgMdlMsgData msgData = msgList.get(iList);
            if (iList != 0) {
                strValue.append(",");
            }
            strValue.append("(");
            strValue.append(" '" + msgData.getStrMsgId() + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHie_en()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHie_ja()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHij_en()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHij_ja()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHpe_en()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHpe_ja()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHpj_en()) + "'");
            strValue.append(" , '" + this.addEscapeCode(msgData.getStrHpj_ja()) + "'");
            strValue.append(")");
            ++iList;
        }
        return strValue.toString();
    }

    public void makeRecords(ArrayList<SN2MsgMdlMsgData> msgList) throws SN2MsgMdlException {
        SN2MsgMdlException mdlExp;
        block17: {
            mdlExp = null;
            Statement stmt = null;
            try {
                try {
                    if (msgList != null) {
                        stmt = this.m_Conn.createStatement();
                        stmt.execute("insert into " + this.getTableName() + " (" + " " + "MSG_ID" + " , " + "HIE_EN" + " , " + "HIE_JA" + " , " + "HIJ_EN" + " , " + "HIJ_JA" + " , " + "HPE_EN" + " , " + "HPE_JA" + " , " + "HPJ_EN" + " , " + "HPJ_JA" + " )" + " values " + this.getValueList(msgList));
                    } else {
                        SN2MsgLogger.getLogger().warning("Invalid parameter.");
                        mdlExp = new SN2MsgMdlException("Invalid parameter");
                        mdlExp.setErrCode(-1);
                    }
                }
                catch (SQLException sqlExp) {
                    sqlExp.printStackTrace();
                    SN2MsgLogger.getLogger().warning(sqlExp.getSQLState());
                    SN2MsgLogger.getLogger().warning(sqlExp.getMessage());
                    mdlExp = new SN2MsgMdlException("SQLException occured");
                    mdlExp.setErrCode(1);
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqlExp2) {
                            sqlExp2.printStackTrace();
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqlExp) {
                        sqlExp.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqlExp) {
                    sqlExp.printStackTrace();
                }
            }
        }
        if (mdlExp != null) {
            throw mdlExp;
        }
    }

    public String addEscapeCode(String strSrc) {
        return strSrc.replaceAll("'", "''");
    }
}

