/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import sample.XMLReader;
import sample.data.MsgIndex;
import sample.data.MsgIndexComparator;
import util.PropertiesChanger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeMessage {
    private static TYPE type = TYPE.NEW;
    private LinkedHashSet<HashMap<String, String>> messageSet = new LinkedHashSet();
    private LinkedHashSet<HashMap<String, String>> guidanceSet = new LinkedHashSet();
    private LinkedHashSet<HashMap<String, String>> oldGuidanceSet = new LinkedHashSet();
    private static boolean isHMMode = false;
    private static boolean isForcibleMode = false;
    private static final String IN_DIR_MSG = "master_msg" + File.separator;
    private static final String IN_DIR_GUIDANCE = "master_guid" + File.separator;
    private static final String OUT_DIR_MSG = "tmp" + File.separator;
    private static final String OUT_DIR_OLDMSG = "out_msgold" + File.separator;
    private static final String OUT_DIR_GUIDANCE = "out_guid" + File.separator;
    private static final String ERR_STR_INTERNALID_DUP = "\u81ea\u52d5\u751f\u6210\u3057\u305f\u5185\u90e8ID\u304c\u91cd\u8907\u3057\u307e\u3057\u305f\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7\u306e\u91cd\u8907\u304c\u7121\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u91cd\u8907\u306e\u7121\u3044\u5834\u5408\u306f\u5225\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044";
    private static final String DIR_REPLACE_DEF = "replacementDefine";
    private static final String DIR_NEW = "New-GUI(SN2)_File";
    private static final String DIR_OLD = "Old-GUI(SN)_File";
    private static HashMap<String, String> MEASURES_CSV_MAP = new HashMap();
    private static HashMap<String, String> MESSAGES_CSV_MAP = new HashMap();
    private static HashMap<String, String> BEHAVIOR_CSV_MAP = new HashMap();
    private static HashMap<String, String> ICONS_CSV_MAP = new HashMap();
    private static HashMap<String, String> GUIDLISTS_CSV_MAP = new HashMap();
    private static HashMap<String, String> MEASURES_PRO_MAP = new HashMap();
    private static HashMap<String, String> MESSAGES_PRO_MAP = new HashMap();
    private static HashMap<String, String> GUIDLISTS_CSV_OLD_MAP = new HashMap();
    private static HashMap<String, String> SERVERIMESSAGE_CSV_OLD_MAP = new HashMap();
    private static HashMap<String, String> CLIENTIMESSAGE_CSV_OLD_MAP = new HashMap();
    private static HashMap<String, String> REP_DEFINE_OLD_MAP = new HashMap();
    private static TreeSet<String> ignoreIdSet = new TreeSet();

    static {
        MEASURES_CSV_MAP.put("HIE_EN", "Measures_HIE_EN.csv");
        MEASURES_CSV_MAP.put("HIE_JA", "Measures_HIE_JA.csv");
        MEASURES_CSV_MAP.put("HIJ_EN", "Measures_HIJ_EN.csv");
        MEASURES_CSV_MAP.put("HIJ_JA", "Measures_HIJ_JA.csv");
        MEASURES_CSV_MAP.put("HPE_EN", "Measures_HPE_EN.csv");
        MEASURES_CSV_MAP.put("HPE_JA", "Measures_HPE_JA.csv");
        MEASURES_CSV_MAP.put("HPJ_EN", "Measures_HPJ_EN.csv");
        MEASURES_CSV_MAP.put("HPJ_JA", "Measures_HPJ_JA.csv");
        Collections.unmodifiableMap(MEASURES_CSV_MAP);
        MESSAGES_CSV_MAP.put("HIE_EN", "Message_HIE_EN.csv");
        MESSAGES_CSV_MAP.put("HIE_JA", "Message_HIE_JA.csv");
        MESSAGES_CSV_MAP.put("HIJ_EN", "Message_HIJ_EN.csv");
        MESSAGES_CSV_MAP.put("HIJ_JA", "Message_HIJ_JA.csv");
        MESSAGES_CSV_MAP.put("HPE_EN", "Message_HPE_EN.csv");
        MESSAGES_CSV_MAP.put("HPE_JA", "Message_HPE_JA.csv");
        MESSAGES_CSV_MAP.put("HPJ_EN", "Message_HPJ_EN.csv");
        MESSAGES_CSV_MAP.put("HPJ_JA", "Message_HPJ_JA.csv");
        Collections.unmodifiableMap(MESSAGES_CSV_MAP);
        BEHAVIOR_CSV_MAP.put("HIE_EN", "Behavior_HIE_EN.csv");
        BEHAVIOR_CSV_MAP.put("HIE_JA", "Behavior_HIE_JA.csv");
        BEHAVIOR_CSV_MAP.put("HIJ_EN", "Behavior_HIJ_EN.csv");
        BEHAVIOR_CSV_MAP.put("HIJ_JA", "Behavior_HIJ_JA.csv");
        BEHAVIOR_CSV_MAP.put("HPE_EN", "Behavior_HPE_EN.csv");
        BEHAVIOR_CSV_MAP.put("HPE_JA", "Behavior_HPE_JA.csv");
        BEHAVIOR_CSV_MAP.put("HPJ_EN", "Behavior_HPJ_EN.csv");
        BEHAVIOR_CSV_MAP.put("HPJ_JA", "Behavior_HPJ_JA.csv");
        Collections.unmodifiableMap(BEHAVIOR_CSV_MAP);
        ICONS_CSV_MAP.put("HIE_EN", "IconID_HIE_EN.csv");
        ICONS_CSV_MAP.put("HIE_JA", "IconID_HIE_JA.csv");
        ICONS_CSV_MAP.put("HIJ_EN", "IconID_HIJ_EN.csv");
        ICONS_CSV_MAP.put("HIJ_JA", "IconID_HIJ_JA.csv");
        ICONS_CSV_MAP.put("HPE_EN", "IconID_HPE_EN.csv");
        ICONS_CSV_MAP.put("HPE_JA", "IconID_HPE_JA.csv");
        ICONS_CSV_MAP.put("HPJ_EN", "IconID_HPJ_EN.csv");
        ICONS_CSV_MAP.put("HPJ_JA", "IconID_HPJ_JA.csv");
        Collections.unmodifiableMap(ICONS_CSV_MAP);
        GUIDLISTS_CSV_MAP.put("HIE_EN", "guidlist_HIE_EN.csv");
        GUIDLISTS_CSV_MAP.put("HIE_JA", "guidlist_HIE_JA.csv");
        GUIDLISTS_CSV_MAP.put("HIJ_EN", "guidlist_HIJ_EN.csv");
        GUIDLISTS_CSV_MAP.put("HIJ_JA", "guidlist_HIJ_JA.csv");
        GUIDLISTS_CSV_MAP.put("HPE_EN", "guidlist_HPE_EN.csv");
        GUIDLISTS_CSV_MAP.put("HPE_JA", "guidlist_HPE_JA.csv");
        GUIDLISTS_CSV_MAP.put("HPJ_EN", "guidlist_HPJ_EN.csv");
        GUIDLISTS_CSV_MAP.put("HPJ_JA", "guidlist_HPJ_JA.csv");
        Collections.unmodifiableMap(GUIDLISTS_CSV_MAP);
        MEASURES_PRO_MAP.put("HIE_EN", "Measures_HIE_EN.properties.original");
        MEASURES_PRO_MAP.put("HIE_JA", "Measures_HIE_JA.properties.original");
        MEASURES_PRO_MAP.put("HIJ_EN", "Measures_HIJ_EN.properties.original");
        MEASURES_PRO_MAP.put("HIJ_JA", "Measures_HIJ_JA.properties.original");
        MEASURES_PRO_MAP.put("HPE_EN", "Measures_HPE_EN.properties.original");
        MEASURES_PRO_MAP.put("HPE_JA", "Measures_HPE_JA.properties.original");
        MEASURES_PRO_MAP.put("HPJ_EN", "Measures_HPJ_EN.properties.original");
        MEASURES_PRO_MAP.put("HPJ_JA", "Measures_HPJ_JA.properties.original");
        Collections.unmodifiableMap(MEASURES_PRO_MAP);
        MESSAGES_PRO_MAP.put("HIE_EN", "Message_HIE_EN.properties.original");
        MESSAGES_PRO_MAP.put("HIE_JA", "Message_HIE_JA.properties.original");
        MESSAGES_PRO_MAP.put("HIJ_EN", "Message_HIJ_EN.properties.original");
        MESSAGES_PRO_MAP.put("HIJ_JA", "Message_HIJ_JA.properties.original");
        MESSAGES_PRO_MAP.put("HPE_EN", "Message_HPE_EN.properties.original");
        MESSAGES_PRO_MAP.put("HPE_JA", "Message_HPE_JA.properties.original");
        MESSAGES_PRO_MAP.put("HPJ_EN", "Message_HPJ_EN.properties.original");
        MESSAGES_PRO_MAP.put("HPJ_JA", "Message_HPJ_JA.properties.original");
        Collections.unmodifiableMap(MESSAGES_PRO_MAP);
        GUIDLISTS_CSV_OLD_MAP.put("HIE_EN", "guidlist_en.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HIE_JA", "guidlist_ja.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HIJ_EN", "guidlist_J_en.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HIJ_JA", "guidlist_J_ja.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HPE_EN", "guidlist_HP_en.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HPE_JA", "guidlist_HP_ja.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HPJ_EN", "guidlist_HPJ_en.csv");
        GUIDLISTS_CSV_OLD_MAP.put("HPJ_JA", "guidlist_HPJ_ja.csv");
        Collections.unmodifiableMap(GUIDLISTS_CSV_OLD_MAP);
        SERVERIMESSAGE_CSV_OLD_MAP.put("HIE_EN", "ServerIMessage_en.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HIE_JA", "ServerIMessage_ja.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HIJ_EN", "ServerIMessage_J_en.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HIJ_JA", "ServerIMessage_J_ja.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HPE_EN", "ServerIMessage_HP_en.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HPE_JA", "ServerIMessage_HP_ja.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HPJ_EN", "ServerIMessage_HPJ_en.csv");
        SERVERIMESSAGE_CSV_OLD_MAP.put("HPJ_JA", "ServerIMessage_HPJ_ja.csv");
        Collections.unmodifiableMap(SERVERIMESSAGE_CSV_OLD_MAP);
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HIE_EN", "ClientIMessage_en.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HIE_JA", "ClientIMessage_ja.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HIJ_EN", "ClientIMessage_J_en.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HIJ_JA", "ClientIMessage_J_ja.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HPE_EN", "ClientIMessage_HP_en.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HPE_JA", "ClientIMessage_HP_ja.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HPJ_EN", "ClientIMessage_HPJ_en.csv");
        CLIENTIMESSAGE_CSV_OLD_MAP.put("HPJ_JA", "ClientIMessage_HPJ_ja.csv");
        Collections.unmodifiableMap(CLIENTIMESSAGE_CSV_OLD_MAP);
        REP_DEFINE_OLD_MAP.put("HIE_EN", "replacement_HIE_EN.properties.original");
        REP_DEFINE_OLD_MAP.put("HIE_JA", "replacement_HIE_JA.properties.original");
        REP_DEFINE_OLD_MAP.put("HIJ_EN", "replacement_HIJ_EN.properties.original");
        REP_DEFINE_OLD_MAP.put("HIJ_JA", "replacement_HIJ_JA.properties.original");
        REP_DEFINE_OLD_MAP.put("HPE_EN", "replacement_HPE_EN.properties.original");
        REP_DEFINE_OLD_MAP.put("HPE_JA", "replacement_HPE_JA.properties.original");
        REP_DEFINE_OLD_MAP.put("HPJ_EN", "replacement_HPJ_EN.properties.original");
        REP_DEFINE_OLD_MAP.put("HPJ_JA", "replacement_HPJ_JA.properties.original");
        Collections.unmodifiableMap(REP_DEFINE_OLD_MAP);
    }

    private static void parseCommandLine(String[] args) {
        Options options = new Options();
        options.addOption("n", "new", false, DIR_NEW);
        options.addOption("o", "old", false, DIR_OLD);
        options.addOption("s", "supervisor", false, "Supervisor_New-GUI(SN2)_File");
        options.addOption("hm", "mode", false, "HM mode.");
        options.addOption("fm", "mode", false, "Force mode.");
        options.addOption("h", "help", false, "help.");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("MakeMessage", options, true);
            System.exit(1);
        }
        if (cmd.hasOption("o")) {
            type = TYPE.OLD;
        }
        if (cmd.hasOption("s")) {
            type = TYPE.SUPERVISOR;
        }
        if (cmd.hasOption("n")) {
            type = TYPE.NEW;
        }
        if (cmd.hasOption("hm")) {
            System.out.println("HM\u30e2\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
            isHMMode = true;
        }
        if (cmd.hasOption("fm")) {
            System.out.println("\u5f37\u5236\u30e2\u30fc\u30c9\u304c\u6307\u5b9a\u3055\u308c\u307e\u3057\u305f");
            isForcibleMode = true;
        }
    }

    public static void main(String[] args) {
        MakeMessage.parseCommandLine(args);
        switch (type) {
            case NEW: {
                MakeMessage.mainNew();
                break;
            }
            case OLD: {
                MakeMessage.mainOld();
                break;
            }
            case SUPERVISOR: {
                MakeMessage.mainSupervisor();
                break;
            }
            default: {
                System.err.println("Not found type : " + (Object)((Object)type));
            }
        }
    }

    private static void mainNew() {
        String[] csvFileStrs;
        MakeMessage m = new MakeMessage();
        m.messageSet = XMLReader.readXMLs(IN_DIR_MSG, "newMsg");
        m.guidanceSet = XMLReader.readXMLs(IN_DIR_GUIDANCE, "newGuidance");
        String[] stringArray = csvFileStrs = new String[]{"HIE_EN", "HIE_JA", "HIJ_EN", "HIJ_JA", "HPE_EN", "HPE_JA", "HPJ_EN", "HPJ_JA"};
        int n = csvFileStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            m.makeCSVMeasures(s);
            m.makeCSVBehavior(s);
            m.makeCSVMessages(s);
            m.makeCSVIcon(s);
            m.makeCSVGuidlist(s);
            m.makeServerIMessageCsvFromNewMessage(s);
            m.makeClientIMessageCsvFromNewMessage(s);
            m.makeProReplacementDefine(s);
            ++n2;
        }
        m.makeMsgIndexFromNewMessage();
        for (String s : ignoreIdSet) {
            System.err.println("    Temporary ID  ... " + s);
        }
    }

    private static void mainSupervisor() {
        String[] csvFileStrs;
        MakeMessage m = new MakeMessage();
        m.messageSet = XMLReader.readXMLs("", "supervisorMsg");
        String[] stringArray = csvFileStrs = new String[]{"HIE_EN", "HIE_JA", "HIJ_EN", "HIJ_JA", "HPE_EN", "HPE_JA", "HPJ_EN", "HPJ_JA"};
        int n = csvFileStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            m.makeCSVMeasures(s);
            m.makeCSVBehavior(s);
            m.makeCSVMessages(s);
            m.makeCSVIcon(s);
            m.makeProMeasures(s);
            m.makeProMessages(s);
            m.makeProReplacementDefine(s);
            ++n2;
        }
        for (String s : ignoreIdSet) {
            System.err.println("    Temporary ID  ... " + s);
        }
    }

    private static void mainOld() {
        String[] csvFileStrs;
        MakeMessage m = new MakeMessage();
        m.oldGuidanceSet = XMLReader.readGuidanceXML(String.valueOf(IN_DIR_GUIDANCE) + File.separator + "oldGuidance.xml");
        String[] stringArray = csvFileStrs = new String[]{"HIE_EN", "HIE_JA", "HIJ_EN", "HIJ_JA", "HPE_EN", "HPE_JA", "HPJ_EN", "HPJ_JA"};
        int n = csvFileStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            m.makeCSVGuidlistOld(s);
            m.makeProReplacementDefine(s);
            ++n2;
        }
        for (String s : ignoreIdSet) {
            System.err.println("    Temporary ID  ... " + s);
        }
    }

    public void makeCSVMeasures(String type) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (HashMap hashMap : this.messageSet) {
            int kisyuId;
            String MSG;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID");
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String MSG_ORG = (String)hashMap.get(String.valueOf(type) + "_ACTION");
            if (MakeMessage.ignoreLine(KISYUID, FID_MID, ID) || (MSG = this.getStringFromMode(kisyuId = NumberUtils.toInt(KISYUID, -1), MSG_ORG)) == null) continue;
            String value = String.valueOf(FID_MID) + "/" + ID + "\t" + MSG;
            sets.add(value);
        }
        try {
            ArrayList arrayList = new ArrayList(sets);
            Collections.sort(arrayList);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_MSG) + MEASURES_CSV_MAP.get(type)), arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(2);
        }
    }

    public void makeMsgIndexFromNewMessage() {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        HashSet<MsgIndex> sets2 = new HashSet<MsgIndex>();
        HashMap<String, String> chkMap = new HashMap<String, String>();
        for (HashMap hashMap : this.messageSet) {
            String strChk;
            String FILETYPE;
            int iFuncId;
            String ID;
            String KISYUID;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty() || !this.isValidMode(KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID"))) continue;
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String BUICODE = FID_MID.replace("/", "");
            String ERRORCODE = ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String strInternalId = new String(String.valueOf(FID_MID) + "/" + ID);
            String BUNRUI = MakeMessage.getValueFromMap(hashMap, "BUNRUI");
            if (MakeMessage.ignoreLine(BUICODE, ERRORCODE) || -1 == (iFuncId = NumberUtils.toInt(BUICODE, -1)) || (FILETYPE = this.getFileType(FID_MID)).isEmpty()) continue;
            if (BUNRUI.isEmpty()) {
                BUNRUI = "6000";
            }
            if (chkMap.containsKey(strChk = String.valueOf(strInternalId.hashCode()))) {
                String strRelStr = (String)chkMap.get(strChk);
                System.err.println("\u81ea\u52d5\u751f\u6210\u3057\u305f\u5185\u90e8ID\u304c\u91cd\u8907\u3057\u307e\u3057\u305f\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7\u306e\u91cd\u8907\u304c\u7121\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u91cd\u8907\u306e\u7121\u3044\u5834\u5408\u306f\u5225\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044:" + strRelStr + ", " + strInternalId);
                System.exit(2);
            } else {
                chkMap.put(strChk, strInternalId);
            }
            String value = String.valueOf(iFuncId) + "\t" + ERRORCODE + "\t" + FILETYPE + "\t" + strInternalId.hashCode() + "\t" + BUNRUI;
            sets.add(value);
            MsgIndex v = new MsgIndex(String.valueOf(iFuncId), ERRORCODE, FILETYPE, Integer.toString(strInternalId.hashCode()), BUNRUI);
            sets2.add(v);
        }
        try {
            ArrayList arrayList = new ArrayList(sets);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_OLDMSG) + "MsgIndex.csv"), arrayList);
            ArrayList mis = new ArrayList(sets2);
            Collections.sort(mis, new MsgIndexComparator());
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_OLDMSG) + "MsgIndex.csv"), mis);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(2);
        }
    }

    public void makeServerIMessageCsvFromNewMessage(String type) {
        this.makeOldGuiIMessageCsvFromNewMessage(type, "0", SERVERIMESSAGE_CSV_OLD_MAP);
    }

    private void makeClientIMessageCsvFromNewMessage(String type) {
        this.makeOldGuiIMessageCsvFromNewMessage(type, "1", CLIENTIMESSAGE_CSV_OLD_MAP);
    }

    private void makeOldGuiIMessageCsvFromNewMessage(String type, String chkString, HashMap<String, String> hashFile) {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        HashMap<String, String> chkMap = new HashMap<String, String>();
        for (HashMap hashMap : this.messageSet) {
            String KISHU;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty() || !this.isValidMode(KISHU = MakeMessage.getValueFromMap(hashMap, "KISYUID"))) continue;
            int kisyuId = NumberUtils.toInt(KISHU, -1);
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String strIdChk = FID_MID.replace("/", "");
            if (-1 == NumberUtils.toInt(strIdChk, -1)) continue;
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String S_ICONID = this.convertICONtoICONID(MakeMessage.getValueFromMap(hashMap, "ICONID"));
            String strInternalId = new String(String.valueOf(FID_MID) + "/" + ID);
            int INTERNALID = strInternalId.hashCode();
            String strChk = String.valueOf(INTERNALID);
            if (chkMap.containsKey(strChk)) {
                String strRelStr = (String)chkMap.get(strChk);
                System.err.println("\u81ea\u52d5\u751f\u6210\u3057\u305f\u5185\u90e8ID\u304c\u91cd\u8907\u3057\u307e\u3057\u305f\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7\u306e\u91cd\u8907\u304c\u7121\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u91cd\u8907\u306e\u7121\u3044\u5834\u5408\u306f\u5225\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7\u306b\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044\uff1a" + strRelStr + ", " + strInternalId);
                System.exit(2);
            } else {
                chkMap.put(strChk, strInternalId);
            }
            String S_LEVEL = MakeMessage.getValueFromMap(hashMap, "LEVEL_OLD");
            if (S_LEVEL.isEmpty()) {
                S_LEVEL = MakeMessage.getValueFromMap(hashMap, "VIEW");
            }
            String MSG_ORG = MakeMessage.getValueFromMap(hashMap, type);
            String ACTION_ORG = MakeMessage.getValueFromMap(hashMap, String.valueOf(type) + "_ACTION");
            String FILETYPE = this.getFileType(FID_MID);
            if (MakeMessage.ignoreLine(FID_MID, ID, S_ICONID, S_LEVEL) || !chkString.equals(FILETYPE)) continue;
            String strMsg = this.getStringFromMode(kisyuId, MSG_ORG);
            String strAct = this.getStringFromMode(kisyuId, ACTION_ORG);
            String MSG = "";
            if (strMsg == null) continue;
            MSG = strAct != null && !strAct.isEmpty() ? ("1".equals(FILETYPE) ? strMsg : String.valueOf(strMsg) + "\\\\n" + strAct) : strMsg;
            String value = String.valueOf(INTERNALID) + "\t" + S_ICONID + "\t" + S_LEVEL + "\t" + MSG;
            map.put(INTERNALID, value);
        }
        try {
            ArrayList arrayList = new ArrayList(map.values());
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_OLDMSG) + hashFile.get(type)), arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(2);
        }
    }

    private String getInternalIdInForceMode(String strOrigin) {
        return "0" + strOrigin;
    }

    public void makeCSVMessages(String type) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (HashMap hashMap : this.messageSet) {
            int kisyuId;
            String MSG;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID");
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String MSG_ORG = (String)hashMap.get(type);
            if (MakeMessage.ignoreLine(KISYUID, FID_MID, ID) || (MSG = this.getStringFromMode(kisyuId = NumberUtils.toInt(KISYUID, -1), MSG_ORG)) == null) continue;
            String value = String.valueOf(FID_MID) + "/" + ID + "\t" + MSG;
            sets.add(value);
        }
        try {
            ArrayList lines = new ArrayList(sets);
            Collections.sort(lines);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_MSG) + MESSAGES_CSV_MAP.get(type)), lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static boolean ignoreLine(String ... args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str == null || str.isEmpty() || str.startsWith("#")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void makeCSVBehavior(String type) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (HashMap hashMap : this.messageSet) {
            int kisyuId;
            String MSG;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID");
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String VIEW = MakeMessage.getValueFromMap(hashMap, "VIEW");
            if (MakeMessage.ignoreLine(KISYUID, FID_MID, ID) || (MSG = this.getStringFromMode(kisyuId = NumberUtils.toInt(KISYUID, -1), VIEW)) == null) continue;
            String value = String.valueOf(FID_MID) + "/" + ID + "\t" + MSG;
            sets.add(value);
        }
        try {
            ArrayList lines = new ArrayList(sets);
            Collections.sort(lines);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_MSG) + BEHAVIOR_CSV_MAP.get(type)), lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    private static String getValueFromMap(HashMap map, String key) {
        String value = (String)map.get(key);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void makeCSVIcon(String type) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (HashMap hashMap : this.messageSet) {
            int kisyuId;
            String MSG;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID");
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String ICON = MakeMessage.getValueFromMap(hashMap, "ICONID");
            if (MakeMessage.ignoreLine(KISYUID, FID_MID, ID) || (MSG = this.getStringFromMode(kisyuId = NumberUtils.toInt(KISYUID, -1), ICON)) == null) continue;
            String value = String.valueOf(FID_MID) + "/" + ID + "\t" + MSG;
            sets.add(value);
        }
        try {
            ArrayList lines = new ArrayList(sets);
            Collections.sort(lines);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_MSG) + ICONS_CSV_MAP.get(type)), lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void makeCSVGuidlist(String type) {
        LinkedHashMap<String, String> maps = new LinkedHashMap<String, String>();
        for (HashMap hashMap : this.guidanceSet) {
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String DISPLAY_ID = MakeMessage.getValueFromMap(hashMap, "DISPLAY_ID");
            String PART_ID = MakeMessage.getValueFromMap(hashMap, "PART_ID");
            String GUIDE = MakeMessage.getValueFromMap(hashMap, type);
            if (MakeMessage.ignoreLine(DISPLAY_ID, PART_ID)) continue;
            if (DISPLAY_ID.startsWith("#")) {
                System.err.println("    Temporary ID  ... " + DISPLAY_ID + "/" + PART_ID);
                continue;
            }
            GUIDE = GUIDE.replace("\n", "");
            String key = String.valueOf(DISPLAY_ID) + "/" + PART_ID;
            String value = "";
            value = String.valueOf(DISPLAY_ID) + "/" + PART_ID + "\t" + GUIDE;
            if (maps.get(key) != null) continue;
            maps.put(key, value);
        }
        try {
            ArrayList lines = new ArrayList(maps.values());
            Collections.sort(lines);
            lines.add(0, "");
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_GUIDANCE) + GUIDLISTS_CSV_MAP.get(type)), lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void makeCSVGuidlistOld(String type) {
        ArrayList<String> lines = new ArrayList<String>();
        for (HashMap hashMap : this.oldGuidanceSet) {
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String FUNCTION = MakeMessage.getValueFromMap(hashMap, "FUNCTION");
            String TAG = MakeMessage.getValueFromMap(hashMap, "TAG");
            String MSG = MakeMessage.getValueFromMap(hashMap, type);
            String COLOR = MakeMessage.getValueFromMap(hashMap, String.valueOf(type.substring(0, 3)) + "_COLOR");
            if (FUNCTION == null || TAG == null || FUNCTION.equals("\u6a5f\u80fd")) continue;
            if (FUNCTION.startsWith("#")) {
                System.err.println("    Temporary ID  ... " + FUNCTION + "/" + TAG);
                continue;
            }
            String key = String.valueOf(FUNCTION) + "/" + TAG;
            String value = String.valueOf(FUNCTION) + "\t" + TAG + "\t" + MSG + "\t" + COLOR;
            lines.add(value);
        }
        try {
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_GUIDANCE) + GUIDLISTS_CSV_OLD_MAP.get(type)), lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public void makeProReplacementDefine(String strOem) {
        String strSrcDir = DIR_REPLACE_DEF;
        switch (type) {
            case OLD: {
                strSrcDir = ".." + File.separator + DIR_NEW + File.separator + DIR_REPLACE_DEF;
            }
        }
        String strValue = String.valueOf(strSrcDir) + File.separator + REP_DEFINE_OLD_MAP.get(strOem);
        PropertiesChanger propChg = new PropertiesChanger(new File(strValue));
        if (!propChg.makeProperties()) {
            System.out.println("Replacement defined file failed:" + strValue);
            System.exit(2);
        }
    }

    public void makeProMeasures(String type) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (HashMap hashMap : this.messageSet) {
            int kisyuId;
            String MSG;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID");
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String MSG_ORG = (String)hashMap.get(String.valueOf(type) + "_ACTION");
            if (MakeMessage.ignoreLine(KISYUID, FID_MID, ID) || (MSG = this.getStringFromMode(kisyuId = NumberUtils.toInt(KISYUID, -1), MSG_ORG)) == null) continue;
            String value = String.valueOf(FID_MID.replace("/", "")) + "-" + ID + "=" + MSG;
            sets.add(value);
        }
        try {
            ArrayList arrayList = new ArrayList(sets);
            Collections.sort(arrayList);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_MSG) + MEASURES_PRO_MAP.get(type)), arrayList);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(2);
        }
    }

    public void makeProMessages(String type) {
        LinkedHashSet<String> sets = new LinkedHashSet<String>();
        for (HashMap hashMap : this.messageSet) {
            int kisyuId;
            String MSG;
            String RESERVED = MakeMessage.getValueFromMap(hashMap, "RESERVED");
            if (!RESERVED.isEmpty()) continue;
            String KISYUID = MakeMessage.getValueFromMap(hashMap, "KISYUID");
            String FID_MID = MakeMessage.getValueFromMap(hashMap, "FID_MID");
            String ID = MakeMessage.getValueFromMap(hashMap, "ID");
            String MSG_ORG = (String)hashMap.get(type);
            if (MakeMessage.ignoreLine(KISYUID, FID_MID, ID) || (MSG = this.getStringFromMode(kisyuId = NumberUtils.toInt(KISYUID, -1), MSG_ORG)) == null) continue;
            String value = String.valueOf(FID_MID.replace("/", "")) + "-" + ID + "=" + MSG;
            sets.add(value);
        }
        try {
            ArrayList lines = new ArrayList(sets);
            Collections.sort(lines);
            FileUtils.writeLines(new File(String.valueOf(OUT_DIR_MSG) + MESSAGES_PRO_MAP.get(type)), lines);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    private String convertICONtoICONID(String str) {
        if ("WARNING".equals(str)) {
            return "5";
        }
        if ("INFORMATION".equals(str)) {
            return "3";
        }
        if ("ERROR".equals(str)) {
            return "1";
        }
        return "";
    }

    String getFileType(String strBase) {
        String strRet = "";
        String strTmp = strBase.replaceAll("/", "");
        int iFuncId = NumberUtils.toInt(strTmp, -1);
        if (-1 != iFuncId) {
            int iModId = iFuncId % 100;
            if (10 == iModId) {
                strRet = "1";
            } else if (20 == iModId) {
                strRet = "0";
            } else if (iModId > 0 && iModId < 10) {
                strRet = "0";
            }
        }
        return strRet;
    }

    boolean isValidMode(String strMode) {
        boolean bRet = true;
        int kisyuId = NumberUtils.toInt(strMode, -1);
        switch (kisyuId) {
            case 0: {
                bRet = true;
                break;
            }
            case 1: {
                if (isHMMode) {
                    bRet = false;
                    break;
                }
                bRet = true;
                break;
            }
            case 2: {
                if (isHMMode) {
                    bRet = true;
                    break;
                }
                bRet = false;
                break;
            }
            default: {
                System.err.println("KisyuId invalid : " + strMode);
                bRet = false;
            }
        }
        return bRet;
    }

    String getStringFromMode(int iKishuId, String strMsg) {
        String strRet = "";
        switch (iKishuId) {
            case 0: {
                strRet = strMsg;
                break;
            }
            case 1: {
                if (isHMMode) {
                    strRet = null;
                    break;
                }
                strRet = strMsg;
                break;
            }
            case 2: {
                if (isHMMode) {
                    strRet = strMsg;
                    break;
                }
                strRet = null;
                break;
            }
            default: {
                System.err.println("KisyuId invalid : " + iKishuId);
                strRet = null;
            }
        }
        return strRet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TYPE {
        NEW,
        OLD,
        SUPERVISOR;

    }
}

