/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2msg.controller.makecsv;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import sanproject.sn2msg.SN2MsgLogger;
import sanproject.sn2msg.controller.SN2MsgCtrlException;
import sanproject.sn2msg.controller.SN2MsgCtrlMacro;
import sanproject.sn2msg.controller.makecsv.SN2MsgCtrlMakecsvBehavior;
import sanproject.sn2msg.controller.makecsv.SN2MsgCtrlMakecsvIcon;
import sanproject.sn2msg.controller.makecsv.SN2MsgCtrlMakecsvMeasure;
import sanproject.sn2msg.controller.makecsv.SN2MsgCtrlMakecsvMessage;
import sanproject.sn2msg.model.data.SN2MsgMdlAllData;

public class SN2MsgCtrlMakecsvMain
implements SN2MsgCtrlMacro {
    private String m_StrCsvPath = "";
    private boolean m_BRsv = false;
    private ArrayList<SN2MsgMdlAllData> m_AlMsgList = null;

    public SN2MsgCtrlMakecsvMain(String strPath, ArrayList<SN2MsgMdlAllData> alMsg, boolean bRsv) throws SN2MsgCtrlException {
        SN2MsgCtrlException ctrlExp = null;
        if (strPath != null && alMsg != null) {
            if (!SN2MsgCtrlMakecsvMain.isValidPath(strPath)) {
                SN2MsgLogger.getLogger().severe("Parameter error(path):" + strPath);
                ctrlExp = new SN2MsgCtrlException();
                ctrlExp.setIErrorCode(4);
                throw ctrlExp;
            }
        } else {
            SN2MsgLogger.getLogger().severe("Parameter error(null).");
            ctrlExp = new SN2MsgCtrlException();
            ctrlExp.setIErrorCode(3);
            throw ctrlExp;
        }
        this.m_StrCsvPath = strPath;
        this.m_AlMsgList = alMsg;
        this.m_BRsv = bRsv;
    }

    static boolean isValidPath(String strPath) {
        boolean bRet = true;
        try {
            if (strPath != null) {
                File tmpFile = new File(strPath);
                bRet = tmpFile.exists();
                if (!bRet) {
                    SN2MsgLogger.getLogger().warning("Invalid file path:" + strPath);
                }
            } else {
                SN2MsgLogger.getLogger().warning("Invalid file path(null).");
                bRet = false;
            }
        }
        catch (Exception jvExp) {
            jvExp.printStackTrace();
            SN2MsgLogger.getLogger().warning(jvExp.toString());
            bRet = false;
        }
        return bRet;
    }

    public void makeCSV() throws SN2MsgCtrlException {
        if (this.m_AlMsgList != null) {
            int iChg = 0;
            while (iChg < this.m_AlMsgList.size()) {
                SN2MsgMdlAllData allData = this.m_AlMsgList.get(iChg);
                allData.resetCsvErrorCode();
                ++iChg;
            }
            Collections.sort(this.m_AlMsgList);
            SN2MsgCtrlMakecsvMessage csvMessage = new SN2MsgCtrlMakecsvMessage(this.m_StrCsvPath, this.m_AlMsgList, this.m_BRsv);
            csvMessage.makeCSV();
            SN2MsgCtrlMakecsvMeasure csvMeasure = new SN2MsgCtrlMakecsvMeasure(this.m_StrCsvPath, this.m_AlMsgList, this.m_BRsv);
            csvMeasure.makeCSV();
            SN2MsgCtrlMakecsvIcon csvIcon = new SN2MsgCtrlMakecsvIcon(this.m_StrCsvPath, this.m_AlMsgList, this.m_BRsv);
            csvIcon.makeCSV();
            SN2MsgCtrlMakecsvBehavior csvBehavior = new SN2MsgCtrlMakecsvBehavior(this.m_StrCsvPath, this.m_AlMsgList, this.m_BRsv);
            csvBehavior.makeCSV();
        }
    }
}

