/*
 * Decompiled with CFR 0.152.
 */
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SnSpellChecker
implements SpellCheckListener {
    private static TYPE type = TYPE.MSG;
    private static final String DICT_BASE = ".0";
    private static String dictFile = "dict/english.tmp";
    private SpellChecker spellCheck = null;
    private String m_key = null;
    private String m_Tag = null;
    private boolean isError = false;
    private static String m_MasterMsg = "master_msg";
    private static String m_MasterGuid = "master_guid";
    static final String ERR_STR_INVALID_FORMAT = "[Error]\u30d5\u30a1\u30a4\u30eb\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u4e0d\u6b63\u3067\u3059\u3002\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3059\u3002\u30de\u30b9\u30bf\u30fc\u30d5\u30a1\u30a4\u30eb\u3092Excel\u3067\u518d\u4fdd\u5b58\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u3053\u306e\u3068\u304d\u201d\u30d5\u30a1\u30a4\u30eb\u306e\u7a2e\u985e\u201d[XML\u30c7\u30fc\u30bf(*.xml)]\u3092\u6307\u5b9a\u3057\u3066\u3044\u308b\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002\uff1a";
    static final String ROOT_EXL2003_SPD = "Workbook";
    private static Properties _r_hie_en = new Properties();
    private static Properties _r_hie_ja = new Properties();
    private static Properties _r_hij_en = new Properties();
    private static Properties _r_hij_ja = new Properties();
    private static Properties _r_hpe_en = new Properties();
    private static Properties _r_hpe_ja = new Properties();
    private static Properties _r_hpj_en = new Properties();
    private static Properties _r_hpj_ja = new Properties();
    private static TreeMap<String, Properties> proHashSet = new TreeMap();
    private static boolean isHm = false;
    private static String rootDirectory = "";
    private Properties configuration = new Properties();
    private static String _prefix = "newMsg";
    private static String _prefix_guid = "newGuidance";
    private static String _header = "\u6a5f\u80fd\u756a\u53f7/\u30e2\u30b8\u30e5\u30fc\u30eb\u756a\u53f7/\u30e1\u30c3\u30bb\u30fc\u30b8\u756a\u53f7";
    private static String _def_dir = "replacementDefine";
    private static Set<String> spellList = new LinkedHashSet<String>();
    private static Set<String> idSet = new HashSet<String>();
    private static Set<String> dupIdList = new LinkedHashSet<String>();
    private static Set<String> machineCharacterList = new LinkedHashSet<String>();
    private static Set<String> zenkakuIdList = new LinkedHashSet<String>();
    private static Set<String> kaigyouIdList = new LinkedHashSet<String>();
    private static List<String> replacementList = new ArrayList<String>();

    public SnSpellChecker() {
        this.initProperties();
        this.makeDictionary();
    }

    public SnSpellChecker(TARGETTYPE targetType) {
        this.initProperties();
        this.makeDictionary();
        try {
            FileInputStream inputStream = new FileInputStream(new File("checkJapanese.properties"));
            InputStreamReader isr = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            this.configuration.load(isr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        if (type == TYPE.PROPERTIES) {
            List suggestions = event.getSuggestions();
            System.out.println("MISSPELT WORD: " + event.getInvalidWord());
            Iterator suggestedWord = suggestions.iterator();
            while (suggestedWord.hasNext()) {
                this.isError = true;
                System.out.println("\tSuggested Word: " + suggestedWord.next());
            }
            if (suggestions.size() < 1) {
                System.out.println("\tNo suggestions");
            }
            return;
        }
        if (!this.isError) {
            System.out.println("\u2605\u2605\u2605" + _header + " \u30b9\u30da\u30eb\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
        }
        spellList.add(this.m_key);
        this.isError = true;
        List suggestions = event.getSuggestions();
        System.out.println(_header + " : " + this.m_key + " [" + this.m_Tag + "]");
        System.out.println("MISSPELT WORD: " + event.getInvalidWord());
        Iterator suggestedWord = suggestions.iterator();
        while (suggestedWord.hasNext()) {
            System.out.println("\tSuggested Word: " + suggestedWord.next());
        }
        if (suggestions.size() < 1) {
            System.out.println("\tNo suggestions");
        }
        System.out.flush();
    }

    public static void main(String[] args) throws Exception {
        SnSpellChecker.parseCommandLine(args);
        SnSpellChecker snSpellChk = new SnSpellChecker();
        switch (type) {
            case MSG: {
                snSpellChk.checkMessage();
                break;
            }
            case GUID: 
            case GUIDOLD: {
                snSpellChk.checkGuidance();
                break;
            }
            case PROPERTIES: {
                snSpellChk.checkProperties();
                if (snSpellChk.isError) {
                    System.exit(1);
                } else {
                    System.exit(0);
                }
                return;
            }
        }
        snSpellChk.checkReplaceDefine();
    }

    private static void parseCommandLine(String[] args) {
        Options options = new Options();
        options.addOption("g", "guid", false, "guid");
        options.addOption("og", "guidold", false, "guidold");
        options.addOption("h", "help", false, "help.");
        options.addOption("hm", "HM", false, "HM");
        options.addOption("p", "properties", true, "directory");
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("SpellCheckExample3", options, true);
            System.exit(1);
        }
        if (cmd.hasOption("g")) {
            type = TYPE.GUID;
            _header = "\u753b\u9762ID/\u90e8\u54c1ID";
        }
        if (cmd.hasOption("og")) {
            type = TYPE.GUIDOLD;
            _prefix_guid = "oldGuidance";
            _def_dir = ".." + File.separator + "New-GUI(SN2)_File" + File.separator + "replacementDefine";
            dictFile = ".." + File.separator + "New-GUI(SN2)_File" + File.separator + "dict" + File.separator + "english.tmp";
            _header = "\u6a5f\u80fd/\u30bf\u30b0";
        }
        if (cmd.hasOption("hm")) {
            isHm = true;
        }
        if (_prefix.isEmpty()) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("SpellCheckExample3", options, true);
            System.exit(1);
        }
        if (cmd.hasOption("p")) {
            rootDirectory = cmd.getOptionValue("p");
            type = TYPE.PROPERTIES;
            if (!new File(rootDirectory).exists()) {
                System.out.println("Not found directory : " + rootDirectory);
                System.exit(1);
            }
        }
    }

    void initProperties() {
        try {
            _r_hie_en.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HIE_EN.properties"))));
            _r_hie_ja.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HIE_JA.properties"))));
            _r_hij_en.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HIJ_EN.properties"))));
            _r_hij_ja.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HIJ_JA.properties"))));
            _r_hpe_en.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HPE_EN.properties"))));
            _r_hpe_ja.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HPE_JA.properties"))));
            _r_hpj_en.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HPJ_EN.properties"))));
            _r_hpj_ja.load(new InputStreamReader(new FileInputStream(new File(String.valueOf(_def_dir) + File.separator + "replacement_HPJ_JA.properties"))));
            proHashSet.put("HIE_EN", _r_hie_en);
            proHashSet.put("HIE_JA", _r_hie_ja);
            proHashSet.put("HIJ_EN", _r_hij_en);
            proHashSet.put("HIJ_JA", _r_hij_ja);
            proHashSet.put("HPE_EN", _r_hpe_en);
            proHashSet.put("HPE_JA", _r_hpe_ja);
            proHashSet.put("HPJ_EN", _r_hpj_en);
            proHashSet.put("HPJ_JA", _r_hpj_ja);
            proHashSet.put("HIE_EN_ACTION", _r_hie_en);
            proHashSet.put("HIE_JA_ACTION", _r_hie_ja);
            proHashSet.put("HIJ_EN_ACTION", _r_hij_en);
            proHashSet.put("HIJ_JA_ACTION", _r_hij_ja);
            proHashSet.put("HPE_EN_ACTION", _r_hpe_en);
            proHashSet.put("HPE_JA_ACTION", _r_hpe_ja);
            proHashSet.put("HPJ_EN_ACTION", _r_hpj_en);
            proHashSet.put("HPJ_JA_ACTION", _r_hpj_ja);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("SpellChecker\uff1a\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002MM.bat\u3092\u5b9f\u884c\u3057\u3066\u304b\u3089\u518d\u5b9f\u884c\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            System.exit(1);
        }
    }

    private void checkMessageA(String fileStr, String[] TAGS) throws Exception {
        try {
            SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(new File(dictFile), null);
            this.spellCheck = new SpellChecker(dictionary);
            this.spellCheck.addSpellCheckListener(this);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File f = new File(fileStr);
            Document doc = builder.parse(f);
            Element root = doc.getDocumentElement();
            if (root.getNodeName().equals(ROOT_EXL2003_SPD)) {
                System.out.println(ERR_STR_INVALID_FORMAT + fileStr);
                System.exit(1);
            }
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                boolean bRsv = false;
                Node child = children.item(i);
                if (child instanceof Element) {
                    Element childElement = (Element)child;
                    NodeList e = childElement.getChildNodes();
                    int j = 0;
                    while (j < e.getLength()) {
                        Node n = e.item(j);
                        if (n instanceof Element) {
                            String text;
                            String tag = ((Element)n).getTagName();
                            if (this.isReservedElement(tag, text = n.getTextContent())) {
                                bRsv = true;
                                break;
                            }
                            if (this.isInvalidOemElement(tag, text)) {
                                bRsv = true;
                                break;
                            }
                            if ("FID_MID".equals(tag) || "ERRORCODE".equals(tag)) {
                                this.m_key = text;
                            }
                            if ("ID".equals(tag) || "BUICODE".equals(tag)) {
                                this.m_key = String.valueOf(this.m_key) + "/" + text;
                            }
                            this.m_Tag = tag;
                            this.checkElementText(this.m_key, TAGS, tag, text);
                        }
                        ++j;
                    }
                    if (!bRsv) {
                        if (idSet.contains(this.m_key) && !this.m_key.contains("#")) {
                            dupIdList.add(this.m_key);
                        }
                        idSet.add(this.m_key);
                    } else {
                        bRsv = false;
                    }
                }
                ++i;
            }
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private String checkReplacementString(String tag, String str) {
        StringBuilder strRet = new StringBuilder();
        Properties prop = proHashSet.get(tag);
        if (prop == null || prop.isEmpty() || str.isEmpty()) {
            return "";
        }
        block2: for (Map.Entry<Object, Object> e : prop.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (" ".equals(value)) continue;
            try {
                int iCnt = 0;
                int iIndex = 0;
                while (iCnt < 10) {
                    boolean bFind = false;
                    if (-1 == (iIndex = str.indexOf(value, iIndex))) continue block2;
                    if (StringUtils.isAsciiPrintable((String)value)) {
                        int iValueLen = value.length();
                        String strBefore = "";
                        String strAfter = "";
                        if (iIndex != 0) {
                            strBefore = str.substring(iIndex - 1, iIndex);
                        }
                        if (!strBefore.matches("[a-z]") && !strBefore.matches("[A-Z]")) {
                            if (str.length() >= iIndex + iValueLen + 1) {
                                strAfter = str.substring(iIndex + iValueLen, iIndex + iValueLen + 1);
                                if (!strAfter.matches("[a-z]") && !strAfter.matches("[A-Z]")) {
                                    if (strRet.length() != 0) {
                                        strRet.append(", ");
                                    }
                                    strRet.append(key);
                                    bFind = true;
                                }
                            } else {
                                if (strRet.length() != 0) {
                                    strRet.append(", ");
                                }
                                strRet.append(key);
                                bFind = true;
                            }
                        }
                    } else {
                        if (strRet.length() != 0) {
                            strRet.append(", ");
                        }
                        strRet.append(key);
                        bFind = true;
                    }
                    if (bFind || str.length() <= iIndex + value.length()) continue block2;
                    iIndex += value.length();
                    ++iCnt;
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
            }
        }
        return strRet.toString();
    }

    private void checkMessage() throws Exception {
        String[] TAGS = new String[]{"HIE_EN", "HIE_JA", "HIJ_EN", "HIJ_JA", "HPE_EN", "HPE_JA", "HPJ_EN", "HPJ_JA", "HIE_EN_ACTION", "HIE_JA_ACTION", "HIJ_EN_ACTION", "HIJ_JA_ACTION", "HPE_EN_ACTION", "HPE_JA_ACTION", "HPJ_EN_ACTION", "HPJ_JA_ACTION"};
        try {
            System.out.println("\u25a0\u25a0\u25a0\u30e1\u30c3\u30bb\u30fc\u30b8\u30c1\u30a7\u30c3\u30af\u958b\u59cb\u25a0\u25a0\u25a0");
            File dir = new File(m_MasterMsg);
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.getName().startsWith(_prefix)) {
                    System.out.println("Reading ... " + file.getName());
                    this.checkMessageA(String.valueOf(dir.getName()) + File.separator + file.getName(), TAGS);
                }
                ++i;
            }
            if (!this.isError) {
                System.out.println("\u2605\u2605\u2605" + _header + " \u30b9\u30da\u30eb\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!dupIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(dupIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u91cd\u8907\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u91cd\u8907\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!zenkakuIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(zenkakuIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u5168\u89d2\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u5168\u89d2\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!kaigyouIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(kaigyouIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u6539\u884c\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u6539\u884c\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!replacementList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(replacementList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u7f6e\u63db\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u7f6e\u63db\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void checkProperties() throws Exception {
        FileSearch s = new FileSearch();
        File[] fs = s.listFiles(rootDirectory, "*properties");
        ArrayList<File> props = new ArrayList<File>();
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().endsWith("ja.properties") && !f.getName().endsWith("JA.properties")) {
                props.add(f);
            }
            ++n2;
        }
        SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(new File(dictFile), null);
        this.spellCheck = new SpellChecker(dictionary);
        this.spellCheck.addSpellCheckListener(this);
        for (File prop : props) {
            System.out.println(prop.getAbsolutePath().replaceAll(new File(rootDirectory).getParent().replace("\\", "\\\\"), ""));
            Properties p = new Properties();
            p.load(new FileInputStream(prop.getAbsolutePath()));
            for (Object val : p.values()) {
                String[] strs;
                String[] stringArray = strs = ((String)val).split(" ,:.");
                int n3 = strs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String str = stringArray[n4];
                    this.spellCheck.checkSpelling(new StringWordTokenizer(str));
                    ++n4;
                }
            }
        }
    }

    private void checkGuidance() throws Exception {
        String[] TAGS = new String[]{"HIE_EN", "HIE_JA", "HIJ_EN", "HIJ_JA", "HPE_EN", "HPE_JA", "HPJ_EN", "HPJ_JA"};
        try {
            System.out.println("\u25a0\u25a0\u25a0\u30ac\u30a4\u30c0\u30f3\u30b9\u30c1\u30a7\u30c3\u30af\u958b\u59cb\u25a0\u25a0\u25a0");
            File dir = new File(m_MasterGuid);
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.getName().startsWith(_prefix_guid)) {
                    System.out.println("Reading ... " + file.getName());
                    this.checkGuidanceA(String.valueOf(dir.getName()) + File.separator + file.getName(), TAGS);
                }
                ++i;
            }
            if (!this.isError) {
                System.out.println("\u2605\u2605\u2605" + _header + " \u30b9\u30da\u30eb\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!dupIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(dupIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u91cd\u8907\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u91cd\u8907\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!zenkakuIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(zenkakuIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u5168\u89d2\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u5168\u89d2\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!kaigyouIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(kaigyouIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u6539\u884c\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u6539\u884c\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!replacementList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(replacementList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u7f6e\u63db\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u7f6e\u63db\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void checkGuidanceA(String fileStr, String[] TAGS) throws Exception {
        try {
            SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(new File(dictFile), null);
            this.spellCheck = new SpellChecker(dictionary);
            this.spellCheck.addSpellCheckListener(this);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            File f = new File(fileStr);
            Document doc = builder.parse(f);
            Element root = doc.getDocumentElement();
            if (root.getNodeName().equals(ROOT_EXL2003_SPD)) {
                System.out.println(ERR_STR_INVALID_FORMAT + fileStr);
                System.exit(1);
            }
            NodeList children = root.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                boolean bRsv = false;
                Node child = children.item(i);
                if (child instanceof Element) {
                    Element childElement = (Element)child;
                    NodeList e = childElement.getChildNodes();
                    int j = 0;
                    while (j < e.getLength()) {
                        Node n = e.item(j);
                        if (n instanceof Element) {
                            String text;
                            String tag = ((Element)n).getTagName();
                            if (this.isReservedElement(tag, text = n.getTextContent())) {
                                bRsv = true;
                                break;
                            }
                            if (this.getGuidFirstKey().equals(tag)) {
                                this.m_key = text;
                            }
                            if (this.getGuidSecondKey().equals(tag)) {
                                this.m_key = String.valueOf(this.m_key) + "/" + text;
                            }
                            this.m_Tag = tag;
                            this.checkElementText(this.m_key, TAGS, tag, text);
                        }
                        ++j;
                    }
                    if (!bRsv) {
                        if (idSet.contains(this.m_key) && !this.m_key.contains("#")) {
                            dupIdList.add(this.m_key);
                        }
                        idSet.add(this.m_key);
                    } else {
                        bRsv = false;
                    }
                }
                ++i;
            }
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            throw e;
        }
    }

    void checkElementText(String key, String[] TAGS, String tag, String text) throws Exception {
        if (this.spellCheck != null) {
            String[] stringArray = TAGS;
            int n = TAGS.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (t.equals(tag) && !key.contains("#") && !text.isEmpty()) {
                    text = text.replace("\\\\n", " ");
                    text = text.replaceAll("@*@", " ");
                    if (tag.endsWith("_EN") || tag.endsWith("_EN_ACTION")) {
                        this.spellCheck.checkSpelling(new StringWordTokenizer(text));
                        if (text.getBytes().length != text.length() && !key.equals(_header)) {
                            zenkakuIdList.add(String.valueOf(key) + " [" + tag + "]");
                        }
                    }
                    if (text.contains("\n") && !key.equals(_header)) {
                        kaigyouIdList.add(String.valueOf(key) + " [" + tag + "] -> \u30e1\u30c3\u30bb\u30fc\u30b8\u4e2d\u306b\u6539\u884c\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059\u3002\u7b87\u6761\u66f8\u304d\u306e\u5834\u5408\u306f\\\\n\u3092\u633f\u5165\u3057\u3001\u305d\u3046\u3067\u306a\u3044\u5834\u5408\u306f\u6539\u884c\u3092\u6d88\u3057\u3066\u4e0b\u3055\u3044\u3002");
                    } else if (text.contains("\\n") && !key.equals(_header)) {
                        kaigyouIdList.add(String.valueOf(key) + " [" + tag + "] -> \u633f\u5165\u3057\u3088\u3046\u3068\u3057\u305f\u6539\u884c\u30b3\u30fc\u30c9(\\\\n)\u306f\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                    }
                    String replacement = this.checkReplacementString(tag, text);
                    if (!replacement.isEmpty()) {
                        replacementList.add(String.valueOf(key) + " [" + tag + "]" + "\n" + "        " + text + "\n" + "          -> @xxx@(" + replacement + ")\u3078\u7f6e\u304d\u63db\u3048\u3092\u691c\u8a0e\u9858\u3044\u307e\u3059");
                    }
                }
                ++n2;
            }
        } else {
            throw new Exception("\u5185\u90e8\u8ad6\u7406\u77db\u76fe\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u518d\u767a\u3059\u308b\u5834\u5408\u306f\u30c4\u30fc\u30eb\u63d0\u4f9b\u5143\u307e\u3067\u9023\u7d61\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
    }

    boolean isReservedElement(String tag, String text) {
        boolean bRet = false;
        if ("RESERVED".equals(tag)) {
            if ("#".equals(text)) {
                bRet = true;
            }
            if ("\u4e88\u7d04".equals(text)) {
                bRet = true;
            }
        }
        return bRet;
    }

    boolean isInvalidOemElement(String tag, String text) {
        boolean bRet = false;
        if ("KISYUID".equals(tag) && !"0".equals(text)) {
            if (isHm) {
                if (!"2".equals(text)) {
                    bRet = true;
                }
            } else if (!"1".equals(text)) {
                bRet = true;
            }
        }
        return bRet;
    }

    String getGuidFirstKey() {
        String strRet = "DISPLAY_ID";
        if (TYPE.GUIDOLD == type) {
            strRet = "FUNCTION";
        }
        return strRet;
    }

    String getGuidSecondKey() {
        String strRet = "PART_ID";
        if (TYPE.GUIDOLD == type) {
            strRet = "TAG";
        }
        return strRet;
    }

    public void makeDictionary() {
        File outFile = new File(dictFile);
        File inFile = new File(dictFile.replaceFirst(".tmp", DICT_BASE));
        FileOutputStream outStream = null;
        InputStreamReader flRd = null;
        OutputStreamWriter flWr = null;
        BufferedWriter bfWr = null;
        BufferedReader bfRd = null;
        try {
            try {
                String key;
                outStream = new FileOutputStream(outFile);
                bfWr = new BufferedWriter(new OutputStreamWriter(outStream));
                flRd = new FileReader(inFile);
                bfRd = new BufferedReader(flRd);
                String tmpBuf = "";
                while (tmpBuf != null) {
                    tmpBuf = bfRd.readLine();
                    if (tmpBuf == null || tmpBuf.length() == 0) continue;
                    bfWr.write(tmpBuf);
                    bfWr.newLine();
                }
                for (Map.Entry<Object, Object> e : _r_hie_en.entrySet()) {
                    key = (String)e.getKey();
                    bfWr.write(key);
                    bfWr.newLine();
                }
                for (Map.Entry<Object, Object> e : _r_hpe_en.entrySet()) {
                    key = (String)e.getKey();
                    bfWr.write(key);
                    bfWr.newLine();
                }
            }
            catch (Exception jvExp) {
                jvExp.printStackTrace();
                System.exit(1);
                try {
                    if (bfWr != null) {
                        bfWr.flush();
                        bfWr.close();
                    }
                    if (bfRd != null) {
                        bfRd.close();
                    }
                }
                catch (Exception bufExp) {
                    bufExp.printStackTrace();
                }
                try {
                    if (flWr != null) {
                        flWr.flush();
                        flWr.close();
                    }
                    if (flRd != null) {
                        flRd.close();
                    }
                }
                catch (Exception bufExp) {
                    bufExp.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bfWr != null) {
                    bfWr.flush();
                    bfWr.close();
                }
                if (bfRd != null) {
                    bfRd.close();
                }
            }
            catch (Exception bufExp) {
                bufExp.printStackTrace();
            }
            try {
                if (flWr != null) {
                    flWr.flush();
                    flWr.close();
                }
                if (flRd != null) {
                    flRd.close();
                }
            }
            catch (Exception bufExp) {
                bufExp.printStackTrace();
            }
        }
    }

    private void checkReplaceDefine() throws Exception {
        try {
            this.isError = false;
            _header = "\u7f6e\u63db\u30ad\u30fc";
            zenkakuIdList.clear();
            System.out.println("\u25a0\u25a0\u25a0\u7f6e\u63db\u6587\u5b57\u5217\u30c1\u30a7\u30c3\u30af\u958b\u59cb\u25a0\u25a0\u25a0");
            Set<Map.Entry<String, Properties>> propSet = proHashSet.entrySet();
            for (Map.Entry<String, Properties> entry : propSet) {
                if (entry.getKey().contains("ACTION")) continue;
                System.out.println("Reading ... replacement_" + entry.getKey());
                this.checkReplaceDefineA(entry.getValue(), entry.getKey());
            }
            if (!this.isError) {
                System.out.println("\u2605\u2605\u2605" + _header + " \u30b9\u30da\u30eb\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
            if (!zenkakuIdList.isEmpty()) {
                TreeSet<String> tree = new TreeSet<String>(zenkakuIdList);
                System.out.println("\u2605\u2605\u2605" + _header + " \u5168\u89d2\u30c1\u30a7\u30c3\u30afNG.\u2605\u2605\u2605");
                for (String s : tree) {
                    System.out.println("    " + s);
                }
            } else {
                System.out.println("\u2605\u2605\u2605" + _header + " \u5168\u89d2\u30c1\u30a7\u30c3\u30afOK.\u2605\u2605\u2605");
            }
        }
        catch (IOException | SAXException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void checkReplaceDefineA(Properties prop, String strOem) throws Exception {
        try {
            if (this.spellCheck == null) {
                SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(new File(dictFile), null);
                this.spellCheck = new SpellChecker(dictionary);
                this.spellCheck.addSpellCheckListener(this);
            }
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                this.m_key = (String)en.nextElement();
                String text = prop.getProperty(this.m_key);
                this.spellCheck.checkSpelling(new StringWordTokenizer(text));
                if (!strOem.contains("_EN") || text.getBytes().length == text.length()) continue;
                zenkakuIdList.add(this.m_key);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    static enum TARGETTYPE {
        PROPERTIES,
        MESSAGE_XML;

    }

    static enum TYPE {
        MSG,
        GUID,
        GUIDOLD,
        PROPERTIES;

    }
}

