/*
 * Decompiled with CFR 0.152.
 */
package com.ws.utilities;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class NetworkUtils {
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static final String VIRTUAL_GATEWAY = "192.168.122.1";

    public static List<InetAddress> getActiveIPs() throws SocketException {
        ArrayList<InetAddress> ret = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> inetEnum = NetworkInterface.getNetworkInterfaces();
        while (inetEnum.hasMoreElements()) {
            NetworkInterface niFace = inetEnum.nextElement();
            if (!niFace.isUp()) continue;
            Enumeration<InetAddress> ipAddys = niFace.getInetAddresses();
            while (ipAddys.hasMoreElements() && !niFace.isLoopback() && !niFace.isPointToPoint() && !niFace.isVirtual()) {
                InetAddress inet = ipAddys.nextElement();
                if (!inet.isSiteLocalAddress() && !inet.isLinkLocalAddress()) continue;
                ret.add(inet);
            }
        }
        return ret;
    }

    public static String getLocalIPAddress() {
        String ret = LOOPBACK_ADDRESS;
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    String ip = inetAddress.getHostAddress();
                    if (VIRTUAL_GATEWAY.equals(ip) || !inetAddress.isSiteLocalAddress()) continue;
                    ret = inetAddress.getHostAddress();
                    if (!(inetAddress instanceof Inet6Address) || ret.startsWith("[")) break;
                    ret = "[" + ret + "]";
                    break;
                }
                if (LOOPBACK_ADDRESS.equals(ret)) continue;
                break;
            }
            if (LOOPBACK_ADDRESS.equals(ret)) {
                InetAddress inetAddress = InetAddress.getLocalHost();
                ret = inetAddress.getHostAddress();
                if (inetAddress instanceof Inet6Address && !ret.startsWith("[")) {
                    ret = "[" + ret + "]";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }
}

