/*
 * Decompiled with CFR 0.152.
 */
package org.wbemservices.wbem.query;

import javax.cim.UnsignedInteger16;
import javax.cim.UnsignedInteger32;
import javax.cim.UnsignedInteger64;
import javax.cim.UnsignedInteger8;
import org.wbemservices.wbem.query.ValueExp;

public class NumericValue
extends ValueExp {
    static final long serialVersionUID = -8171898390662045051L;
    private long longVal;
    private double doubleVal;
    private UnsignedInteger64 uint64;
    private boolean uint = false;
    private boolean sint = false;
    private boolean dbl = false;

    public NumericValue(Number val) {
        if (val instanceof Long || val instanceof Integer || val instanceof Short || val instanceof Byte) {
            this.longVal = val.longValue();
            this.sint = true;
        } else if (val instanceof UnsignedInteger64 || val instanceof UnsignedInteger8 || val instanceof UnsignedInteger16 || val instanceof UnsignedInteger32) {
            this.uint64 = val instanceof UnsignedInteger64 ? (UnsignedInteger64)val : new UnsignedInteger64(val.toString());
            this.uint = true;
        } else {
            this.doubleVal = new Double(val + "");
            this.dbl = true;
        }
    }

    public NumericValue() {
        this.longVal = 0L;
        this.sint = true;
    }

    public double doubleValue() {
        if (this.sint) {
            return this.longVal;
        }
        if (this.uint) {
            return this.uint64.doubleValue();
        }
        return this.doubleVal;
    }

    public long longValue() {
        if (this.sint) {
            return this.longVal;
        }
        if (this.uint) {
            return this.uint64.longValue();
        }
        return (long)this.doubleVal;
    }

    public UnsignedInteger64 uint64Value() {
        if (this.sint) {
            return new UnsignedInteger64(String.valueOf(this.longVal));
        }
        if (this.uint) {
            return this.uint64;
        }
        return new UnsignedInteger64(String.valueOf((long)this.doubleVal));
    }

    public boolean isUint() {
        return this.uint;
    }

    public boolean isSint() {
        return this.sint;
    }

    public boolean isReal() {
        return this.dbl;
    }

    public String toString() {
        if (this.uint) {
            return this.uint64.toString();
        }
        if (this.sint) {
            return String.valueOf(this.longVal);
        }
        return String.valueOf(this.doubleVal);
    }
}

