/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.cell.EditorRendererRegistry;
import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellRenderer;
import com.klg.jclass.cell.swing.JCCellEditorToJTable;
import com.klg.jclass.cell.swing.JCCellRendererToJTable;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.Version;
import com.klg.jclass.util.swing.DefaultRowSortTableModel;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCElasticLayout;
import com.klg.jclass.util.swing.JCMessageHelper;
import com.klg.jclass.util.swing.JCRowSortTableModel;
import com.klg.jclass.util.swing.JCTableColumn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class JCSortableTable
extends JTable {
    protected SortIcon upIcon = new SortIcon(true);
    protected SortIcon downIcon = new SortIcon(false);
    protected JCRowSortTableModel sortModel;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    protected MouseListener tableHeaderMouseListener;

    public JCSortableTable() {
        if (JCEnvironment.isDesignTime()) {
            Vector<String> vector = new Vector<String>();
            vector.addElement("Row 1, Column 1");
            vector.addElement("Row 1, Column 2");
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement("Row 2, Column 1");
            vector2.addElement("Row 2, Column 2");
            Vector<Vector<String>> vector3 = new Vector<Vector<String>>();
            vector3.addElement(vector);
            vector3.addElement(vector2);
            Vector<String> vector4 = new Vector<String>();
            vector4.addElement("Column 1");
            vector4.addElement("Column 2");
            this.setModel(new DefaultTableModel(vector3, vector4));
        }
    }

    public JCSortableTable(int n, int n2) {
        super(n, n2);
    }

    public JCSortableTable(Vector vector, Vector vector2) {
        super(vector, vector2);
    }

    public JCSortableTable(TableModel tableModel) {
        super(tableModel);
    }

    public JCSortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public JCSortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
    }

    public JCSortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
    }

    protected void addTableHeaderMouseListener() {
        if (this.getTableHeader() != null) {
            if (this.getTableHeaderMouseListener() == null) {
                this.setTableHeaderMouseListener(this.createTableHeaderMouseListener());
            }
            this.getTableHeader().addMouseListener(this.getTableHeaderMouseListener());
        }
    }

    protected void clearSortIcons() {
        int n = 0;
        while (n < this.columnModel.getColumnCount()) {
            this.setSortIcon(n, 0);
            ++n;
        }
    }

    protected void configureEnclosingScrollPane() {
        this.removeTableHeaderMouseListener();
        super.configureEnclosingScrollPane();
        this.addTableHeaderMouseListener();
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.removeColumnModelListener(this);
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            int n = 0;
            while (n < tableModel.getColumnCount()) {
                TableColumn tableColumn = this.createSortableTableColumn(n);
                this.addColumn(tableColumn);
                ++n;
            }
            tableColumnModel.addColumnModelListener(this);
        }
    }

    protected TableColumn createSortableTableColumn(int n) {
        return new SortableTableColumn(n);
    }

    protected MouseAdapter createTableHeaderMouseListener() {
        return new TableHeaderMouseListener();
    }

    public String getAbout() {
        return Version.getVersionString();
    }

    public boolean getAutoSort() {
        return this.sortModel.getAutoSort();
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellEditor tableCellEditor = tableColumn.getCellEditor();
        if (tableCellEditor == null && tableColumn instanceof JCTableColumn) {
            JCCellEditor jCCellEditor = EditorRendererRegistry.getCentralRegistry().getCellEditorInstance(this.getColumnClass(n2), ((JCTableColumn)tableColumn).getRegistryType());
            tableCellEditor = jCCellEditor == null ? null : new JCCellEditorToJTable(jCCellEditor);
        }
        if (tableCellEditor == null) {
            tableCellEditor = this.getDefaultEditor(this.getColumnClass(n2));
        }
        return tableCellEditor;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableColumn tableColumn = this.getColumnModel().getColumn(n2);
        TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
        if (tableCellRenderer == null && tableColumn instanceof JCTableColumn) {
            JCCellRenderer jCCellRenderer = EditorRendererRegistry.getCentralRegistry().getCellRendererInstance(this.getColumnClass(n2), ((JCTableColumn)tableColumn).getRegistryType());
            tableCellRenderer = jCCellRenderer == null ? null : new JCCellRendererToJTable(jCCellRenderer);
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = this.getDefaultRenderer(this.getColumnClass(n2));
        }
        return tableCellRenderer;
    }

    public int[] getKeyColumns(int n) {
        return ((JCRowSortTableModel)((Object)this.dataModel)).getKeyColumns(n);
    }

    public Dimension getPreferredSize() {
        if (JCEnvironment.isDesignTime()) {
            return new Dimension(200, 200);
        }
        return super.getPreferredSize();
    }

    protected MouseListener getTableHeaderMouseListener() {
        return this.tableHeaderMouseListener;
    }

    public int getUnsortedRow(int n) {
        return this.sortModel.getUnsortedRow(n);
    }

    protected void removeTableHeaderMouseListener() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().removeMouseListener(this.getTableHeaderMouseListener());
        }
    }

    public void setAbout(String string) {
    }

    public void setAutoSort(boolean bl) {
        this.sortModel.setAutoSort(bl);
    }

    public void setKeyColumns(int n, int[] nArray) {
        ((JCRowSortTableModel)((Object)this.dataModel)).setKeyColumns(n, nArray);
    }

    public void setModel(TableModel tableModel) {
        if (tableModel instanceof JCRowSortTableModel) {
            this.sortModel = (JCRowSortTableModel)((Object)tableModel);
            super.setModel(tableModel);
        } else {
            this.sortModel = new DefaultRowSortTableModel(tableModel);
            super.setModel((TableModel)((Object)this.sortModel));
        }
        this.removeTableHeaderMouseListener();
        this.addTableHeaderMouseListener();
    }

    protected void setSortIcon(int n) {
        this.setSortIcon(n, ((JCRowSortTableModel)((Object)this.dataModel)).getSortOrder());
    }

    protected void setSortIcon(int n, int n2) {
        SortIcon sortIcon = n2 == 1 ? this.downIcon : (n2 == -1 ? this.upIcon : null);
        TableColumn tableColumn = this.columnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        this.setSortIcon(tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, n), sortIcon);
    }

    protected void setSortIcon(Component component, Icon icon) {
        if (component instanceof SortableColumnHeader) {
            ((SortableColumnHeader)((Object)component)).setSortIcon(icon);
            this.tableHeader.repaint();
        } else if (component instanceof JLabel) {
            ((JLabel)component).setHorizontalTextPosition(10);
            ((JLabel)component).setIcon(icon);
            this.tableHeader.repaint();
        } else if (component instanceof JButton) {
            ((JButton)component).setHorizontalTextPosition(10);
            ((JButton)component).setIcon(icon);
            ((AbstractTableModel)this.dataModel).fireTableDataChanged();
            this.tableHeader.repaint();
        } else if (component instanceof Container && ((Container)component).getComponentCount() != 0) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.setSortIcon(componentArray[n], icon);
                ++n;
            }
        }
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        if (this.getTableHeaderMouseListener() != null) {
            this.removeTableHeaderMouseListener();
        }
        super.setTableHeader(jTableHeader);
        this.addTableHeaderMouseListener();
    }

    protected void setTableHeaderMouseListener(MouseListener mouseListener) {
        this.tableHeaderMouseListener = mouseListener;
    }

    public void sort(int n) {
        if (!(this.dataModel instanceof JCRowSortTableModel)) {
            throw new IllegalArgumentException("TableModel is not an instance of JCRowSortTableModel");
        }
        if (this.isEditing() && this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            JCMessageHelper.showError("Error", "Sort cannot be performed while a cell is editing.");
            return;
        }
        n = this.convertColumnIndexToModel(n);
        if (((JCRowSortTableModel)((Object)this.dataModel)).getSortColumn() == n) {
            ((JCRowSortTableModel)((Object)this.dataModel)).toggleSortOrder();
        } else {
            ((JCRowSortTableModel)((Object)this.dataModel)).setSortColumn(n);
        }
        if (!((JCRowSortTableModel)((Object)this.dataModel)).isDataSorted()) {
            ((JCRowSortTableModel)((Object)this.dataModel)).setDataSorted(true);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        this.clearSortIcons();
        if (this.sortModel.isDataSorted() && (n = ((JCRowSortTableModel)((Object)this.dataModel)).getSortColumn()) >= 0) {
            this.setSortIcon(this.convertColumnIndexToView(n), ((JCRowSortTableModel)((Object)this.dataModel)).getSortOrder());
        }
        super.tableChanged(tableModelEvent);
    }

    public void unsort() {
        if (!(this.dataModel instanceof JCRowSortTableModel)) {
            throw new IllegalArgumentException("TableModel is not an instance of JCRowSortTableModel");
        }
        ((JCRowSortTableModel)((Object)this.dataModel)).setDataSorted(false);
    }

    class TableHeaderMouseListener
    extends MouseAdapter
    implements Serializable {
        TableHeaderMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 1 && !mouseEvent.isPopupTrigger() && (n = JCSortableTable.this.columnAtPoint(mouseEvent.getPoint())) >= 0) {
                JCSortableTable.this.sort(n);
            }
        }
    }

    private class SortIcon
    implements Icon,
    Serializable {
        protected boolean isUp;
        protected Color color = Color.black;
        protected int width = 6;
        protected int height = 6;
        protected int[] xpoints = new int[3];
        protected int[] ypoints = new int[3];

        SortIcon(boolean bl) {
            this.isUp = bl;
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.isUp) {
                this.xpoints[0] = n;
                this.ypoints[0] = n2 + this.height;
                this.xpoints[1] = n + this.width / 2;
                this.ypoints[1] = n2;
                this.xpoints[2] = n + this.width;
                this.ypoints[2] = n2 + this.height;
            } else {
                this.xpoints[0] = n;
                this.ypoints[0] = n2;
                this.xpoints[1] = n + this.width / 2;
                this.ypoints[1] = n2 + this.height;
                this.xpoints[2] = n + this.width;
                this.ypoints[2] = n2;
            }
            graphics.setColor(Color.black);
            graphics.fillPolygon(this.xpoints, this.ypoints, 3);
            graphics.setColor(Color.gray);
            graphics.drawPolygon(this.xpoints, this.ypoints, 3);
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    class SortableTableColumn
    extends JCTableColumn
    implements Serializable {
        public SortableTableColumn(int n) {
            super(n);
            this.setHeaderRenderer(this.createDefaultHeaderRenderer());
        }

        protected TableCellRenderer createDefaultHeaderRenderer() {
            SortableHeaderRenderer sortableHeaderRenderer = new SortableHeaderRenderer();
            return sortableHeaderRenderer;
        }
    }

    class SortableHeaderRenderer
    extends JPanel
    implements TableCellRenderer,
    SortableColumnHeader,
    Serializable {
        protected JLabel label = new JLabel("label");
        protected JButton sortButton = new JButton();
        protected JCBrace brace = JCBrace.createHorizontalBrace(3);

        public SortableHeaderRenderer() {
            JCElasticLayout jCElasticLayout = new JCElasticLayout(0);
            jCElasticLayout.setAlignment(0);
            this.setLayout(jCElasticLayout);
            this.sortButton.setBorder(emptyBorder);
            this.add((Component)this.label, JCElasticLayout.HORIZONTALLY_ELASTIC_CONSTRAINT);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.label.setForeground(jTableHeader.getForeground());
                this.label.setBackground(jTableHeader.getBackground());
                this.label.setFont(jTableHeader.getFont());
            }
            this.label.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }

        public void setSortIcon(Icon icon) {
            if (icon == null && this.sortButton.getParent() != null) {
                this.remove(this.sortButton);
                this.remove(this.brace);
            } else if (icon != null) {
                this.sortButton.setIcon(icon);
                if (this.sortButton.getParent() == null) {
                    this.add(this.sortButton);
                    this.add(this.brace);
                }
            }
        }
    }

    public static interface SortableColumnHeader {
        public void setSortIcon(Icon var1);
    }
}

