/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

class ServiceRegistration
extends SLPMessage {
    ServiceURL url;
    ServiceType serviceType;
    List scopeList;
    List attList;
    AuthenticationBlock[] authBlocks;

    ServiceRegistration(ServiceURL serviceURL, ServiceType type, List scopes, List attributes, Locale theLocale) {
        this.funcID = (byte)3;
        this.locale = theLocale;
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("serviceType must not be null");
        }
        this.url = serviceURL;
        this.serviceType = type;
        this.scopeList = scopes;
        if (this.scopeList == null) {
            this.scopeList = Arrays.asList("default");
        }
        this.attList = attributes;
        if (this.attList == null) {
            this.attList = new ArrayList();
        }
        this.authBlocks = new AuthenticationBlock[0];
    }

    ServiceRegistration(DataInputStream input) throws ServiceLocationException, IOException {
        this.funcID = (byte)3;
        this.locale = SLPCore.DEFAULT_LOCALE;
        this.url = ServiceURL.fromBytes(input);
        this.serviceType = new ServiceType(input.readUTF());
        this.scopeList = ServiceRegistration.stringToList(input.readUTF(), ",");
        this.attList = this.attributeStringToList(input.readUTF());
        this.authBlocks = AuthenticationBlock.parse(input);
        if (SLPCore.CONFIG.getSecurityEnabled() && !this.verify()) {
            throw new ServiceLocationException(7, "Authentication failed for " + this.toString());
        }
    }

    @Override
    protected void writeTo(DataOutputStream out) throws IOException {
        this.url.writeTo(out);
        out.writeUTF(this.serviceType.toString());
        out.writeUTF(ServiceRegistration.listToString(this.scopeList, ","));
        out.writeUTF(ServiceRegistration.listToString(this.attList, ","));
        out.write(this.authBlocks.length);
        for (int i = 0; i < this.authBlocks.length; ++i) {
            this.authBlocks[i].write(out);
        }
    }

    @Override
    protected int getSize() {
        int len = this.getHeaderSize() + this.url.getLength() + 2 + this.serviceType.toString().length() + 2 + ServiceRegistration.listToString(this.scopeList, ",").length() + 2 + ServiceRegistration.listToString(this.attList, ",").length() + 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            len += this.authBlocks[i].getLength();
        }
        return len;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append(", url: " + this.url);
        buffer.append(", serviceType: " + this.serviceType);
        buffer.append(", scopeList: " + this.scopeList);
        buffer.append(", attList: " + this.attList);
        return buffer.toString();
    }

    void sign(List spiList) throws ServiceLocationException {
        this.url.sign(spiList);
        this.authBlocks = new AuthenticationBlock[spiList.size()];
        for (int k = 0; k < spiList.size(); ++k) {
            int timestamp = SLPUtils.getTimestamp();
            String spi = (String)spiList.get(k);
            byte[] data = this.getAuthData(spi, timestamp);
            this.authBlocks[k] = new AuthenticationBlock(2, spi, timestamp, data, null);
        }
    }

    boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            if (!this.authBlocks[i].verify(this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp()))) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String spi, int timestamp) throws ServiceLocationException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(spi);
            dos.writeUTF(ServiceRegistration.listToString(this.attList, ","));
            dos.writeInt(timestamp);
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ServiceLocationException(20, ioe.getMessage());
        }
    }
}

