/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl.filter;

import ch.ethz.iks.slp.impl.filter.Filter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public final class RFC1960Filter
implements Filter {
    private static final int AND_OPERATOR = 1;
    private static final int OR_OPERATOR = 2;
    private static final int NOT_OPERATOR = 3;
    private static final int EQUALS = 0;
    private static final int PRESENT = 1;
    private static final int APPROX = 2;
    private static final int GREATER = 3;
    private static final int LESS = 4;
    private static final String[] OP = new String[]{"=", "=*", "~=", ">=", "<="};
    private static final Class[] STRINGCLASS = new Class[]{String.class};
    private static final Filter NULL_FILTER = new Filter(){

        @Override
        public boolean match(Dictionary dictionary) {
            return true;
        }

        @Override
        public String toString() {
            return "";
        }
    };
    private final List operands = new ArrayList(1);
    private final int operator;

    private RFC1960Filter(int operator) {
        this.operator = operator;
    }

    public static Filter fromString(String filterString) {
        if (filterString == null || "".equals(filterString)) {
            return NULL_FILTER;
        }
        Stack<RFC1960Filter> stack = new Stack<RFC1960Filter>();
        try {
            int len = filterString.length();
            int last = -1;
            int oper = 0;
            String id = null;
            int comparator = -1;
            char[] chars = filterString.toCharArray();
            stack.clear();
            block10: for (int i = 0; i < chars.length; ++i) {
                switch (chars[i]) {
                    case '(': {
                        char nextChar = chars[i + 1];
                        if (nextChar == '&') {
                            stack.push(new RFC1960Filter(1));
                            continue block10;
                        }
                        if (nextChar == '|') {
                            stack.push(new RFC1960Filter(2));
                            continue block10;
                        }
                        if (nextChar == '!') {
                            stack.push(new RFC1960Filter(3));
                            continue block10;
                        }
                        if (last == -1) {
                            last = i;
                            continue block10;
                        }
                        throw new IllegalStateException("Surplus left paranthesis at: " + filterString.substring(i));
                    }
                    case ')': {
                        String value;
                        if (last == -1) {
                            RFC1960Filter filter = (RFC1960Filter)stack.pop();
                            if (stack.isEmpty()) {
                                return filter;
                            }
                            RFC1960Filter parent = (RFC1960Filter)stack.peek();
                            if (parent.operator == 3 && !parent.operands.isEmpty()) {
                                throw new IllegalStateException("Unexpected literal: " + filterString.substring(i));
                            }
                            parent.operands.add(filter);
                            if (i != len - 1) continue block10;
                            throw new IllegalStateException("Missing right paranthesis at the end.");
                        }
                        if (oper == 0) {
                            throw new IllegalStateException("Missing operator.");
                        }
                        if (stack.isEmpty()) {
                            if (i == len - 1) {
                                String value2;
                                if ((value2 = filterString.substring(++oper, len - 1)).equals("*") && comparator == 0) {
                                    comparator = 1;
                                    value2 = null;
                                }
                                return new RFC1960SimpleFilter(id, comparator, value2);
                            }
                            throw new IllegalStateException("Unexpected literal: " + filterString.substring(i));
                        }
                        RFC1960Filter parent = (RFC1960Filter)stack.peek();
                        if ((value = filterString.substring(++oper, i)).equals("*") && comparator == 0) {
                            comparator = 1;
                            value = null;
                        }
                        parent.operands.add(new RFC1960SimpleFilter(id, comparator, value));
                        oper = 0;
                        last = -1;
                        id = null;
                        comparator = -1;
                        continue block10;
                    }
                    case '~': {
                        if (oper == 0 && chars[i + 1] == '=') {
                            id = filterString.substring(last + 1, i).trim();
                            comparator = 2;
                            oper = ++i;
                            continue block10;
                        }
                        throw new IllegalStateException("Unexpected character " + chars[i + 1]);
                    }
                    case '>': {
                        if (oper == 0 && chars[i + 1] == '=') {
                            id = filterString.substring(last + 1, i).trim();
                            comparator = 3;
                            oper = ++i;
                            continue block10;
                        }
                        throw new IllegalStateException("Unexpected character " + chars[i + 1]);
                    }
                    case '<': {
                        if (oper == 0 && chars[i + 1] == '=') {
                            id = filterString.substring(last + 1, i).trim();
                            comparator = 4;
                            oper = ++i;
                            continue block10;
                        }
                        throw new IllegalStateException("Unexpected character " + chars[i + 1]);
                    }
                    case '=': {
                        id = filterString.substring(last + 1, i).trim();
                        comparator = 0;
                        oper = i;
                        continue block10;
                    }
                }
            }
            return (RFC1960Filter)stack.pop();
        }
        catch (EmptyStackException e) {
            throw new IllegalStateException("Filter expression not well-formed.");
        }
    }

    @Override
    public boolean match(Dictionary values) {
        if (this.operator == 1) {
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (operandArray[i].match(values)) continue;
                return false;
            }
            return true;
        }
        if (this.operator == 2) {
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (!operandArray[i].match(values)) continue;
                return true;
            }
            return false;
        }
        if (this.operator == 3) {
            return !((Filter)this.operands.get(0)).match(values);
        }
        throw new IllegalStateException("PARSER ERROR");
    }

    @Override
    public String toString() {
        if (this.operator == 3) {
            return "(!" + this.operands.get(0) + ")";
        }
        StringBuffer buffer = new StringBuffer(this.operator == 1 ? "(&" : "(|");
        Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
        for (int i = 0; i < operandArray.length; ++i) {
            buffer.append(operandArray[i]);
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RFC1960Filter) {
            RFC1960Filter filter = (RFC1960Filter)obj;
            if (this.operands.size() != filter.operands.size()) {
                return false;
            }
            Filter[] operandArray = this.operands.toArray(new Filter[this.operands.size()]);
            Filter[] operandArray2 = filter.operands.toArray(new Filter[this.operands.size()]);
            for (int i = 0; i < operandArray.length; ++i) {
                if (operandArray[i].equals(operandArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static final class RFC1960SimpleFilter
    implements Filter {
        private final String id;
        private final int comparator;
        private final String value;

        private RFC1960SimpleFilter(String id, int comparator, String value) {
            this.id = id;
            this.comparator = comparator;
            this.value = value;
        }

        @Override
        public boolean match(Dictionary map) {
            Object temp = null;
            temp = map.get(this.id);
            if (temp == null) {
                temp = map.get(this.id.toLowerCase());
            }
            if (temp == null) {
                Enumeration keys = map.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!key.equalsIgnoreCase(this.id)) continue;
                    temp = map.get(key);
                    break;
                }
            }
            if (temp == null) {
                return false;
            }
            if (this.comparator == 1) {
                return true;
            }
            Object attr = temp;
            try {
                if (attr instanceof String) {
                    return RFC1960SimpleFilter.compareString(this.value, this.comparator, (String)attr);
                }
                if (attr instanceof Number) {
                    return RFC1960SimpleFilter.compareNumber(this.value, this.comparator, (Number)attr);
                }
                if (attr instanceof String[]) {
                    String[] array = (String[])attr;
                    if (array.length == 0) {
                        return false;
                    }
                    String val = this.comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(this.value) : this.value;
                    for (int i = 0; i < array.length; ++i) {
                        if (!RFC1960SimpleFilter.compareString(val, this.comparator, array[i])) continue;
                        return true;
                    }
                    return false;
                }
                if (attr instanceof Boolean) {
                    return (this.comparator == 0 || this.comparator == 2) && ((Boolean)attr).equals(Boolean.valueOf(this.value));
                }
                if (attr instanceof Character) {
                    return this.value.length() == 1 ? RFC1960SimpleFilter.compareTyped(new Character(this.value.charAt(0)), this.comparator, (Character)attr) : false;
                }
                if (attr instanceof Vector) {
                    Vector vec = (Vector)attr;
                    Object[] obj = new Object[vec.size()];
                    vec.copyInto(obj);
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, obj);
                }
                if (attr instanceof Object[]) {
                    return RFC1960SimpleFilter.compareArray(this.value, this.comparator, (Object[])attr);
                }
                if (attr.getClass().isArray()) {
                    for (int i = 0; i < Array.getLength(attr); ++i) {
                        Object obj = Array.get(attr, i);
                        if ((!(obj instanceof Number) || !RFC1960SimpleFilter.compareNumber(this.value, this.comparator, (Number)obj)) && (!(obj instanceof Comparable) || !RFC1960SimpleFilter.compareReflective(this.value, this.comparator, (Comparable)obj))) continue;
                        return true;
                    }
                    return false;
                }
                if (attr instanceof Comparable) {
                    return RFC1960SimpleFilter.compareReflective(this.value, this.comparator, (Comparable)attr);
                }
                return false;
            }
            catch (Throwable t) {
                return false;
            }
        }

        private static boolean compareString(String val, int comparator, String attr) {
            String value = comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(val) : val;
            String attribute2 = comparator == 2 ? RFC1960SimpleFilter.stripWhitespaces(attr) : attr;
            switch (comparator) {
                case 0: 
                case 2: {
                    return RFC1960SimpleFilter.stringCompare(value.toCharArray(), 0, attribute2.toCharArray(), 0) == 0;
                }
                case 3: {
                    return RFC1960SimpleFilter.stringCompare(value.toCharArray(), 0, attribute2.toCharArray(), 0) <= 0;
                }
                case 4: {
                    return RFC1960SimpleFilter.stringCompare(value.toCharArray(), 0, attribute2.toCharArray(), 0) >= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareNumber(String value, int comparator, Number attr) {
            if (attr instanceof Integer) {
                int intAttr = (Integer)attr;
                int intValue = Integer.parseInt(value);
                switch (comparator) {
                    case 3: {
                        return intAttr >= intValue;
                    }
                    case 4: {
                        return intAttr <= intValue;
                    }
                }
                return intAttr == intValue;
            }
            if (attr instanceof Long) {
                long longAttr = (Long)attr;
                long longValue = Long.parseLong(value);
                switch (comparator) {
                    case 3: {
                        return longAttr >= longValue;
                    }
                    case 4: {
                        return longAttr <= longValue;
                    }
                }
                return longAttr == longValue;
            }
            if (attr instanceof Short) {
                short shortAttr = (Short)attr;
                short shortValue = Short.parseShort(value);
                switch (comparator) {
                    case 3: {
                        return shortAttr >= shortValue;
                    }
                    case 4: {
                        return shortAttr <= shortValue;
                    }
                }
                return shortAttr == shortValue;
            }
            if (attr instanceof Double) {
                double doubleAttr = (Double)attr;
                double doubleValue = Double.parseDouble(value);
                switch (comparator) {
                    case 3: {
                        return doubleAttr >= doubleValue;
                    }
                    case 4: {
                        return doubleAttr <= doubleValue;
                    }
                }
                return doubleAttr == doubleValue;
            }
            if (attr instanceof Float) {
                float floatAttr = ((Float)attr).floatValue();
                float floatValue = Float.parseFloat(value);
                switch (comparator) {
                    case 3: {
                        return floatAttr >= floatValue;
                    }
                    case 4: {
                        return floatAttr <= floatValue;
                    }
                }
                return floatAttr == floatValue;
            }
            if (attr instanceof Byte) {
                try {
                    return RFC1960SimpleFilter.compareTyped(Byte.decode(value), comparator, (Byte)attr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return RFC1960SimpleFilter.compareReflective(value, comparator, (Comparable)((Object)attr));
        }

        private static boolean compareTyped(Object typedVal, int comparator, Comparable attr) {
            switch (comparator) {
                case 0: 
                case 2: {
                    return attr.equals(typedVal);
                }
                case 3: {
                    return attr.compareTo(typedVal) >= 0;
                }
                case 4: {
                    return attr.compareTo(typedVal) <= 0;
                }
            }
            throw new IllegalStateException("Found illegal comparator.");
        }

        private static boolean compareArray(String value, int comparator, Object[] array) {
            for (int i = 0; i < array.length; ++i) {
                Object obj = array[i];
                if (!(obj instanceof String ? RFC1960SimpleFilter.compareString(value, comparator, (String)obj) : (obj instanceof Number ? RFC1960SimpleFilter.compareNumber(value, comparator, (Number)obj) : obj instanceof Comparable && RFC1960SimpleFilter.compareReflective(value, comparator, (Comparable)obj)))) continue;
                return true;
            }
            return false;
        }

        private static boolean compareReflective(String val, int comparator, Comparable attr) {
            Class<?> clazz = attr.getClass();
            Object typedVal = null;
            try {
                Constructor<?> constr = clazz.getConstructor(STRINGCLASS);
                typedVal = constr.newInstance(val);
                return RFC1960SimpleFilter.compareTyped(typedVal, comparator, attr);
            }
            catch (Exception didNotWork) {
                return false;
            }
        }

        private static String stripWhitespaces(String s) {
            return s.replace(' ', '\u0000');
        }

        private static int stringCompare(char[] c1, int p1, char[] c2, int p2) {
            if (p1 == c1.length) {
                return 0;
            }
            int l1 = c1.length;
            int l2 = c2.length;
            while (p1 < l1 && p2 < l2) {
                if (c1[p1] == c2[p2]) {
                    ++p1;
                    ++p2;
                    continue;
                }
                if (c1[p1] > 'A' && c1[p1] < 'Z') {
                    c1[p1] = (char)(c1[p1] + 32);
                }
                if (c2[p2] > 'A' && c2[p2] < 'Z') {
                    c2[p2] = (char)(c2[p2] + 32);
                }
                if (c1[p1] == c2[p2]) {
                    ++p1;
                    ++p2;
                    continue;
                }
                if (c1[p1] == '*') {
                    ++p1;
                    do {
                        if (RFC1960SimpleFilter.stringCompare(c1, p1, c2, p2) != 0) continue;
                        return 0;
                    } while (l2 - ++p2 > -1);
                    return 1;
                }
                if (c1[p1] < c2[p2]) {
                    return -1;
                }
                if (c1[p1] <= c2[p2]) continue;
                return 1;
            }
            if (p1 == l1 && p2 == l2 && c1[p1 - 1] == c2[p2 - 1]) {
                return 0;
            }
            if (c1[p1 - 1] == '*' && p1 == l1 && p2 == l2) {
                return 0;
            }
            int min = l1 < l2 ? l1 : l2;
            return l1 == min ? -1 : 1;
        }

        @Override
        public String toString() {
            return "(" + this.id + OP[this.comparator] + (this.value == null ? "" : this.value) + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof RFC1960SimpleFilter) {
                RFC1960SimpleFilter filter = (RFC1960SimpleFilter)obj;
                return this.comparator == filter.comparator && this.id.equals(filter.id) && this.value.equals(filter.value);
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

