/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com;

import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sanproject.client.com.RJcEventAdapter;
import sanproject.client.com.RJcID;
import sanproject.client.com.RJcTabID;

public class RJcFuncID
extends RJcID {
    protected String[] childIDNames = null;
    private SingleSelectionModel selectionModel = null;
    private SingleSelectionModel preSelectionModel = null;

    public RJcFuncID(String string) {
        super(string);
        String string2 = this.getText(string, "FuncTitle");
        this.menuItem = new JMenu(string2);
        this.menuItem.setForeground(this.getColor("MenuFgClr"));
        this.menuItem.setBackground(this.getColor("MenuBgClr"));
        this.menuItem.setIcon(this.getMenuIcon(string));
        this.menuItem.setMargin(new Insets(1, 2, 1, 2));
        this.menuItem.setName(string);
    }

    public String[] getChildIDNames() {
        return this.childIDNames;
    }

    public void addChildID(RJcID rJcID) {
        super.addChildID(rJcID);
        JMenuItem jMenuItem = rJcID.getMenuItem();
        this.menuItem.add(jMenuItem);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n == 1) {
            this.selectedID = (RJcTabID)itemEvent.getItem();
            this.menuItem.setForeground(this.getColor("SelMenuFgClr"));
            this.menuItem.setBackground(this.getColor("SelMenuBgClr"));
            if (this.selectionModel != null) {
                this.tabStateChanged();
            }
            super.itemStateChanged(itemEvent);
        } else {
            this.menuItem.setForeground(this.getColor("MenuFgClr"));
            this.menuItem.setBackground(this.getColor("MenuBgClr"));
            this.preSelectionModel = this.selectionModel;
            this.preSelectedID = this.selectedID;
            this.selectedID = null;
        }
    }

    private void tabStateChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RJcEventAdapter.eventMask = true;
                int n = RJcFuncID.this.childList.indexOf(RJcFuncID.this.selectedID);
                RJcFuncID.this.selectionModel.setSelectedIndex(n);
            }
        });
    }

    public void restoreSelection() {
        this.putLog("[FuncID]", "[restore]", "restoreSelection " + this.preSelectedID);
        this.menuItem.setForeground(this.getColor("SelMenuFgClr"));
        this.menuItem.setBackground(this.getColor("SelMenuBgClr"));
        this.selectionModel = this.preSelectionModel;
        super.restoreSelection();
    }

    public RJcTabID getSelectedID() {
        return (RJcTabID)this.selectedID;
    }

    public int getSelectedIndex() {
        int n = 0;
        if (this.selectedID == null || this.selectedID.isBlockade()) {
            this.selectedID = this.searchEnabledID();
            if (this.selectedID != null) {
                this.selectedID.doClick();
            }
        }
        n = this.childList.indexOf(this.selectedID);
        return n;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectedModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
        if (this.selectionModel != null) {
            this.selectionModel.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    SingleSelectionModel singleSelectionModel = (SingleSelectionModel)changeEvent.getSource();
                    int n = singleSelectionModel.getSelectedIndex();
                    if (n >= 0) {
                        RJcTabID rJcTabID = (RJcTabID)RJcFuncID.this.childList.get(n);
                        rJcTabID.doClick();
                    }
                }
            });
        }
    }

    public boolean isVisible() {
        boolean bl = false;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJcTabID rJcTabID = (RJcTabID)iterator.next();
            if (!rJcTabID.isVisible()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isEnabled() {
        boolean bl = false;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            RJcTabID rJcTabID = (RJcTabID)iterator.next();
            if (!rJcTabID.isEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

