/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.com.abs;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.abs.RJaTableColumn;
import sanproject.client.com.abs.RJaTableDataModel;
import sanproject.client.com.abs.RJaTableHeader;
import sanproject.client.com.abs.RJaTableManager;

public class RJaTable
extends JTable {
    public static final int VP_TABLE = 0;
    public static final int RH_TABLE = 1;
    private static final String[] name = new String[]{"VP_TABLE", "RH_TABLE"};
    private int kind;
    private RJaTableManager manager;
    private InnerTableModel model;

    public RJaTable(int n, RJaTableManager rJaTableManager) {
        this.kind = n;
        this.manager = rJaTableManager;
        this.model = new InnerTableModel(this.manager);
        this.setModel(this.model);
        this.model.setTable(this);
        this.addMouseListener(new BMouseAdapter(this.manager));
        RJaTableHeader rJaTableHeader = new RJaTableHeader();
        ((JTableHeader)rJaTableHeader).setReorderingAllowed(false);
        if (n == 1) {
            rJaTableHeader.setResizingAllowed(false);
        }
        HMouseAdapter hMouseAdapter = new HMouseAdapter(this.manager);
        rJaTableHeader.addMouseListener(hMouseAdapter);
        this.setTableHeader(rJaTableHeader);
    }

    public int getKind() {
        return this.kind;
    }

    public RJaTableManager getTableManager() {
        return this.manager;
    }

    public String getName() {
        return name[this.getKind()];
    }

    public void repaint(long l) {
        this.manager.superRefresh();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        RJaTableDataModel rJaTableDataModel;
        super.valueChanged(listSelectionEvent);
        if (this.manager != null && (rJaTableDataModel = this.manager.getDataModel()) != null && !rJaTableDataModel.isSorting()) {
            this.manager.valueChanged(listSelectionEvent);
            rJaTableDataModel.valueChanged(listSelectionEvent);
        }
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point = null;
        if (this.manager != null && this.manager.getDataModel() != null) {
            point = this.manager.getDataModel().getToolTipLocation(mouseEvent);
        }
        return point;
    }

    class HMouseAdapter
    extends MouseAdapter {
        private RJaTableManager tm;

        HMouseAdapter(RJaTableManager rJaTableManager) {
            this.tm = rJaTableManager;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = this.getIdentifier(mouseEvent);
            if (object != null) {
                this.tm.getDataModel().thMouseClicked(mouseEvent, object);
            }
        }

        private Object getIdentifier(MouseEvent mouseEvent) {
            Object object = null;
            TableColumnModel tableColumnModel = ((JTableHeader)mouseEvent.getSource()).getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
            if (n >= 0 && n < tableColumnModel.getColumnCount()) {
                object = tableColumnModel.getColumn(n).getIdentifier();
            }
            return object;
        }
    }

    class BMouseAdapter
    extends MouseAdapter {
        private RJaTableManager tm;

        BMouseAdapter(RJaTableManager rJaTableManager) {
            this.tm = rJaTableManager;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = this.getIdentifier(mouseEvent);
            if (object != null) {
                this.tm.getDataModel().tbMouseClicked(mouseEvent, object);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object = this.getIdentifier(mouseEvent);
            if (object != null) {
                this.tm.getDataModel().tbMousePressed(mouseEvent, object);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = this.getIdentifier(mouseEvent);
            if (object != null) {
                this.tm.getDataModel().tbMouseReleased(mouseEvent, object);
            }
        }

        private Object getIdentifier(MouseEvent mouseEvent) {
            Object object = null;
            TableColumnModel tableColumnModel = ((JTable)mouseEvent.getSource()).getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getPoint().x);
            if (n >= 0 && n < tableColumnModel.getColumnCount()) {
                object = tableColumnModel.getColumn(n).getIdentifier();
            }
            return object;
        }
    }

    class InnerTableModel
    extends AbstractTableModel {
        private RJaTableManager tm;
        private JTable table = null;

        InnerTableModel(RJaTableManager rJaTableManager) {
            this.tm = rJaTableManager;
        }

        public void setTable(JTable jTable) {
            this.table = jTable;
        }

        public int getColumnCount() {
            TableColumnModel tableColumnModel;
            int n = 0;
            if (this.table != null && (tableColumnModel = this.table.getColumnModel()) != null) {
                n = tableColumnModel.getColumnCount();
            }
            return n;
        }

        public int getRowCount() {
            int n = 0;
            RJaTableDataModel rJaTableDataModel = this.tm.getDataModel();
            if (rJaTableDataModel != null) {
                n = rJaTableDataModel.getVisibleRowCount();
            }
            return n;
        }

        public String getColumnName(int n) {
            return (String)this.table.getColumnModel().getColumn(n).getIdentifier();
        }

        public Object getValueAt(int n, int n2) {
            int n3 = this.table.convertColumnIndexToView(n2);
            RJaTableDataModel rJaTableDataModel = this.tm.getDataModel();
            int n4 = rJaTableDataModel.convertRowIndexToModel(n);
            return rJaTableDataModel.getValueAt(n4, this.getColumnName(n3));
        }

        public Class getColumnClass(int n) {
            return ((RJaTableColumn)this.table.getColumnModel().getColumn(n)).getType().getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            n2 = this.table.convertColumnIndexToView(n2);
            boolean bl = ((RJaTableColumn)this.table.getColumnModel().getColumn(n2)).isEditable();
            bl = this.tm.getDataModel().isCellEditable(n, this.getColumnName(n2), bl);
            return bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            n2 = this.table.convertColumnIndexToView(n2);
            RJaTableDataModel rJaTableDataModel = this.tm.getDataModel();
            if (rJaTableDataModel != null) {
                rJaTableDataModel.setValueAt(n, this.getColumnName(n2), object);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }
}

