/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.data;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJcTabID;
import sanproject.client.com.RJcTabPolicy;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.serverux.dataimpl.DISKgetSubsystemInfo;

public class RJDataPolicyManager {
    private static RJDataPolicyManager pm = null;
    private RJDataControl dc = null;
    private RJcTabID objCurrentTabID;
    private RJcTabPolicy objCurrentTabPolicy;
    private DISKgetSubsystemInfo Subsystem;
    private static final String DIR_NAME = ".webconsole";
    private static final String DIR_PATH = System.getProperty("user.home") + File.separator + ".webconsole";
    private static final String FILE_EXTENSION = ".obj";
    private static final int L_SLEEPTIME = 10;

    public RJDataPolicyManager() {
        if (this.dc == null) {
            this.dc = RJDataControl.getDataControl();
        }
        this.objCurrentTabID = null;
        this.objCurrentTabPolicy = null;
    }

    public static RJDataPolicyManager getDCPolicyManager() {
        if (pm == null) {
            pm = new RJDataPolicyManager();
        }
        return pm;
    }

    public RJcTabID getCurrentTabID() {
        this.putLog("getCurrentTabID", "Call");
        return this.objCurrentTabID;
    }

    public void setCurrentTabID(RJcTabID rJcTabID) {
        this.putLog("setCurrentTabID", "Start");
        if (rJcTabID != null) {
            this.putLog("setCurrentTabID", "Set TabID[" + rJcTabID.toString() + "]", 0);
            this.objCurrentTabID = rJcTabID;
            this.objCurrentTabPolicy = this.getWorkTabPolicy();
        } else {
            this.putLog("setCurrentTabID", "ERROR [TabID >>> NULL]", 0);
        }
        this.putLog("setCurrentTabID", "End");
    }

    public RJcTabPolicy getTabPolicy() {
        this.putLog("getTabPolicy", "Start");
        if (this.objCurrentTabID != null) {
            this.putLog("getTabPolicy", "CurrentTabID[" + this.objCurrentTabID.toString() + "]", 0);
            Class clazz = this.objCurrentTabID.getPrivatePolicyClass();
            if (clazz != null) {
                if (this.objCurrentTabPolicy != null && !this.objCurrentTabPolicy.getClass().equals(clazz)) {
                    this.putLog("getTabPolicy", "CurrentTabPolicy >>> Mismatch!!!", 0);
                    this.objCurrentTabPolicy = null;
                }
                if (this.objCurrentTabPolicy == null) {
                    this.objCurrentTabPolicy = this.getWorkTabPolicy();
                }
            } else {
                this.putLog("getTabPolicy", "No PrivatePolicyClass", 0);
            }
        } else {
            this.putLog("getTabPolicy", "ERROR [TabID >>> NULL]", 0);
        }
        this.putLog("getTabPolicy", "End");
        return this.objCurrentTabPolicy;
    }

    public void setTabPolicy(RJcTabPolicy rJcTabPolicy) {
        this.putLog("setTabPolicy", "Call");
        this.objCurrentTabPolicy = rJcTabPolicy;
        this.putLog("getTabPolicy", "setTabPolicy[" + rJcTabPolicy.toString() + "]", 0);
    }

    public void writeTabPolicy() {
        this.putLog("writeTabPolicy", "Start");
        if (this.objCurrentTabID != null) {
            this.putLog("writeTabPolicy", "CurrentTabID[" + this.objCurrentTabID.toString() + "]", 0);
            String string = this.getPolicyFileName();
            String string2 = null;
            if (string != null && this.objCurrentTabPolicy != null) {
                string2 = this.getFilePath(DIR_PATH, string);
                this.putLog("writeTabPolicy", "File Saving...[" + string2 + "]", 0);
                if (!this.writeFile(string2, this.objCurrentTabPolicy)) {
                    this.putLog("writeTabPolicy", "File Save Error", 0);
                }
            } else {
                this.putLog("writeTabPolicy", "No CurrentTabPolicy", 0);
            }
        } else {
            this.putLog("writeTabPolicy", "ERROR [TabID >>> NULL]", 0);
        }
        this.putLog("writeTabPolicy", "End");
    }

    private RJcTabPolicy getWorkTabPolicy() {
        this.putLog("getWorkTabPolicy", "Start");
        RJcTabPolicy rJcTabPolicy = null;
        Class clazz = this.objCurrentTabID.getPrivatePolicyClass();
        if (clazz != null) {
            String string = this.getPolicyFileName();
            String string2 = null;
            if (string != null && this.chkFilePath(DIR_PATH, string)) {
                string2 = this.getFilePath(DIR_PATH, string);
                this.putLog("getWorkTabPolicy", "File Loading... [" + string2 + "]", 0);
                try {
                    rJcTabPolicy = (RJcTabPolicy)this.readFile(string2);
                }
                catch (ClassCastException classCastException) {
                    this.putLog("getWorkTabPolicy", "readFile ERROR [ClassCastException]", 0);
                }
            }
            if (rJcTabPolicy == null) {
                try {
                    rJcTabPolicy = (RJcTabPolicy)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    this.putLog("getWorkTabPolicy", "ERROR [InstantiationException]", 0);
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.putLog("getWorkTabPolicy", "ERROR [IllegalAccessException]", 0);
                }
                catch (ClassCastException classCastException) {
                    this.putLog("getWorkTabPolicy", "ERROR [ClassCastException]", 0);
                    System.out.println(classCastException);
                }
            }
        } else {
            this.putLog("getWorkTabPolicy", "No PrivatePolicyClass", 0);
        }
        this.putLog("getWorkTabPolicy", "End");
        return rJcTabPolicy;
    }

    private String getPolicyFileName() {
        this.putLog("getPolicyFileName", "Start");
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (this.objCurrentTabID != null) {
            string3 = this.objCurrentTabID.toString().replace('/', '-');
            Class clazz = this.objCurrentTabID.getPrivatePolicyClass();
            if (clazz != null) {
                string4 = clazz.getName();
                string5 = this.getDKCSerialNum();
            }
        }
        if (string3 != null && string4 != null && string5 != null) {
            string = string3 + "_" + string4 + "_" + string5 + FILE_EXTENSION;
        }
        if (string != null) {
            string2 = string.replaceAll("\\s", "");
        }
        this.putLog("getPolicyFileName", "End");
        return string2;
    }

    private String getFilePath(String string, String string2) {
        this.putLog("getFilePath", "Start");
        String string3 = null;
        if (string != null && string2 != null) {
            string3 = string + File.separator + string2;
        }
        this.putLog("getFilePath", "End");
        return string3;
    }

    private boolean chkFilePath(String string, String string2) {
        this.putLog("chkFilePath", "Start");
        boolean bl = false;
        if (string != null && string2 != null) {
            File file = new File(string, string2);
            if (file.exists()) {
                bl = true;
            } else {
                this.putLog("chkFilePath", "NO FILE[" + file.getAbsolutePath() + "]", 0);
            }
        }
        this.putLog("chkFilePath", "End");
        return bl;
    }

    private boolean writeFile(String string, Object object) {
        this.putLog("writeFile", "Start");
        boolean bl = false;
        try {
            if (string != null && object != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                fileOutputStream.close();
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.putLog("writeFile", "ERROR [FileNotFoundException]", 0);
        }
        catch (IOException iOException) {
            this.putLog("writeFile", "ERROR [IOException]", 0);
        }
        this.putLog("writeFile", "End");
        return bl;
    }

    private Object readFile(String string) {
        this.putLog("readFile", "Start");
        RJcTabPolicy rJcTabPolicy = null;
        try {
            if (string != null) {
                FileInputStream fileInputStream = new FileInputStream(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                rJcTabPolicy = (RJcTabPolicy)objectInputStream.readObject();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.putLog("readFile", "ERROR [FileNotFoundException]", 0);
        }
        catch (IOException iOException) {
            this.putLog("readFile", "ERROR [IOException]", 0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.putLog("readFile", "ERROR [ClassNotFoundException]", 0);
        }
        this.putLog("readFile", "End");
        return rJcTabPolicy;
    }

    private String getDKCSerialNum() {
        this.putLog("getDKCSerialNum", "Start");
        String string = null;
        if (this.Subsystem == null) {
            this.getSybsystem();
        }
        if (this.Subsystem != null) {
            int n = this.Subsystem.getNDKCSerialNumber();
            string = String.valueOf(n);
        }
        this.putLog("getDKCSerialNum", "End");
        return string;
    }

    private void getSybsystem() {
        this.putLog("getSybsystem", "Start");
        this.emptyWaitingDC();
        this.dc.getSubsystemInfo();
        boolean bl = this.finishWaitingDC(null);
        if (bl) {
            this.Subsystem = this.dc.getSubsystemClass();
        }
        this.putLog("getSybsystem", "End");
    }

    private void emptyWaitingDC() {
        RJDataControlDoing rJDataControlDoing = this.dc.getControlDoing();
        while (rJDataControlDoing.getDoing()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                this.putLog("emptyWaitingDC", "Thread Err InterruptedException", 0);
                interruptedException.printStackTrace();
            }
        }
    }

    private boolean finishWaitingDC(Component component) {
        boolean bl = true;
        this.dc.waitDC(component);
        ArrayList arrayList = this.dc.getEndStatus();
        int n = (Integer)arrayList.get(0);
        int n2 = (Integer)arrayList.get(1);
        if (n != 0) {
            this.putLog("finishWaitingDC", "EndStatus[+" + n + "," + n2 + "]", 0);
            bl = false;
        }
        return bl;
    }

    private void putLog(String string, String string2) {
        this.putLog(string, string2, 1);
    }

    private void putLog(String string, String string2, int n) {
        if (string != null && string2 != null) {
            RJCom.putLog(this.dc, "[DC]", "[PolicyM]", "[" + string + "]" + " " + string2, n);
        }
    }
}

