/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataException;
import sanproject.client.data.RJDataLDEVPart;
import sanproject.client.exdevice.data.CuIndexComparator;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.EmulationTypeInfo;
import sanproject.client.exdevice.data.EmulationTypeManager;
import sanproject.client.exdevice.data.LprManager;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.VolumeOperationDataControl;
import sanproject.common.Robj_interface_RJSetGettingParamLDEV;
import sanproject.common.Robj_interface_RJiCUIndex;
import sanproject.common.Robj_interface_RJiLDEVIndex;
import sanproject.common.Robj_interface_RJiLDEVInfoDetail;
import sanproject.common.Robj_interface_RJiPGIndex;
import sanproject.serversx.data.RJiCUIndex;
import sanproject.serverux.dataimpl.CVSgetLDEVIDInfo;
import sanproject.serverux.dataimpl.CVSgetLDEVIDInfo_IN;
import sanproject.serverux.dataimpl.CVSgetLDEVIDInfo_OUT;
import sanproject.serverux.dataimpl.RJSetGettingParamLDEV;
import sanproject.serverux.dataimpl.RJiLDEVIDInfo;
import sanproject.serverux.dataimpl.RJiLDEVInfoDetail;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class LdevManager
implements Singleton {
    private static final String LOG_NAME = "LdevManager";
    RJDataLDEVPart mLdevPart = RJDataControl.getDataControl().getLDEVPart();
    EmulationTypeManager mEmuTypeMan = EmulationTypeManager.getInstance();
    static RJSetGettingParamLDEV mLdevGetParam = new RJSetGettingParamLDEV();
    private int mNumOf3390_3 = 0;
    private int mNumOf3390_3R = 0;
    private boolean mflgExist3390_3 = false;
    private boolean mflgExist3390_3R = false;
    private static final int LDEV_BOUNDARY = 32;
    private static final int MAX_CU = 64;
    private static final int MAX_LDEV = 256;
    private int LDKC_COUNT_SUBSYSTEM = 0;
    private int CU_COUNT_SUBSYSTEM = 0;
    private Robj_interface_RJiCUIndex[] mCuIndexList = new Robj_interface_RJiCUIndex[0];
    private byte[][][] mBoundaryGroup;
    private int[][][] mLdevMap;
    private int[][][] mHpavMap;
    private static final byte BOUNDGRP_NA = -1;
    private static CuIndexComparator mCuIndexComparator;
    private static final byte ASSIGN_LDEV_NOUSED = -1;
    private static final byte ASSIGN_LDEV_ASSIGND = 0;
    private static final byte ASSIGN_LDEV_NONREST = 1;
    private static final byte ASSIGN_LDEV_REST = 2;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$LdevManager;

    LdevManager() {
    }

    public static LdevManager getInstance() {
        return (LdevManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$LdevManager == null ? (class$sanproject$client$exdevice$data$LdevManager = LdevManager.class$("sanproject.client.exdevice.data.LdevManager")) : class$sanproject$client$exdevice$data$LdevManager);
    }

    public void destroy() {
    }

    Robj_interface_RJiLDEVInfoDetail[] getLdevInfo(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray, RJSetGettingParamLDEV rJSetGettingParamLDEV) throws EXDException {
        Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray = null;
        if (robj_interface_RJiLDEVIndexArray != null && robj_interface_RJiLDEVIndexArray.length > 0) {
            try {
                robj_interface_RJiLDEVInfoDetailArray = this.mLdevPart.getLDEVInfoDetail(robj_interface_RJiLDEVIndexArray, (Robj_interface_RJSetGettingParamLDEV)rJSetGettingParamLDEV);
            }
            catch (RJDataException rJDataException) {
                throw new EXDException(rJDataException.getErrPart(), rJDataException.getErrCode());
            }
        }
        if (robj_interface_RJiLDEVInfoDetailArray == null) {
            robj_interface_RJiLDEVInfoDetailArray = new Robj_interface_RJiLDEVInfoDetail[]{};
        }
        return robj_interface_RJiLDEVInfoDetailArray;
    }

    public Robj_interface_RJiLDEVInfoDetail[] getLdevInfo(Robj_interface_RJiPGIndex robj_interface_RJiPGIndex) throws EXDException {
        Robj_interface_RJiLDEVInfoDetail[] robj_interface_RJiLDEVInfoDetailArray;
        Robj_interface_RJiPGIndex[] robj_interface_RJiPGIndexArray = new Robj_interface_RJiPGIndex[]{robj_interface_RJiPGIndex};
        try {
            Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray = this.mLdevPart.getLDEVIndex(robj_interface_RJiPGIndexArray);
            robj_interface_RJiLDEVInfoDetailArray = this.getLdevInfo(robj_interface_RJiLDEVIndexArray, mLdevGetParam);
        }
        catch (RJDataException rJDataException) {
            throw new EXDException(rJDataException.getErrPart(), rJDataException.getErrCode());
        }
        return robj_interface_RJiLDEVInfoDetailArray;
    }

    public byte getLdevStatus(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        return 0;
    }

    private final void subsystemExclutionCountUp(String string) {
        if ("3390-3".equals(string)) {
            if (++this.mNumOf3390_3 == 1 && !this.mflgExist3390_3) {
                this.mEmuTypeMan.addIgnoreAdaptiveType("3390-3R");
            }
        } else if ("3390-3R".equals(string) && ++this.mNumOf3390_3R == 1 && !this.mflgExist3390_3R) {
            this.mEmuTypeMan.addIgnoreAdaptiveType("3390-3");
        }
    }

    private final void subsystemExclutionCountDown(String string) {
        if ("3390-3".equals(string)) {
            if (--this.mNumOf3390_3 == 0 && !this.mflgExist3390_3) {
                this.mEmuTypeMan.removeIgnoreAdaptiveType("3390-3R");
            }
        } else if ("3390-3R".equals(string) && --this.mNumOf3390_3R == 0 && !this.mflgExist3390_3R) {
            this.mEmuTypeMan.removeIgnoreAdaptiveType("3390-3");
        }
    }

    void setExist3390_3(boolean bl) {
        this.mflgExist3390_3 = bl;
        if (bl) {
            this.mEmuTypeMan.addIgnoreAdaptiveType("3390-3R");
        }
    }

    void setExist3390_3R(boolean bl) {
        this.mflgExist3390_3R = bl;
        if (bl) {
            this.mEmuTypeMan.addIgnoreAdaptiveType("3390-3");
        }
    }

    private static int getLdevBitMask(int n) {
        return Integer.MIN_VALUE >>> n % 32;
    }

    private static int getBoundaryPoint(int n) {
        return n / 32;
    }

    public void initLdevMap() throws EXDException {
        int n;
        CVSgetLDEVIDInfo_IN cVSgetLDEVIDInfo_IN = new CVSgetLDEVIDInfo_IN();
        VolumeOperationDataControl volumeOperationDataControl = VolumeOperationDataControl.getInstance();
        CVSgetLDEVIDInfo_OUT cVSgetLDEVIDInfo_OUT = (CVSgetLDEVIDInfo_OUT)volumeOperationDataControl.comGet((SanRmiInputInterface)cVSgetLDEVIDInfo_IN);
        CVSgetLDEVIDInfo[] cVSgetLDEVIDInfoArray = cVSgetLDEVIDInfo_OUT.getDataObject();
        this.CU_COUNT_SUBSYSTEM = cVSgetLDEVIDInfoArray.length;
        if (this.CU_COUNT_SUBSYSTEM > 0) {
            CVSgetLDEVIDInfo cVSgetLDEVIDInfo = cVSgetLDEVIDInfoArray[this.CU_COUNT_SUBSYSTEM - 1];
            this.LDKC_COUNT_SUBSYSTEM = cVSgetLDEVIDInfo.getSLDKC() + 1;
        } else {
            this.LDKC_COUNT_SUBSYSTEM = 0;
        }
        this.mCuIndexList = new Robj_interface_RJiCUIndex[this.CU_COUNT_SUBSYSTEM];
        this.mBoundaryGroup = new byte[this.LDKC_COUNT_SUBSYSTEM][][];
        this.mLdevMap = new int[this.LDKC_COUNT_SUBSYSTEM][][];
        this.mHpavMap = new int[this.LDKC_COUNT_SUBSYSTEM][][];
        int n2 = 8;
        short s = 0;
        int n3 = this.CU_COUNT_SUBSYSTEM;
        while (n3 > 0) {
            n = n3;
            if (n3 > 64) {
                n = 64;
            }
            this.mBoundaryGroup[s] = new byte[n][n2];
            this.mLdevMap[s] = new int[n][n2];
            this.mHpavMap[s] = new int[n][n2];
            n3 -= 64;
            s = (short)(s + 1);
        }
        for (n2 = 0; n2 < this.CU_COUNT_SUBSYSTEM; ++n2) {
            byte by;
            int n4;
            s = cVSgetLDEVIDInfoArray[n2].getSLDKC();
            short s2 = cVSgetLDEVIDInfoArray[n2].getSCU();
            this.mCuIndexList[n2] = new RJiCUIndex();
            this.mCuIndexList[n2].setCUIndex(s, s2);
            RJiLDEVIDInfo[] rJiLDEVIDInfoArray = (RJiLDEVIDInfo[])cVSgetLDEVIDInfoArray[n2].getObjLDEVID();
            int n5 = rJiLDEVIDInfoArray.length;
            for (n = 0; n < n5; n += 32) {
                n4 = LdevManager.getBoundaryPoint(n);
                byte by2 = rJiLDEVIDInfoArray[n].getEmulationTypeGroup();
                for (int i = 0; i < 32; ++i) {
                    by = rJiLDEVIDInfoArray[n + i].getLDEVID();
                    if (by == -1) continue;
                    by2 = rJiLDEVIDInfoArray[n + i].getEmulationTypeGroup();
                    break;
                }
                this.mBoundaryGroup[s][s2][n4] = by2;
            }
            for (n = 0; n < n5; ++n) {
                by = rJiLDEVIDInfoArray[n].getLDEVID();
                if (by == 1 || by == 2) continue;
                n4 = LdevManager.getBoundaryPoint(n);
                int n6 = LdevManager.getLdevBitMask(n);
                int[] nArray = this.mLdevMap[s][s2];
                int n7 = n4;
                nArray[n7] = nArray[n7] | n6;
                if (by != -1) continue;
                int[] nArray2 = this.mHpavMap[s][s2];
                int n8 = n4;
                nArray2[n8] = nArray2[n8] | n6;
            }
        }
    }

    public boolean isUsebleLdev(short s, short s2, short s3, EmulationTypeInfo emulationTypeInfo) {
        int n;
        int n2;
        boolean bl = false;
        if (!this.chkLdevAdr(s, s2, s3)) {
            return bl;
        }
        if (emulationTypeInfo.isOpenType() && s > 0) {
            return bl;
        }
        int n3 = LdevManager.getBoundaryPoint(s3);
        byte by = this.mBoundaryGroup[s][s2][n3];
        int n4 = emulationTypeInfo.getGroup();
        if ((by == -1 || by == n4) && ((n2 = this.mLdevMap[s][s2][n3]) & (n = LdevManager.getLdevBitMask(s3))) == 0) {
            bl = true;
        }
        return bl;
    }

    void setLdevMap(short s, short s2, short s3, EmulationTypeInfo emulationTypeInfo) {
        int n;
        if (!this.chkLdevAdr(s, s2, s3)) {
            return;
        }
        int n2 = LdevManager.getBoundaryPoint(s3);
        byte by = this.mBoundaryGroup[s][s2][n2];
        if (by == -1) {
            n = emulationTypeInfo.getGroup();
            this.mBoundaryGroup[s][s2][n2] = (byte)n;
        }
        n = LdevManager.getLdevBitMask(s3);
        int[] nArray = this.mLdevMap[s][s2];
        int n3 = n2;
        nArray[n3] = nArray[n3] | n;
    }

    public void removeLdevMap(short s, short s2, short s3) {
        if (!this.chkLdevAdr(s, s2, s3)) {
            return;
        }
        int n = LdevManager.getBoundaryPoint(s3);
        int n2 = LdevManager.getLdevBitMask(s3);
        int[] nArray = this.mLdevMap[s][s2];
        int n3 = n;
        int n4 = nArray[n3] & ~n2;
        nArray[n3] = n4;
        int n5 = n4;
        if ((n5 ^= this.mHpavMap[s][s2][n]) == 0) {
            this.mBoundaryGroup[s][s2][n] = -1;
        }
    }

    public void removeLdevMap(Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex) {
        short s = robj_interface_RJiLDEVIndex.getSLDKC();
        short s2 = robj_interface_RJiLDEVIndex.getSCU();
        short s3 = robj_interface_RJiLDEVIndex.getSLDEV();
        this.removeLdevMap(s, s2, s3);
        robj_interface_RJiLDEVIndex.setLDEVIndex((short)-1, (short)-1, (short)-1);
    }

    public void removeLdevMap(Robj_interface_RJiLDEVIndex[] robj_interface_RJiLDEVIndexArray) {
        for (int i = 0; i < robj_interface_RJiLDEVIndexArray.length; ++i) {
            this.removeLdevMap(robj_interface_RJiLDEVIndexArray[i]);
        }
    }

    public boolean[] getUsableLdevMap(Robj_interface_RJiCUIndex robj_interface_RJiCUIndex, EmulationTypeInfo emulationTypeInfo) {
        boolean[] blArray = new boolean[256];
        short s = robj_interface_RJiCUIndex.getSLDKC();
        short s2 = robj_interface_RJiCUIndex.getSCU();
        for (short s3 = 0; s3 < 256; s3 = (short)(s3 + 1)) {
            blArray[s3] = this.isUsebleLdev(s, s2, s3, emulationTypeInfo);
        }
        return blArray;
    }

    public boolean setLdevId(RJiLDEVInfoDetail[] rJiLDEVInfoDetailArray, EmulationTypeInfo emulationTypeInfo, Robj_interface_RJiLDEVIndex robj_interface_RJiLDEVIndex, int n, short s, boolean bl) {
        int n2 = 0;
        Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray = this.getCuIndexList(s, bl);
        int n3 = Arrays.binarySearch(robj_interface_RJiCUIndexArray, robj_interface_RJiLDEVIndex, mCuIndexComparator);
        if (n3 < 0) {
            n3 = -(n3 + 1);
        }
        short s2 = robj_interface_RJiLDEVIndex.getSLDEV();
        int n4 = 0;
        while (n2 < rJiLDEVInfoDetailArray.length & n3 < robj_interface_RJiCUIndexArray.length) {
            Robj_interface_RJiCUIndex robj_interface_RJiCUIndex = robj_interface_RJiCUIndexArray[n3];
            short s3 = robj_interface_RJiCUIndex.getSLDKC();
            short s4 = robj_interface_RJiCUIndex.getSCU();
            while (n2 < rJiLDEVInfoDetailArray.length & s2 < 256) {
                boolean bl2 = this.isUsebleLdev(s3, s4, s2, emulationTypeInfo);
                if (bl2) {
                    if (n4 > 0) {
                        --n4;
                    } else {
                        this.setLdevMap(s3, s4, s2, emulationTypeInfo);
                        rJiLDEVInfoDetailArray[n2].setLDEVIndex(s3, s4, s2);
                        ++n2;
                        n4 = n;
                    }
                }
                s2 = (short)(s2 + 1);
            }
            s2 = 0;
            ++n3;
        }
        return n2 == rJiLDEVInfoDetailArray.length;
    }

    public Collection getLdkcList(int n, boolean bl) {
        ArrayList<Integer> arrayList;
        if (bl) {
            LprManager lprManager = LprManager.getInstance();
            arrayList = lprManager.getLdkcList(n);
        } else {
            arrayList = new ArrayList<Integer>(this.LDKC_COUNT_SUBSYSTEM);
            for (int i = 0; i < this.LDKC_COUNT_SUBSYSTEM; ++i) {
                arrayList.add(new Integer(i));
            }
        }
        return arrayList;
    }

    public Collection getCuList(int n, int n2, boolean bl) {
        ArrayList<Integer> arrayList;
        if (bl) {
            LprManager lprManager = LprManager.getInstance();
            arrayList = lprManager.getCuList(n2, n);
        } else {
            int n3 = 0;
            if (n < this.mBoundaryGroup.length) {
                n3 = this.mBoundaryGroup[n].length;
            }
            arrayList = new ArrayList<Integer>(n3);
            for (int i = 0; i < n3; ++i) {
                arrayList.add(new Integer(i));
            }
        }
        return arrayList;
    }

    public Robj_interface_RJiCUIndex[] getCuIndexList(int n, boolean bl) {
        Robj_interface_RJiCUIndex[] robj_interface_RJiCUIndexArray;
        if (bl) {
            LprManager lprManager = LprManager.getInstance();
            robj_interface_RJiCUIndexArray = lprManager.getCuListAtSlpr(n);
        } else {
            robj_interface_RJiCUIndexArray = this.mCuIndexList;
        }
        return robj_interface_RJiCUIndexArray;
    }

    public boolean chkLdevAdr(short s, short s2, short s3) {
        return s >= 0 && s < this.mBoundaryGroup.length && s2 >= 0 && s2 < this.mBoundaryGroup[s].length && s3 >= 0 && s3 < 256;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mLdevGetParam.setBBasic(true);
        mLdevGetParam.setBSize(true);
        mLdevGetParam.setBLUPath(true);
        mCuIndexComparator = new CuIndexComparator();
    }
}

