/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.data;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import sanproject.client.exdevice.data.EXDException;
import sanproject.client.exdevice.data.ExternalStatus;
import sanproject.client.exdevice.data.PathOperationDataControl;
import sanproject.client.exdevice.data.PhysicalPathInfo;
import sanproject.client.exdevice.data.PhysicalPathManager;
import sanproject.client.exdevice.data.PortManager;
import sanproject.client.exdevice.data.ProductInfo;
import sanproject.client.exdevice.data.ProductManager;
import sanproject.client.exdevice.data.Singleton;
import sanproject.client.exdevice.data.SingletonManager;
import sanproject.client.exdevice.data.TargetPortInfo;
import sanproject.client.exdevice.data.TargetPortManager;
import sanproject.client.exdevice.data.Utility;
import sanproject.common.Robj_interface_RJiPortIndex;
import sanproject.common.Robj_interface_RJiPortInfoDetail;
import sanproject.serverux.dataimpl.EXDPathStatus;
import sanproject.serverux.dataimpl.EXDPhysicalPathStatus;
import sanproject.serverux.dataimpl.EXDgetPathStatus_IN;
import sanproject.serverux.dataimpl.EXDgetPathStatus_OUT;
import sanproject.serverux.dataimpl.SanRmiInputInterface;

public class PathStatusManager
implements Singleton {
    protected static final String logName = "PathStatusManager";
    private static final Comparator PHYSICAL_PATH_COMP = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = this.getValue(object);
            int n2 = this.getValue(object2);
            return n - n2;
        }

        private int getValue(Object object) {
            int n;
            if (object instanceof EXDPathStatus) {
                n = ((EXDPathStatus)object).getId();
            } else if (object instanceof PhysicalPathInfo) {
                n = ((PhysicalPathInfo)object).getId();
            } else {
                throw new ClassCastException();
            }
            return n;
        }
    };
    static final EXDPathStatus NULL_OBJECT = new EXDPathStatus();
    private EXDPathStatus[] mPathStatus;
    static /* synthetic */ Class class$sanproject$client$exdevice$data$PathStatusManager;

    public static PathStatusManager getInstance() {
        return (PathStatusManager)SingletonManager.getInstance(class$sanproject$client$exdevice$data$PathStatusManager == null ? (class$sanproject$client$exdevice$data$PathStatusManager = PathStatusManager.class$("sanproject.client.exdevice.data.PathStatusManager")) : class$sanproject$client$exdevice$data$PathStatusManager);
    }

    PathStatusManager() {
    }

    public void destroy() {
    }

    void update() throws EXDException {
        Utility.putLog(logName, "Update PathStatus");
        long l = System.currentTimeMillis();
        boolean bl = PathOperationDataControl.getInstance().isGetStatus();
        this.mPathStatus = bl ? this.getPathStatus() : new EXDPathStatus[0];
        this.initPhysicalPathStatus();
        this.initTargetPortStatus();
        this.initPortInfoStatus();
        this.initProductStatus();
        long l2 = System.currentTimeMillis() - l;
        Utility.putLog(logName, "Update end. <Time = " + l2 + " ms>");
    }

    private EXDPathStatus[] getPathStatus() throws EXDException {
        Utility.putLog(logName, "    Start PhysicalPathStatus.");
        PathOperationDataControl pathOperationDataControl = PathOperationDataControl.getInstance();
        EXDgetPathStatus_IN eXDgetPathStatus_IN = new EXDgetPathStatus_IN();
        long l = System.currentTimeMillis();
        EXDgetPathStatus_OUT eXDgetPathStatus_OUT = (EXDgetPathStatus_OUT)pathOperationDataControl.comGet((SanRmiInputInterface)eXDgetPathStatus_IN);
        long l2 = System.currentTimeMillis();
        EXDPathStatus[] eXDPathStatusArray = eXDgetPathStatus_OUT.getStatus();
        if (eXDPathStatusArray == null) {
            Utility.putLog(logName, "        PathStatus : null");
            eXDPathStatusArray = new EXDPathStatus[]{};
        }
        Arrays.sort(eXDPathStatusArray, PHYSICAL_PATH_COMP);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    End PhysicalPathStatus. ");
        stringBuffer.append("<Time = ").append(l2 - l).append(" ms>");
        Utility.putLog(logName, stringBuffer.toString());
        return eXDPathStatusArray;
    }

    private void initPhysicalPathStatus() {
        long l = System.currentTimeMillis();
        PhysicalPathManager physicalPathManager = PhysicalPathManager.getInstance();
        Iterator iterator = physicalPathManager.getPhysicalPathInfo().iterator();
        while (iterator.hasNext()) {
            PhysicalPathInfo physicalPathInfo = (PhysicalPathInfo)iterator.next();
            EXDPathStatus eXDPathStatus = this.getStatus(physicalPathInfo);
            EXDPhysicalPathStatus eXDPhysicalPathStatus = eXDPathStatus.getPhysicalPathStatus();
            if (eXDPhysicalPathStatus == null) continue;
            physicalPathInfo.setStatus(eXDPhysicalPathStatus.getStatus());
        }
        long l2 = System.currentTimeMillis() - l;
        Utility.putLog(logName, "    Init PhysicalPathStatus <Time = " + l2 + " ms>");
    }

    private void initTargetPortStatus() {
        long l = System.currentTimeMillis();
        PhysicalPathManager physicalPathManager = PhysicalPathManager.getInstance();
        TargetPortManager targetPortManager = TargetPortManager.getInstance();
        BitSet bitSet = new BitSet();
        Iterator iterator = targetPortManager.getTargetPortList().iterator();
        while (iterator.hasNext()) {
            int n;
            TargetPortInfo targetPortInfo = (TargetPortInfo)iterator.next();
            bitSet.clear();
            PhysicalPathInfo[] physicalPathInfoArray = physicalPathManager.getPhysicalPathInfo(targetPortInfo);
            for (n = 0; n < physicalPathInfoArray.length; ++n) {
                bitSet.set(physicalPathInfoArray[n].getStatus());
            }
            n = ExternalStatus.getPrincipalStatus(bitSet);
            targetPortInfo.setStatus(n);
        }
        long l2 = System.currentTimeMillis() - l;
        Utility.putLog(logName, "    Init TargetPortStatus <Time = " + l2 + " ms>");
    }

    private void initPortInfoStatus() {
        long l = System.currentTimeMillis();
        PhysicalPathManager physicalPathManager = PhysicalPathManager.getInstance();
        PortManager portManager = PortManager.getInstance();
        BitSet bitSet = new BitSet();
        Robj_interface_RJiPortInfoDetail[] robj_interface_RJiPortInfoDetailArray = portManager.getPortInfo();
        for (int i = 0; i < robj_interface_RJiPortInfoDetailArray.length; ++i) {
            int n;
            Robj_interface_RJiPortInfoDetail robj_interface_RJiPortInfoDetail = robj_interface_RJiPortInfoDetailArray[i];
            bitSet.clear();
            PhysicalPathInfo[] physicalPathInfoArray = physicalPathManager.getPhysicalPathInfoAll((Robj_interface_RJiPortIndex)robj_interface_RJiPortInfoDetail);
            for (n = 0; n < physicalPathInfoArray.length; ++n) {
                bitSet.set(physicalPathInfoArray[n].getStatus());
            }
            n = ExternalStatus.getPrincipalStatus(bitSet);
            portManager.setStatus((Robj_interface_RJiPortIndex)robj_interface_RJiPortInfoDetail, n);
        }
        long l2 = System.currentTimeMillis() - l;
        Utility.putLog(logName, "    Init PortInfoStatus <Time = " + l2 + " ms>");
    }

    private void initProductStatus() {
        long l = System.currentTimeMillis();
        ProductManager productManager = ProductManager.getInstance();
        TargetPortManager targetPortManager = TargetPortManager.getInstance();
        BitSet bitSet = new BitSet();
        ProductInfo[] productInfoArray = productManager.getProductInfo();
        for (int i = 0; i < productInfoArray.length; ++i) {
            int n;
            ProductInfo productInfo = productInfoArray[i];
            bitSet.clear();
            TargetPortInfo[] targetPortInfoArray = targetPortManager.getTargetPortList(productInfo);
            for (n = 0; n < targetPortInfoArray.length; ++n) {
                bitSet.set(targetPortInfoArray[n].getStatus());
            }
            n = ExternalStatus.getPrincipalStatus(bitSet);
            productInfo.setStatus(n);
        }
        long l2 = System.currentTimeMillis() - l;
        Utility.putLog(logName, "    Init ProductStatus <Time = " + l2 + " ms>");
    }

    private EXDPathStatus getStatus(PhysicalPathInfo physicalPathInfo) {
        EXDPathStatus eXDPathStatus = NULL_OBJECT;
        int n = Arrays.binarySearch(this.mPathStatus, physicalPathInfo, PHYSICAL_PATH_COMP);
        if (n >= 0) {
            eXDPathStatus = this.mPathStatus[n];
        }
        return eXDPathStatus;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

