/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.exdevice.pathoperation;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDef;
import sanproject.client.com.RJcElement;
import sanproject.client.com.RJcMenuAction;
import sanproject.client.com.RJcPopupMenu;
import sanproject.client.data.RJDataControl;
import sanproject.client.exdevice.com.AbstractTableDataModel;
import sanproject.client.exdevice.com.DialogContentsPanel;
import sanproject.client.exdevice.com.Operation;
import sanproject.client.exdevice.com.TableColumnInfo;
import sanproject.client.exdevice.data.PresetManager;
import sanproject.client.exdevice.pathoperation.ChangeWWNParameterPanel;
import sanproject.client.exdevice.pathoperation.DeviceStatusColumnInfo;
import sanproject.client.exdevice.pathoperation.ExternalProductElement;
import sanproject.client.exdevice.pathoperation.FibreTargetPortElement;
import sanproject.client.exdevice.pathoperation.IOTOVColumnInfo;
import sanproject.client.exdevice.pathoperation.LocalGuidance;
import sanproject.client.exdevice.pathoperation.LocalOperation;
import sanproject.client.exdevice.pathoperation.PathWatchColumnInfo;
import sanproject.client.exdevice.pathoperation.QDepthColumnInfo;
import sanproject.client.exdevice.pathoperation.TargetPortColumnInfo;

public class FibreTargetPortTableDataModel
extends AbstractTableDataModel {
    private TableColumnInfo[] headers;
    private RJcMenuAction disconnectPathsAction;
    private RJcMenuAction checkPathsAction;
    private RJcMenuAction changeParamAction;
    private ExternalProductElement product;

    public FibreTargetPortTableDataModel(ExternalProductElement externalProductElement) {
        this.product = externalProductElement;
        String string = LocalGuidance.MENU_DISCONNECTPATHS.getItemID();
        this.disconnectPathsAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_Path]", "FibreTargetDataModel", "[FibreTargetDataModel] Disconnect Paths.", 0);
                FibreTargetPortTableDataModel.this.onSelectDisconnectPaths(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = LocalGuidance.MENU_CHECKPATHS.getItemID();
        this.checkPathsAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_Path]", "FibreTargetDataModel", "[FibreTargetDataModel] Check Paths.", 0);
                FibreTargetPortTableDataModel.this.onSelectCheckPaths(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        string = LocalGuidance.MENU_CHANGEWWNPARAMETER.getItemID();
        this.changeParamAction = new RJcMenuAction(string){

            public void actionPerformed(ActionEvent actionEvent) {
                RJCom.putLog(RJDataControl.getDataControl(), "[ExDevice_Path]", "FibreTargetDataModel", "[FibreTargetDataModel] Change Parameter.", 0);
                FibreTargetPortTableDataModel.this.onSelectChangeParameter(actionEvent);
            }

            public String toString() {
                String string = (String)this.getValue("Name");
                return string;
            }
        };
        this.setAutoResizeMode(0);
    }

    public TableColumnInfo[] getColumnInfos() {
        if (this.headers == null) {
            this.headers = new TableColumnInfo[]{new TargetPortColumnInfo(), new QDepthColumnInfo(), new IOTOVColumnInfo(), new PathWatchColumnInfo(), new DeviceStatusColumnInfo()};
        }
        TableColumnInfo[] tableColumnInfoArray = this.headers;
        return tableColumnInfoArray;
    }

    public FibreTargetPortElement[] getSelectedFibreTargetPortElements() {
        int[] nArray = this.getSelectedRows();
        FibreTargetPortElement[] fibreTargetPortElementArray = this.getFibreTargetPortElements(nArray);
        return fibreTargetPortElementArray;
    }

    public FibreTargetPortElement[] getFibreTargetPortElements(int[] nArray) {
        RJcElement[] rJcElementArray = this.getElements(nArray);
        int n = rJcElementArray.length;
        ArrayList<RJcElement> arrayList = new ArrayList<RJcElement>();
        arrayList.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            RJcElement rJcElement = rJcElementArray[i];
            if (!(rJcElement instanceof FibreTargetPortElement)) continue;
            arrayList.add(rJcElement);
        }
        FibreTargetPortElement[] fibreTargetPortElementArray = new FibreTargetPortElement[]{};
        fibreTargetPortElementArray = arrayList.toArray(fibreTargetPortElementArray);
        return fibreTargetPortElementArray;
    }

    protected JPopupMenu createPopupMenu() {
        RJcPopupMenu rJcPopupMenu = null;
        this.updateActionsStatus();
        RJcMenuAction[] rJcMenuActionArray = new RJcMenuAction[]{this.disconnectPathsAction, this.checkPathsAction, new RJcMenuAction(), this.changeParamAction};
        rJcPopupMenu = new RJcPopupMenu(rJcMenuActionArray);
        return rJcPopupMenu;
    }

    private void updateActionsStatus() {
        PresetManager presetManager;
        boolean bl;
        boolean bl2 = bl = FibreTargetPortTableDataModel.isEditable(13, 1);
        boolean bl3 = bl;
        boolean bl4 = bl;
        FibreTargetPortElement[] fibreTargetPortElementArray = this.getSelectedFibreTargetPortElements();
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl2 = Operation.isPossibleTo(presetManager, LocalOperation.DISCONNECT_PATHS) ? this.product.canDisconnectPaths(fibreTargetPortElementArray) : false;
        }
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl3 = Operation.isPossibleTo(presetManager, LocalOperation.CHECK_PATHS) ? this.product.canCheckPaths(fibreTargetPortElementArray) : false;
        }
        if (bl) {
            presetManager = PresetManager.getInstance();
            bl4 = Operation.isPossibleTo(presetManager, LocalOperation.CHANGE_PARAMETER) ? this.product.canChangeParameters(fibreTargetPortElementArray) : false;
        }
        this.disconnectPathsAction.setEnabled(bl2);
        this.checkPathsAction.setEnabled(bl3);
        this.changeParamAction.setEnabled(bl4);
    }

    private void onSelectDisconnectPaths(ActionEvent actionEvent) {
        FibreTargetPortElement[] fibreTargetPortElementArray = this.getSelectedFibreTargetPortElements();
        this.product.requestDisconnectPaths(fibreTargetPortElementArray);
    }

    private void onSelectCheckPaths(ActionEvent actionEvent) {
        FibreTargetPortElement[] fibreTargetPortElementArray = this.getSelectedFibreTargetPortElements();
        this.product.requestCheckPaths(fibreTargetPortElementArray);
    }

    private void onSelectChangeParameter(ActionEvent actionEvent) {
        int n;
        FibreTargetPortElement[] fibreTargetPortElementArray = this.getSelectedFibreTargetPortElements();
        if (fibreTargetPortElementArray != null && (n = fibreTargetPortElementArray.length) > 0) {
            JFrame jFrame = this.getPopupMenuOwnerFrame(actionEvent);
            ChangeWWNParameterPanel changeWWNParameterPanel = new ChangeWWNParameterPanel();
            int n2 = fibreTargetPortElementArray[0].getIOTOV();
            int n3 = fibreTargetPortElementArray[0].getQDepth();
            int n4 = fibreTargetPortElementArray[0].getPathWatch();
            if (n != 1) {
                for (int i = 0; i < n; ++i) {
                    if (n2 != fibreTargetPortElementArray[i].getIOTOV()) {
                        n2 = -1;
                    }
                    if (n3 != fibreTargetPortElementArray[i].getQDepth()) {
                        n3 = -1;
                    }
                    if (n4 != fibreTargetPortElementArray[i].getPathWatch()) {
                        n4 = -1;
                    }
                    if (n2 == -1 && n3 == -1 && n4 == -1) break;
                }
            }
            changeWWNParameterPanel.setInitializedValues(n2, n3, n4);
            JDialog jDialog = changeWWNParameterPanel.createDialogWindow(jFrame, RJComDef.DlgTitle);
            jDialog.setVisible(true);
            DialogContentsPanel.DialogState dialogState = changeWWNParameterPanel.getDialogStatus();
            if (dialogState.equals(DialogContentsPanel.APPLY_STATUS)) {
                int n5 = changeWWNParameterPanel.getIOTOV();
                int n6 = changeWWNParameterPanel.getQDepth();
                int n7 = changeWWNParameterPanel.getPathWatch();
                this.product.requestChangeWWNParameters(fibreTargetPortElementArray, n5, n6, n7);
                for (int i = 0; i < n; ++i) {
                    this.updateRow(fibreTargetPortElementArray[i]);
                }
            }
        }
    }
}

