/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.hpav.com;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Window;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.JPanel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComDialog;
import sanproject.client.com.RJComFuncPanel;
import sanproject.client.com.RJComPanel;
import sanproject.client.data.RJDataChange;
import sanproject.client.data.RJDataControl;
import sanproject.client.data.RJDataControlDoing;
import sanproject.client.data.RJDataMsg;
import sanproject.client.hpav.com.RJPavConstants;
import sanproject.client.hpav.com.RJPavException;
import sanproject.client.hpav.com.RJPavGuidance;

public abstract class RJPavAbstractDataSupplier
implements RJPavConstants {
    protected RJDataControl controller;
    protected RJDataControlDoing controlDoing;
    private Stack parentPanel = new Stack();
    private Window window = null;
    private RJPavGuidance guidance;
    private boolean editMode = false;

    public RJPavAbstractDataSupplier() {
        this(null);
    }

    public RJPavAbstractDataSupplier(RJDataControl rJDataControl) {
        this.controller = rJDataControl;
        if (rJDataControl != null) {
            this.controlDoing = rJDataControl.getControlDoing();
        }
        this.guidance = new RJPavGuidance(this);
    }

    public void init() throws RJPavException {
    }

    public RJDataControl getDataControl() {
        return this.controller;
    }

    public RJDataChange getChangeTbl() {
        return this.controller.GetChangeTbl();
    }

    public void waitCursor() {
        this.waitCursor(this.getParentPanel());
    }

    public void waitCursor(Component component) {
        component.setCursor(new Cursor(3));
        this.window = this.searchWindow(component);
        if (this.window != null) {
            Graphics graphics = this.window.getGraphics();
            this.window.paintAll(graphics);
            this.window.setEnabled(false);
        }
    }

    public void defaultCursor() {
        this.defaultCursor(this.getParentPanel());
    }

    public void defaultCursor(Component component) {
        component.setCursor(new Cursor(0));
        if (this.window != null) {
            this.window.setEnabled(true);
            this.window = null;
        }
    }

    public Window searchWindow(Component component) {
        Window window = null;
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Window)) continue;
            window = (Window)component2;
            break;
        }
        return window;
    }

    public JPanel getParentPanel() {
        JPanel jPanel = null;
        try {
            jPanel = (JPanel)this.parentPanel.peek();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return jPanel;
    }

    public void pushParentPanel(JPanel jPanel) {
        this.parentPanel.push(jPanel);
    }

    public void popParentPanel() {
        try {
            this.parentPanel.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    public RJPavGuidance getGuidance() {
        return this.guidance;
    }

    public boolean getEditMode() {
        boolean bl = this.editMode;
        if (this.controller != null) {
            bl = RJCom.getEditMode(this.controller);
        }
        return bl;
    }

    public boolean cancel() {
        this.waitControl();
        this.controller.Cancel();
        return true;
    }

    public void putLog(String string, String string2, String string3) {
        this.putLog(string, string2, string3, 0);
    }

    public void putLog(String string, String string2, String string3, int n) {
        if (this.controller != null) {
            RJCom.putLog(this.controller, string, string2, string3, n);
        }
        System.out.println(string + " " + string2 + " " + string3);
    }

    public static String toHexString(int n, int n2) {
        String string = "0000000" + Integer.toHexString(n).toUpperCase();
        return string.substring(string.length() - n2);
    }

    protected void confirm() throws RJPavException {
        this.confirm("unknown");
    }

    protected void confirm(String string, boolean bl) throws RJPavException {
        if (!bl) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.confirm(string + " ver=" + bl);
    }

    protected void confirm(String string) throws RJPavException {
        long l = System.currentTimeMillis();
        this.controller.waitDC();
        long l2 = System.currentTimeMillis() - l;
        ArrayList arrayList = this.controller.getEndStatus();
        if ((Integer)arrayList.get(0) != 0) {
            RJDataMsg rJDataMsg = this.getMessage(arrayList);
            RJPavException rJPavException = new RJPavException(rJDataMsg.getMessage());
            Object[] objectArray = new Object[]{"OK"};
            RJComDialog.show(this.getParentPanel(), rJDataMsg, 0, objectArray, objectArray[0]);
            int n = rJDataMsg.getErrorLevel();
            RJComFuncPanel rJComFuncPanel = (RJComFuncPanel)this.getParentPanel();
            rJComFuncPanel.endRequest(n);
            throw rJPavException;
        }
        this.putLog("[Supplier]", "[confirm]", string + " : wait=" + l2 + "ms");
    }

    protected void waitControl() {
        while (this.controlDoing.getDoing()) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected RJDataMsg getMessage(ArrayList arrayList) {
        RJDataMsg rJDataMsg = RJCom.getMsg(this.controller, (Integer)arrayList.get(0), (Integer)arrayList.get(1));
        return rJDataMsg;
    }

    public RJDataMsg getMessage(int n) {
        return RJCom.getMsg(this.controller, n / 100000, n % 100000);
    }

    public int getVenderID() {
        int n = 0;
        if (this.controller != null) {
            n = this.controller.getStartParamClass().getVenderID();
        }
        return n;
    }

    public boolean isTabOption(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPermission(int n, int n2) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getStartParamClass().getPermissionTABOption(n, n2);
        }
        return bl;
    }

    public boolean isPP(String string) {
        boolean bl = true;
        if (this.controller != null) {
            bl = this.controller.getPPKeyData().CheckPP(string);
        }
        return bl;
    }

    public void terminate() {
        if (this.guidance != null) {
            this.guidance.terminate();
        }
    }

    public void setEditMode(boolean bl) {
        this.editMode = bl;
    }

    public boolean paraChkSts() {
        return true;
    }

    public int paraApply(RJComPanel rJComPanel) {
        return 0;
    }

    public boolean paraCancel() {
        return true;
    }

    public void paraShowApplyEndMsg() {
    }

    public void restoreData() {
        this.controller.APCustom_restoreSetList();
        this.controller.APCustom_clearBackupSetList();
        this.controller.restorePAVsetObject();
    }
}

