/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.monitor.performance;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sanproject.client.com.RJcGuide;
import sanproject.client.com.RJcHeaderPanel;
import sanproject.client.com.abs.RJaChangeListener;
import sanproject.client.monitor.com.RJHihDataSupplier;
import sanproject.client.monitor.com.RJHihDateFormat;
import sanproject.client.monitor.com.RJHihMonitoringInfo;
import sanproject.client.monitor.com.RJHihPanel;
import sanproject.client.monitor.com.RJHihSpinDateField;
import sanproject.client.monitor.performance.RJHihMonitoringSWView;

public class RJHihMonitoringTermPanel
extends RJHihPanel {
    private static final RJHihDateFormat yyyyMMddHHmmForm = new RJHihDateFormat("yyyy/MM/dd HH:mm");
    private static final RJHihDateFormat yyyyMMddForm = new RJHihDateFormat("yyyy/MM/dd");
    private static final RJHihDateFormat HHmmForm = new RJHihDateFormat("HH:mm");
    private static final long OneDay = 86400000L;
    private BorderLayout thisLayout = new BorderLayout();
    private RJcHeaderPanel headerPanel = new RJcHeaderPanel();
    private JPanel centerPanel = new JPanel();
    private JButton applyButton;
    private Vector listeners = new Vector(5);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private Border border1;
    private JLabel fromLabel = new JLabel();
    private JLabel toLabel = new JLabel();
    private JLabel daysLabel = new JLabel();
    private RJHihSpinDateField fromSpinField = new RJHihSpinDateField();
    private RJHihSpinDateField toSpinField = new RJHihSpinDateField();
    private JSlider fromSlider = new JSlider();
    private JSlider toSlider = new JSlider();
    private JLabel fromSliderLabel = new JLabel();
    private JLabel toSliderLabel = new JLabel();
    private JPanel startLabelPanel = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel startLabelNorth = new JLabel();
    private JLabel startLabelCenter = new JLabel();
    private JPanel endLabelPanel = new JPanel();
    private JLabel endLabelNorth = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JLabel endLabelCenter = new JLabel();
    private JRadioButton fromRadioButton = new JRadioButton();
    private JRadioButton realtimeRadioButton = new JRadioButton();
    private JPanel realtimePanel = new JPanel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JComboBox realtimeComboBox = new JComboBox();
    private ButtonGroup group = new ButtonGroup();
    private boolean fromSliderEvent = false;
    private boolean fromSliderEnable = true;
    private boolean toSliderEvent = false;
    private boolean toSliderEnable = true;
    private long spinTickSpacing = 1L;
    private long sliderTickSpacing = 1L;
    private long labelTickSpacing = 1L;
    private RJHihMonitoringSWView viewPanel = null;

    public RJHihMonitoringTermPanel() {
        super((RJHihDataSupplier)null);
    }

    public RJHihMonitoringTermPanel(RJHihDataSupplier rJHihDataSupplier) {
        super(rJHihDataSupplier);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        this.setLayout(this.thisLayout);
        this.setOpaque(false);
        this.setMinimumSize(new Dimension(300, 100));
        this.setPreferredSize(new Dimension(300, 100));
        this.thisLayout.setHgap(4);
        this.thisLayout.setVgap(4);
        this.headerPanel.setHeader("PerformanceManagement/MonitoringTermTitle");
        this.centerPanel.setLayout(this.gridBagLayout1);
        this.centerPanel.setBorder(this.border1);
        this.centerPanel.setBackground(RJcGuide.color("PerformanceManagement/MonitoringTermPanelBgClr"));
        this.fromSpinField.setBackground(Color.white);
        this.fromSpinField.addChangeListener(new RJaChangeListener(){

            public void valueChanged(Date date) {
                RJHihMonitoringTermPanel.this.from_valueChanged(date);
            }
        });
        this.toSpinField.setBackground(Color.white);
        this.toSpinField.addChangeListener(new RJaChangeListener(){

            public void valueChanged(Date date) {
                RJHihMonitoringTermPanel.this.to_valueChanged(date);
            }
        });
        this.fromSliderLabel.setFont(new Font("Dialog", 0, 10));
        this.fromSliderLabel.setText(RJcGuide.text("PerformanceManagement/FromBarLbl"));
        this.fromSliderLabel.setForeground(RJcGuide.color("PerformanceManagement/FromBarLbl"));
        this.toSliderLabel.setFont(new Font("Dialog", 0, 10));
        this.toSliderLabel.setText(RJcGuide.text("PerformanceManagement/ToBarLbl"));
        this.toSliderLabel.setForeground(RJcGuide.color("PerformanceManagement/ToBarLbl"));
        this.startLabelPanel.setLayout(this.borderLayout1);
        this.startLabelPanel.setOpaque(false);
        this.startLabelNorth.setForeground(RJcGuide.color("PerformanceManagement/StartLbl"));
        this.startLabelCenter.setForeground(RJcGuide.color("PerformanceManagement/StartLbl"));
        this.endLabelPanel.setLayout(this.borderLayout2);
        this.endLabelPanel.setOpaque(false);
        this.endLabelNorth.setForeground(RJcGuide.color("PerformanceManagement/EndLbl"));
        this.endLabelCenter.setForeground(RJcGuide.color("PerformanceManagement/EndLbl"));
        this.daysLabel.setMinimumSize(new Dimension(120, 21));
        this.daysLabel.setPreferredSize(new Dimension(120, 21));
        this.daysLabel.setHorizontalAlignment(4);
        this.fromSlider.setPreferredSize(new Dimension(180, 24));
        this.fromSlider.setMinimumSize(new Dimension(180, 24));
        this.fromSlider.setOpaque(false);
        this.fromSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RJHihMonitoringTermPanel.this.fromSlider.isEnabled()) {
                    RJHihMonitoringTermPanel.this.fromSlider_stateChanged(changeEvent);
                }
            }
        });
        this.toSlider.setPreferredSize(new Dimension(180, 24));
        this.toSlider.setMinimumSize(new Dimension(180, 24));
        this.toSlider.setOpaque(false);
        this.toSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (RJHihMonitoringTermPanel.this.toSlider.isEnabled()) {
                    RJHihMonitoringTermPanel.this.toSlider_stateChanged(changeEvent);
                }
            }
        });
        this.fromLabel.setText(RJcGuide.text("PerformanceManagement/FromLbl"));
        this.fromLabel.setForeground(RJcGuide.color("PerformanceManagement/FromLbl"));
        this.toLabel.setText(RJcGuide.text("PerformanceManagement/ToLbl"));
        this.toLabel.setForeground(RJcGuide.color("PerformanceManagement/ToLbl"));
        this.applyButton = this.newButton("PerformanceManagement/ApplyBtn");
        this.applyButton.setMinimumSize(new Dimension(60, 24));
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJHihMonitoringTermPanel.this.applyButton_actionPerformed(actionEvent);
            }
        });
        this.centerPanel.add((Component)this.fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.fromSpinField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.toSpinField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.startLabelPanel, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.centerPanel.add((Component)this.fromSlider, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 8, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.fromSliderLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.toSlider, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 8, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.toSliderLabel, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.startLabelPanel.add((Component)this.startLabelNorth, "North");
        this.startLabelPanel.add((Component)this.startLabelCenter, "Center");
        this.centerPanel.add((Component)this.endLabelPanel, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.endLabelPanel.add((Component)this.endLabelNorth, "North");
        this.endLabelPanel.add((Component)this.endLabelCenter, "Center");
        this.centerPanel.add((Component)this.toLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.daysLabel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.centerPanel.add((Component)this.applyButton, new GridBagConstraints(4, 2, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.centerPanel, "Center");
    }

    public void init() {
        RJHihMonitoringInfo rJHihMonitoringInfo = this.supplier.getMonitoringInfo();
        if (rJHihMonitoringInfo != null && rJHihMonitoringInfo.getStartTime() != null && rJHihMonitoringInfo.getEndTime() != null) {
            this.initComponents(rJHihMonitoringInfo);
        } else {
            this.disableComponents();
        }
        if (this.viewPanel != null) {
            this.viewPanel.init();
        }
    }

    public void init(boolean bl) {
        this.init();
        if (!bl) {
            this.disableComponents();
        }
    }

    private void initComponents(RJHihMonitoringInfo rJHihMonitoringInfo) {
        this.startLabelNorth.setText(yyyyMMddForm.format(rJHihMonitoringInfo.getStartTime()));
        this.startLabelNorth.setEnabled(true);
        this.startLabelCenter.setText(HHmmForm.format(rJHihMonitoringInfo.getStartTime()));
        this.startLabelCenter.setEnabled(true);
        this.endLabelNorth.setText(yyyyMMddForm.format(rJHihMonitoringInfo.getEndTime()));
        this.endLabelNorth.setEnabled(true);
        this.endLabelCenter.setText(HHmmForm.format(rJHihMonitoringInfo.getEndTime()));
        this.endLabelCenter.setEnabled(true);
        this.spinTickSpacing = (long)rJHihMonitoringInfo.getSpinTickSpacing() * 60L * 1000L;
        this.sliderTickSpacing = (long)rJHihMonitoringInfo.getSliderTickSpacing() * 60L * 1000L;
        this.labelTickSpacing = (long)rJHihMonitoringInfo.getLabelTickSpacing() * 60L * 1000L;
        this.daysLabel.setEnabled(true);
        Date date = rJHihMonitoringInfo.getEndTime();
        date.setTime(date.getTime() - this.spinTickSpacing);
        this.fromSpinField.init(rJHihMonitoringInfo.getStartTime(), date, rJHihMonitoringInfo.getFromTime(), rJHihMonitoringInfo.getSpinTickSpacing());
        Date date2 = rJHihMonitoringInfo.getStartTime();
        date2.setTime(date2.getTime() + this.spinTickSpacing);
        this.toSpinField.init(date2, rJHihMonitoringInfo.getEndTime(), rJHihMonitoringInfo.getToTime(), rJHihMonitoringInfo.getSpinTickSpacing());
        int n = (int)((rJHihMonitoringInfo.getEndTime().getTime() - rJHihMonitoringInfo.getStartTime().getTime() - this.spinTickSpacing + this.sliderTickSpacing - 1L) / this.sliderTickSpacing);
        this.fromSliderEnable = false;
        this.fromSlider.setMaximum(n);
        this.fromSlider.setMinimum(0);
        this.setSliderValue(this.fromSlider, rJHihMonitoringInfo.getStartTime(), rJHihMonitoringInfo.getFromTime());
        this.fromSliderEnable = true;
        this.toSliderEnable = false;
        this.toSlider.setMaximum(n);
        this.toSlider.setMinimum(0);
        this.setSliderValue(this.toSlider, date2, rJHihMonitoringInfo.getToTime());
        this.toSliderEnable = true;
        this.setLabelValue(rJHihMonitoringInfo.getFromTime(), rJHihMonitoringInfo.getToTime());
        this.fromLabel.setEnabled(true);
        this.toLabel.setEnabled(true);
        this.realtimeRadioButton.setSelected(rJHihMonitoringInfo.getMode() == 1);
        this.setEnabledByRadioButton(rJHihMonitoringInfo.getMode() == 0);
        this.applyButton.setEnabled(true);
    }

    private void disableComponents() {
        this.startLabelNorth.setText("0000/00/00");
        this.startLabelNorth.setEnabled(false);
        this.startLabelCenter.setText("00:00");
        this.startLabelCenter.setEnabled(false);
        this.endLabelNorth.setText("0000/00/00");
        this.endLabelNorth.setEnabled(false);
        this.endLabelCenter.setText("00:00");
        this.endLabelCenter.setEnabled(false);
        this.fromLabel.setEnabled(false);
        this.toLabel.setEnabled(false);
        this.daysLabel.setText(null);
        this.daysLabel.setEnabled(false);
        this.fromSpinField.init(null, null, null, 0);
        this.toSpinField.init(null, null, null, 0);
        this.toSpinField.setEnabled(false);
        this.fromSlider.setEnabled(false);
        this.fromSlider.setValue(0);
        this.toSlider.setEnabled(false);
        this.toSlider.setValue(0);
        this.applyButton.setEnabled(false);
    }

    public void addListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    private void from_valueChanged(Date date) {
        Date date2;
        if (!this.fromSliderEvent) {
            this.fromSliderEnable = false;
            this.setSliderValue(this.fromSlider, this.fromSpinField.getStartTime(), date);
            this.fromSliderEnable = true;
        }
        if ((date2 = this.toSpinField.getTime()) != null) {
            Date date3 = (Date)date.clone();
            date3.setTime(date.getTime() + this.spinTickSpacing);
            if (date3.compareTo(date2) > 0) {
                this.toSpinField.setTime(date3);
            }
            this.setLabelValue(date, this.toSpinField.getTime());
        }
    }

    private void to_valueChanged(Date date) {
        Date date2;
        if (!this.toSliderEvent) {
            this.setSliderValue(this.toSlider, this.toSpinField.getStartTime(), date);
        }
        if ((date2 = this.fromSpinField.getTime()) != null) {
            Date date3 = (Date)date.clone();
            date3.setTime(date.getTime() - this.spinTickSpacing);
            if (date3.compareTo(date2) < 0) {
                this.fromSpinField.setTime(date3);
            }
            this.setLabelValue(this.fromSpinField.getTime(), date);
        }
    }

    public void setLabelValue(Date date, Date date2) {
        int n = (int)((date2.getTime() - date.getTime() + this.labelTickSpacing - 1L) / this.labelTickSpacing);
        String string = null;
        Color color = null;
        if (this.labelTickSpacing / 60000L == 1440L) {
            string = RJcGuide.text("PerformanceManagement/Days");
            color = RJcGuide.color("PerformanceManagement/Days");
        } else {
            string = RJcGuide.text("PerformanceManagement/Minutes");
            color = RJcGuide.color("PerformanceManagement/Minutes");
        }
        this.daysLabel.setText(Integer.toString(n) + string);
        this.daysLabel.setForeground(color);
    }

    public void setSliderValue(JSlider jSlider, Date date, Date date2) {
        int n = (int)((date2.getTime() - date.getTime() + this.sliderTickSpacing - 1L) / this.sliderTickSpacing);
        jSlider.setValue(n);
    }

    public void fromSlider_stateChanged(ChangeEvent changeEvent) {
        if (this.fromSliderEnable) {
            this.fromSliderEvent = true;
            JSlider jSlider = (JSlider)changeEvent.getSource();
            Date date = this.fromSpinField.getStartTime();
            Date date2 = new Date(date.getTime() + (long)jSlider.getValue() * this.sliderTickSpacing);
            this.fromSpinField.setTime(date2);
            this.fromSliderEvent = false;
        }
    }

    public void toSlider_stateChanged(ChangeEvent changeEvent) {
        if (this.toSliderEnable) {
            this.toSliderEvent = true;
            JSlider jSlider = (JSlider)changeEvent.getSource();
            Date date = this.toSpinField.getStartTime();
            Date date2 = new Date(date.getTime() + (long)jSlider.getValue() * this.sliderTickSpacing);
            this.toSpinField.setTime(date2);
            this.toSliderEvent = false;
        }
    }

    public void setEnabledByRadioButton(boolean bl) {
        this.fromSpinField.setEnabled(bl);
        this.toSpinField.setEnabled(bl);
        this.fromSlider.setEnabled(bl);
        this.toSlider.setEnabled(bl);
        this.realtimeComboBox.setEnabled(!bl);
    }

    public void applyButton_actionPerformed(ActionEvent actionEvent) {
        RJHihMonitoringInfo rJHihMonitoringInfo = this.supplier.getMonitoringInfo();
        rJHihMonitoringInfo.setMonitoringTime(this.fromSpinField.getTime(), this.toSpinField.getTime());
        rJHihMonitoringInfo.setMode(0);
        if (this.realtimeRadioButton.isSelected()) {
            rJHihMonitoringInfo.setMode(1);
            rJHihMonitoringInfo.setRealTimeInterval(this.realtimeComboBox.getSelectedIndex());
        }
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
        this.fromSpinField.setFixed(true);
        this.toSpinField.setFixed(true);
    }

    public void setViewPanel(RJHihMonitoringSWView rJHihMonitoringSWView) {
        this.viewPanel = rJHihMonitoringSWView;
    }
}

