/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.mrcf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import sanproject.client.com.RJCom;
import sanproject.client.com.RJComUty;
import sanproject.client.data.RJDataWndInf;
import sanproject.client.mrcf.RJMrcfFcCtgMediator;
import sanproject.client.mrcf.RJMrcfFcDataCtrl;
import sanproject.client.mrcf.RJMrcfMacro;
import sanproject.client.mrcf.RJMrcfNumberField;
import sanproject.client.mrcf.qs.RJQsDefaultDlgPnl;
import sanproject.serverux.dataimpl.RMCPCUofCUOption;

public class RJMrcfFcSetTimerPnl
extends RJQsDefaultDlgPnl
implements RJMrcfMacro {
    RJMrcfFcDataCtrl m_DataCtrl = null;
    ArrayList m_AlCu = null;
    int m_iDfltTm = -1;
    RJDataWndInf ST_TITLE = null;
    RJDataWndInf ST_TXT_TITLE = null;
    RJDataWndInf ST_TXT_AREA = null;
    JButton m_OkBtn = null;
    JButton m_CancelBtn = null;
    JLabel m_TmLbl = null;
    RJMrcfNumberField m_TmFld = null;
    boolean bEnd = false;

    RJMrcfFcSetTimerPnl(RJMrcfFcDataCtrl rJMrcfFcDataCtrl, ArrayList arrayList) {
        super(rJMrcfFcDataCtrl.siDataCtrl);
        this.m_DataCtrl = rJMrcfFcDataCtrl;
        this.m_AlCu = arrayList;
        this.initUseString();
        this.initWnd();
        this.initDisplay();
    }

    void initUseString() {
        this.ST_TITLE = RJCom.getWinInf(this.getDataCtl(), "HMRCF", "ST_TITLE", "Set SCP Delay Time", new Color(0, 0, 0));
        this.ST_TXT_TITLE = RJCom.getWinInf(this.getDataCtl(), "HMRCF", "FCT_TTL_SCPTM", "SCP Delay Time(sec.)", new Color(0, 0, 0));
        this.ST_TXT_AREA = RJCom.getWinInf(this.getDataCtl(), "HMRCF", "ST_TXT_AREA", "(0-600)", new Color(0, 0, 0));
    }

    void initWnd() {
        this.setPreferredSize(new Dimension(360, 130));
        super.setPanelTitle(this.ST_TITLE.getGuidance());
        this.m_OkBtn = super.getPnlBtn();
        this.m_OkBtn.setText(this.m_DataCtrl.siDataCtrl.OMR_COM_OK.getGuidance());
        this.m_OkBtn.setToolTipText(this.m_DataCtrl.siDataCtrl.OMR_COM_OK.getGuidance());
        this.m_OkBtn.setBackground(this.m_DataCtrl.siDataCtrl.OMR_DLG_BTN_BGCLR);
        super.setBtn(this.m_OkBtn);
        this.m_CancelBtn = super.getPnlBtn();
        this.m_CancelBtn.setText(this.m_DataCtrl.siDataCtrl.OMR_COM_CANCEL.getGuidance());
        this.m_CancelBtn.setToolTipText(this.m_DataCtrl.siDataCtrl.OMR_COM_CANCEL.getGuidance());
        this.m_CancelBtn.setBackground(this.m_DataCtrl.siDataCtrl.OMR_DLG_BTN_BGCLR);
        super.setBtn(this.m_CancelBtn);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(Color.white);
        jPanel.setLayout(new BorderLayout(4, 0));
        this.m_TmLbl = super.getPnlLabel();
        this.m_TmLbl.setText(this.ST_TXT_TITLE.getGuidance());
        this.m_TmLbl.setPreferredSize(new Dimension(170, 28));
        this.m_TmLbl.setBackground(this.m_DataCtrl.siDataCtrl.R700_DLG_LBL_BGCLR);
        this.m_TmLbl.setForeground(this.m_DataCtrl.siDataCtrl.OMR_COM_MIDTTL_FG.getColor());
        this.m_TmFld = new RJMrcfNumberField(3, 0, 600);
        this.m_TmFld.setItalic(false);
        JLabel jLabel = super.getPnlLabel();
        jLabel.setOpaque(false);
        jLabel.setText(this.ST_TXT_AREA.getGuidance());
        jLabel.setPreferredSize(new Dimension(72, 28));
        jPanel.add((Component)this.m_TmLbl, "West");
        jPanel.add((Component)this.m_TmFld, "Center");
        jPanel.add((Component)jLabel, "East");
        super.setCenterPnl(jPanel);
    }

    void initListener() {
        this.m_OkBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJMrcfFcSetTimerPnl.this.m_OkBtn_actionPerformed(actionEvent);
            }
        });
        this.m_CancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RJMrcfFcSetTimerPnl.this.m_CancelBtn_actionPerformed(actionEvent);
            }
        });
    }

    private void initDisplay() {
        int n = -1;
        boolean bl = true;
        if (this.m_AlCu != null && this.m_AlCu.size() != 0) {
            for (int i = 0; i < this.m_AlCu.size(); ++i) {
                Integer n2 = (Integer)this.m_AlCu.get(i);
                RMCPCUofCUOption rMCPCUofCUOption = this.m_DataCtrl.getCuOption(n2);
                if (rMCPCUofCUOption != null) {
                    if (i == 0) {
                        n = rMCPCUofCUOption.SusScpTime;
                        continue;
                    }
                    if (n == rMCPCUofCUOption.SusScpTime) continue;
                    bl = false;
                    break;
                }
                this.m_DataCtrl.putLog("TimerDlg", "initDisplay():Invalid data object.CU=" + n2);
                this.warningProcess();
                bl = false;
                break;
            }
            if (bl) {
                if (!this.m_DataCtrl.isValidTimerData(n)) {
                    this.m_DataCtrl.putLog("TimerDlg", "initDisplay():Invalid get data.Timer=" + n);
                    n = 120;
                }
                this.m_iDfltTm = n;
                this.m_TmFld.setText(Integer.toString(this.m_iDfltTm));
            } else {
                this.m_TmFld.setText("");
            }
            this.m_TmFld.setMediator(new RJMrcfFcCtgMediator(this.m_iDfltTm, this.m_TmFld));
        } else {
            this.m_DataCtrl.putLog("TimerDlg", "initDisplay():Invalid specified CU.");
            this.warningProcess();
        }
        this.initListener();
    }

    void warningProcess() {
        Object[] objectArray = new Object[]{this.m_DataCtrl.siDataCtrl.OMR_COM_OK.getGuidance()};
        this.m_OkBtn.setEnabled(false);
        this.m_TmFld.setEnabled(false);
        this.m_DataCtrl.siDataCtrl.showInternalMsg(this, 7440, 1);
    }

    public boolean isBEnd() {
        return this.bEnd;
    }

    public void setPresetData() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_TmFld.getText();
        int n = -1;
        boolean bl = true;
        if (string != null && string.length() != 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_DataCtrl.putLog("setPresetData", "Invalid specified timer. Data=" + string);
                numberFormatException.printStackTrace();
            }
            if (n != -1) {
                if (this.m_DataCtrl.isValidTimerData(n)) {
                    for (int i = 0; i < this.m_AlCu.size(); ++i) {
                        Integer n2 = (Integer)this.m_AlCu.get(i);
                        this.m_DataCtrl.setCuOption(n2, n);
                        if (i != 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(RJComUty.itoh(n2, 2));
                    }
                    this.m_DataCtrl.putLog("setPresetData", "CU=" + stringBuffer.toString() + " Tm=" + n);
                } else {
                    this.m_DataCtrl.putLog("setPresetData", "Invalid specified timer. Timer=" + n);
                }
            } else {
                this.m_DataCtrl.putLog("setPresetData", "Invalid specified timer. Timer=" + n);
            }
        } else {
            this.m_DataCtrl.putLog("setPresetData", "No data.");
        }
    }

    void m_OkBtn_actionPerformed(ActionEvent actionEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_TmFld.getText();
        int n = -1;
        boolean bl = true;
        if (string != null && string.length() != 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.m_DataCtrl.putLog("TimerDlg", "Invalid specified timer. Data=" + string);
                numberFormatException.printStackTrace();
            }
            if (n != -1) {
                if (!this.m_DataCtrl.isValidTimerData(n)) {
                    this.m_DataCtrl.putLog("TimerDlg", "Invalid specified timer. Timer=" + n);
                    this.m_DataCtrl.siDataCtrl.showInternalMsg(this, 55597, 1);
                    bl = false;
                }
            } else {
                this.m_DataCtrl.putLog("TimerDlg", "Invalid specified timer. Timer=" + n);
                this.m_DataCtrl.siDataCtrl.showInternalMsg(this, 7440, 1);
                bl = false;
            }
        } else {
            this.m_DataCtrl.putLog("TimerDlg", "No data.");
        }
        if (bl) {
            this.m_DataCtrl.putLog("TimerDlg", "End dialog(OK).");
            this.bEnd = true;
            this.m_DataCtrl.siDataCtrl.nowDlg.dispose();
        }
    }

    void m_CancelBtn_actionPerformed(ActionEvent actionEvent) {
        this.m_DataCtrl.putLog("TimerDlg", "End dialog(Cancel).");
        this.bEnd = false;
        this.m_DataCtrl.siDataCtrl.nowDlg.dispose();
    }
}

