/*
 * Decompiled with CFR 0.152.
 */
package sanproject.client.openldevguard.gui.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sanproject.client.com.RJComDialog;
import sanproject.client.data.RJDataMsg;
import sanproject.client.openldevguard.color.ColorManager;
import sanproject.client.openldevguard.com.KeyEventReceiver;
import sanproject.client.openldevguard.com.KeyEventTransferable;
import sanproject.client.openldevguard.com.TableSortedListener;
import sanproject.client.openldevguard.gui.ComponentFactory;
import sanproject.client.openldevguard.gui.ComponentUtilities;
import sanproject.client.openldevguard.gui.OpenLDEVGuardException;
import sanproject.client.openldevguard.gui.OpenLDEVGuardProperties;
import sanproject.client.openldevguard.gui.SortKindTableHeader;
import sanproject.client.openldevguard.gui.logging.Logger;
import sanproject.client.openldevguard.gui.main.LDEVWrapper;
import sanproject.client.openldevguard.gui.main.OpenLDEVGuardDataControlWrapper;
import sanproject.client.openldevguard.gui.main.ShortcutKey;
import sanproject.client.openldevguard.gui.main.ShortcutKeySupport;
import sanproject.client.openldevguard.gui.main.StandardComponentFactory;
import sanproject.client.openldevguard.gui.main.TableDataItemTableCellRenderer;
import sanproject.client.openldevguard.gui.main.ViewDefine;
import sanproject.client.openldevguard.gui.main.VolumeDetailTableModel;

class VolumeDetailDialogPanel
extends JPanel
implements KeyEventReceiver,
ShortcutKeySupport {
    private static final String MODULE_NAME = "VolumeDetail";
    private Set msetShortcutKeys;
    private OpenLDEVGuardDataControlWrapper mdcwWrapper;
    private LDEVWrapper mldwLDEVWrapper;
    private JTable mtblDetailTable;
    private VolumeDetailTableModel mtamTableModel;
    private JButton mbtnDialogClose;
    static /* synthetic */ Class class$sanproject$client$openldevguard$gui$main$TableDataItem;
    static /* synthetic */ Class class$java$awt$Dialog;

    VolumeDetailDialogPanel(OpenLDEVGuardDataControlWrapper openLDEVGuardDataControlWrapper, final LDEVWrapper lDEVWrapper) {
        this.mdcwWrapper = openLDEVGuardDataControlWrapper;
        this.mldwLDEVWrapper = lDEVWrapper;
        this.msetShortcutKeys = new HashSet();
        ContainerListener containerListener = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                VolumeDetailDialogPanel.this.addComponent(containerEvent);
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                VolumeDetailDialogPanel.this.removeComponent(containerEvent);
            }
        };
        this.addContainerListener(containerListener);
        ComponentFactory componentFactory = StandardComponentFactory.getComponentFactory();
        Object object = new TableDataItemTableCellRenderer();
        Object object2 = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point;
                int n;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                Rectangle rectangle = jTableHeader.getHeaderRect(n = jTableHeader.columnAtPoint(point = mouseEvent.getPoint()));
                Rectangle rectangle2 = ComponentUtilities.getClickableRectangle(rectangle);
                if (rectangle2.contains(point)) {
                    VolumeDetailDialogPanel.this.requestTableSort(n);
                }
            }
        };
        Object object3 = ViewDefine.isSupportSortKindHeader() ? new SortKindTableHeader() : new JTableHeader();
        ((Component)object3).addMouseListener((MouseListener)object2);
        ((JTableHeader)object3).setReorderingAllowed(false);
        ComponentUtilities.supportMouseClick((JTableHeader)object3);
        this.mtamTableModel = new VolumeDetailTableModel(openLDEVGuardDataControlWrapper);
        if (object3 instanceof TableSortedListener) {
            object2 = (TableSortedListener)object3;
            this.mtamTableModel.addTableSortedListener((TableSortedListener)object2);
        }
        this.mtblDetailTable = componentFactory.createTable();
        this.mtblDetailTable.setDefaultRenderer(class$sanproject$client$openldevguard$gui$main$TableDataItem == null ? (class$sanproject$client$openldevguard$gui$main$TableDataItem = VolumeDetailDialogPanel.class$("sanproject.client.openldevguard.gui.main.TableDataItem")) : class$sanproject$client$openldevguard$gui$main$TableDataItem, (TableCellRenderer)object);
        this.mtblDetailTable.setTableHeader((JTableHeader)object3);
        this.mtblDetailTable.setModel(this.mtamTableModel);
        object2 = this.mtblDetailTable.getColumnModel();
        ((JTableHeader)object3).setColumnModel((TableColumnModel)object2);
        int n = 2;
        Object object4 = this.mtblDetailTable.getSelectionModel();
        object4.setSelectionMode(n);
        ComponentUtilities.supportRightClickSelection(this.mtblDetailTable);
        ComponentUtilities.supportRepaintWhenFocusMoved(this.mtblDetailTable);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VolumeDetailDialogPanel.this.doButtonAction(actionEvent);
            }
        };
        object3 = "COMMON/Close";
        object2 = openLDEVGuardDataControlWrapper.getGuidanceString((String)object3);
        object4 = openLDEVGuardDataControlWrapper.getGuidanceColor((String)object3);
        this.mbtnDialogClose = componentFactory.createButton((String)object2);
        this.mbtnDialogClose.addActionListener((ActionListener)object);
        this.mbtnDialogClose.setForeground((Color)object4);
        object2 = openLDEVGuardDataControlWrapper.getGuidanceString("LDEV Guard/STRING_DPT_LDEVDETAIL");
        object3 = ComponentUtilities.buildTitlePanel(componentFactory, (String)object2);
        object2 = new BorderLayout(4, 4);
        object = componentFactory.createPanel();
        ((Container)object).setLayout((LayoutManager)object2);
        ((JComponent)object).setOpaque(false);
        ((Container)object).add((Component)object3, "West");
        object4 = new Dimension(239, 220);
        object2 = componentFactory.createScrollPane(this.mtblDetailTable);
        ((JComponent)object2).setPreferredSize((Dimension)object4);
        ((JScrollPane)object2).setHorizontalScrollBarPolicy(30);
        ((JScrollPane)object2).setVerticalScrollBarPolicy(22);
        ComponentUtilities.decorateTransparentViewport((JScrollPane)object2);
        ComponentUtilities.decorateInputAreaBorder((JComponent)object2);
        object4 = new BorderLayout(4, 4);
        object3 = componentFactory.createPanel();
        ((Container)object3).setLayout((LayoutManager)object4);
        ((JComponent)object3).setOpaque(false);
        ((Container)object3).add((Component)object2, "Center");
        Serializable serializable = new GridLayout(1, 0, 4, 4);
        object4 = componentFactory.createPanel();
        ((Container)object4).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).add(this.mbtnDialogClose);
        ComponentUtilities.decorateInputAreaMarginBorder((JComponent)object4);
        serializable = new BorderLayout(4, 4);
        object2 = componentFactory.createPanel();
        ((Container)object2).setLayout((LayoutManager)((Object)serializable));
        ((JComponent)object2).setOpaque(false);
        ((Container)object2).add((Component)object4, "East");
        object4 = ColorManager.getInstance();
        serializable = ((ColorManager)object4).getPanelBackground();
        BorderLayout borderLayout = new BorderLayout(4, 4);
        this.setLayout(borderLayout);
        this.setOpaque(true);
        this.setBackground((Color)serializable);
        this.add((Component)object, "North");
        this.add((Component)object3, "Center");
        this.add((Component)object2, "South");
        ComponentUtilities.decoratePanelAreaMarginBorder(this);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    VolumeDetailDialogPanel.this.mtamTableModel.initializeData(lDEVWrapper);
                    VolumeDetailDialogPanel.this.loadColumnWidths();
                }
                catch (OpenLDEVGuardException openLDEVGuardException) {
                    VolumeDetailDialogPanel.this.processException(openLDEVGuardException);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void keyEventReceived(KeyEventTransferable keyEventTransferable, KeyEvent keyEvent) {
        Set set;
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        String string = KeyEvent.getKeyText(n);
        String string2 = KeyEvent.getKeyModifiersText(n2);
        Logger.put(Level.FINEST, MODULE_NAME, "    keyEventReceived()    [" + string2 + " + " + string + "]");
        Object object = this.msetShortcutKeys;
        synchronized (object) {
            set = Collections.synchronizedSet(this.msetShortcutKeys);
        }
        object = set.iterator();
        while (object.hasNext() && !keyEvent.isConsumed()) {
            ShortcutKey shortcutKey = (ShortcutKey)object.next();
            shortcutKey.keyEventHappened(this, keyEvent);
        }
    }

    public final Set getShortcutKeys() {
        HashSet hashSet = new HashSet(this.msetShortcutKeys);
        return hashSet;
    }

    public final void addShortcutKey(ShortcutKey shortcutKey) {
        Logger.put(Level.FINEST, MODULE_NAME, "add shortcut key. [" + shortcutKey + "]");
        this.msetShortcutKeys.add(shortcutKey);
    }

    public final void removeShortcutKey(ShortcutKey shortcutKey) {
        Logger.put(Level.FINEST, MODULE_NAME, "remove shortcut key. [" + shortcutKey + "]");
        this.msetShortcutKeys.remove(shortcutKey);
    }

    private void addComponent(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            KeyEventTransferable keyEventTransferable = (KeyEventTransferable)((Object)component);
            keyEventTransferable.addKeyEventReceiver(this);
        }
    }

    private void removeComponent(ContainerEvent containerEvent) {
        Object object;
        Component component = containerEvent.getChild();
        if (component instanceof KeyEventTransferable) {
            object = (KeyEventTransferable)((Object)component);
            object.removeKeyEventReceiver(this);
        }
        if (component instanceof Container) {
            object = (Container)component;
            ((Container)object).removeAll();
        }
    }

    private void loadColumnWidths() {
        TableColumnModel tableColumnModel = this.mtblDetailTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        Logger.put(Level.FINER, MODULE_NAME, "load column widths.");
        for (int i = 0; i < n; ++i) {
            String string = this.mtamTableModel.getColumnID(i);
            if (string == null) continue;
            String string2 = "columnwidth_" + string;
            String string3 = OpenLDEVGuardProperties.getProperty(string2);
            int n2 = 75;
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = String.valueOf(n2);
                OpenLDEVGuardProperties.setProperty(string2, string4);
            }
            Logger.put(Level.FINEST, MODULE_NAME, "    " + string2 + " => " + n2);
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n2);
        }
    }

    private void saveColumnWidths() {
        TableColumnModel tableColumnModel = this.mtblDetailTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        Logger.put(Level.FINER, MODULE_NAME, "save column widths.");
        for (int i = 0; i < n; ++i) {
            String string = this.mtamTableModel.getColumnID(i);
            if (string == null) continue;
            String string2 = "columnwidth_" + string;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = tableColumn.getPreferredWidth();
            String string3 = String.valueOf(n2);
            OpenLDEVGuardProperties.setProperty(string2, string3);
            Logger.put(Level.FINEST, MODULE_NAME, "    " + string2 + " <= " + n2);
        }
    }

    private void doButtonAction(ActionEvent actionEvent) {
        Dialog dialog;
        Object object = actionEvent.getSource();
        if (object.equals(this.mbtnDialogClose) && (dialog = (Dialog)SwingUtilities.getAncestorOfClass(class$java$awt$Dialog == null ? (class$java$awt$Dialog = VolumeDetailDialogPanel.class$("java.awt.Dialog")) : class$java$awt$Dialog, this)) != null) {
            this.saveColumnWidths();
            this.removeAll();
            dialog.dispose();
        }
    }

    private void requestTableSort(int n) {
        Cursor cursor = new Cursor(3);
        Cursor cursor2 = new Cursor(0);
        this.setCursor(cursor);
        this.mtamTableModel.requestSort(n);
        this.setCursor(cursor2);
    }

    private void processException(OpenLDEVGuardException openLDEVGuardException) {
        RJDataMsg rJDataMsg = openLDEVGuardException.getMessageObject();
        String string = rJDataMsg.getMessage();
        Throwable throwable = openLDEVGuardException.getCause();
        if (throwable != null) {
            string = string + "[" + throwable.getMessage() + "]";
        }
        Logger.put(Level.SEVERE, MODULE_NAME, string);
        Object[] objectArray = new Object[]{this.mdcwWrapper.getGuidanceString("COMMON/OK")};
        RJComDialog.show(this, rJDataMsg, 0, objectArray, objectArray[0]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

